/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.postcontrol;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.TimeSelector;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.BemCalendar;

public class TimeSettingPostController
implements SubInstaller {
    private Installer theInstaller = null;
    private String theDescription = "Configuration of time settings";
    private int progressReports = 5;
    private final WizardCIModel oamCIModel;
    private final Rbs rbs;
    private MoHandler theMoHandler = null;
    private TimeSelector theTimeSelector = null;
    private String theName = null;

    public TimeSettingPostController(Installer installer) {
        this.theInstaller = installer;
        this.oamCIModel = OamCIModel.getInstance();
        this.rbs = this.oamCIModel.getRbs();
        this.theMoHandler = this.rbs.getMoHandler();
        this.theTimeSelector = (TimeSelector)((Object)this.oamCIModel);
        this.theName = this.getClass().getName();
    }

    public boolean install() throws WizardException {
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.progressReports;
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        String string = WizardCommon.WIZARD_LDN_MANAGEDELEMENTDATA;
        BemMo bemMo = this.theMoHandler.getMo(string);
        this.theDescription = "Updating time settings";
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.progressReports;
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        this.setTimeIfChanged(bemMo);
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.progressReports;
        while (this.progressReports > 0) {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.progressReports;
        }
        return true;
    }

    public int getTotalNoOfProgressReports() {
        return this.progressReports;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }

    private void setTimeIfChanged(BemMo bemMo) throws WizardException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>(0, 1);
        boolean bl = this.isAnyNtpServiceActive();
        if (!bl && this.theTimeSelector.hasUserEnteredTime()) {
            BemCalendar bemCalendar = this.theTimeSelector.getNodeTimeStamp();
            long l = bemCalendar.getUtcTime();
            Long l2 = l;
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("nodeUTCTime", l2);
            vector.add(nalNameValue);
        }
        if (vector.size() > 0) {
            try {
                this.theMoHandler.setAttributes(bemMo, vector);
            }
            catch (Exception exception) {
                throw new WizardException("setAttributes()", bemMo.getDN(), (Throwable)exception);
            }
        }
    }

    private boolean isAnyNtpServiceActive() throws WizardException {
        boolean bl = false;
        try {
            String string = this.rbs.getCustomerParameter("primaryNtpServiceActive");
            String string2 = this.rbs.getCustomerParameter("secondaryNtpServiceActive");
            if (string.equalsIgnoreCase("YES") || string2.equalsIgnoreCase("YES")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new WizardException("Reading NtpActive Customer Parameters", "", (Throwable)exception);
        }
        return bl;
    }
}

