/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.RetCascadingView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.RetCascadingViewer;

public class RetCascadingController
extends BemWizardGuiController {
    public static final int N_A = -1;
    public static final int OPTIONAL = 0;
    public static final int MANDATORY = 1;
    public static final int VALID_INPUT = 2;
    public static final int INVALID_INPUT = 3;
    private static final int MAX_NUM_OF_ANTENNAS = 2;
    private int maxNoOfsectors;
    private int maxNoOfSequences;
    private RetCascadingViewer myView = null;
    private WizardCIModel wizardCiModel;
    private Rbs rbs;
    private final List customerParameterNames = new ArrayList();
    private JTable secterAntennaOverviewTable;
    private JTable retOverviewTable;
    public int selectedRowSectorAntennaOverview = -1;
    public int selectedColSectorAntennaOverview = -1;
    public int selectedRowRetOverview = -1;
    public int selectedColRetOverview = -1;
    private Vector<SectorAntenna[]> activeSectorAntennas = null;
    private int[] equipedSectors = null;
    private DocumentListener listenerOfTextField = null;
    private ListSelectionListener listenerOfSATable = null;
    private ListSelectionListener listenerOfRetTable = null;

    protected void init() {
        this.myView = (RetCascadingViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
        this.rbs = this.wizardCiModel.getRbs();
        this.maxNoOfsectors = this.rbs.getMaxNumberOfSectors();
        this.maxNoOfSequences = this.rbs.getMaxNumberOfSequences();
        RadioEquipmentProvider[] radioEquipmentProviderArray = new RadioEquipmentProvider[2];
        radioEquipmentProviderArray[0] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class);
        int[] nArray = radioEquipmentProviderArray[0].getEquippedSectors();
        if (this.rbs.isPantherHybridRbs()) {
            radioEquipmentProviderArray[1] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class, 1);
            int[] nArray2 = radioEquipmentProviderArray[1].getEquippedSectors();
            this.equipedSectors = WizardHelp.mergeIntArray(nArray, nArray2);
        } else {
            this.equipedSectors = nArray;
        }
        ((RetCascadingView)this.myView).setController(this);
        ((RetCascadingView)this.myView).initConfigFlags(this.maxNoOfsectors, 2, this.maxNoOfSequences);
    }

    protected void beforeVisible() {
        this.activeSectorAntennas = new Vector();
        this.arrangeSectorAntennaOverviewTable();
        this.arrangeRetOverviewTable();
        this.arrangeRetTable();
        SectorAntenna[] sectorAntennaArray = null;
        for (int i = 0; i < this.activeSectorAntennas.size(); ++i) {
            for (int j = 1; j <= this.retOverviewTable.getRowCount(); ++j) {
                sectorAntennaArray = this.activeSectorAntennas.get(i);
                for (int k = 0; k < sectorAntennaArray.length; ++k) {
                    int n = this.checkInputValidation(sectorAntennaArray[k], j);
                    if (n == 1 && j > 1) {
                        n = 0;
                    }
                    this.changeTableCellStatus(i + 1, sectorAntennaArray[k].getAntennaNum() - 1, j - 1, n);
                }
            }
        }
    }

    private void arrangeSectorAntennaOverviewTable() {
        Vector<String> vector = new Vector<String>();
        Vector<SectorAntenna> vector2 = null;
        int n = 2;
        vector.add("Sector Antenna");
        try {
            for (int i = 1; i <= this.rbs.getMaxNumberOfSectors(); ++i) {
                String string = Integer.toString(i);
                String string2 = MessageFormat.format("S{0}_", string);
                String[] stringArray = new String[2];
                stringArray[0] = string2 + "typeOfRet";
                int n2 = 1;
                while (true) {
                    if (n2 >= 2) break;
                    stringArray[n2] = string2 + "typeOfRet" + String.valueOf(n2 + 1);
                    ++n2;
                }
                vector2 = new Vector<SectorAntenna>(2);
                n2 = 0;
                while (true) {
                    CustomerParameter customerParameter;
                    if (n2 >= 2) break;
                    if (this.rbs.isParameterSupported(stringArray[n2]) && (customerParameter = this.rbs.getCustomerParameterObject(stringArray[n2])).getValue().equals("ARETU_CASCADE")) {
                        vector2.add(new SectorAntenna(i, n2 + 1));
                    }
                    ++n2;
                }
                if (!vector2.isEmpty()) {
                    vector.add("Sector " + string);
                    SectorAntenna[] sectorAntennaArray = new SectorAntenna[vector2.size()];
                    vector2.toArray(sectorAntennaArray);
                    this.activeSectorAntennas.add(sectorAntennaArray);
                }
                if (vector2.size() <= n) continue;
                n = vector2.size();
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
        }
        String[] stringArray = vector.toArray(new String[vector.size()]);
        Object[][] objectArray = new Object[n][stringArray.length];
        for (int i = 0; i < n; ++i) {
            objectArray[i][0] = Integer.toString(i + 1);
            for (int j = 1; j < stringArray.length; ++j) {
                objectArray[i][j] = "";
            }
        }
        this.secterAntennaOverviewTable = this.myView.setSectorAntennaOverviewParameters(objectArray, stringArray);
        ListSelectionModel listSelectionModel = this.secterAntennaOverviewTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.listenerOfSATable = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = RetCascadingController.this.secterAntennaOverviewTable.getSelectedRows();
                int[] nArray2 = RetCascadingController.this.secterAntennaOverviewTable.getSelectedColumns();
                boolean bl = false;
                if (nArray.length > 0 && nArray2.length > 0) {
                    if (RetCascadingController.this.selectedRowSectorAntennaOverview != nArray[0] || RetCascadingController.this.selectedColSectorAntennaOverview != nArray2[0]) {
                        RetCascadingController.this.selectedRowSectorAntennaOverview = nArray[0];
                        RetCascadingController.this.selectedColSectorAntennaOverview = nArray2[0];
                        bl = true;
                    }
                } else if (RetCascadingController.this.selectedRowSectorAntennaOverview != -1 && RetCascadingController.this.selectedColSectorAntennaOverview != -1) {
                    RetCascadingController.this.selectedRowSectorAntennaOverview = -1;
                    RetCascadingController.this.selectedColSectorAntennaOverview = -1;
                    bl = true;
                }
                if (bl) {
                    RetCascadingController.this.arrangeRetOverviewTable();
                    RetCascadingController.this.arrangeRetTable();
                }
            }
        };
        listSelectionModel.addListSelectionListener(this.listenerOfSATable);
        this.secterAntennaOverviewTable.getColumnModel().getSelectionModel().addListSelectionListener(this.listenerOfSATable);
    }

    private void arrangeRetOverviewTable() {
        Object[][] objectArray;
        Object[] objectArray2;
        String string = "SectorAntenna ";
        if (this.selectedColSectorAntennaOverview > 0 && this.selectedRowSectorAntennaOverview > -1 && this.selectedRowSectorAntennaOverview < (objectArray2 = this.activeSectorAntennas.get(this.selectedColSectorAntennaOverview - 1)).length) {
            objectArray = objectArray2[this.selectedRowSectorAntennaOverview];
            string = string + objectArray.getSectorString() + "-" + objectArray.getAntennaString();
        }
        objectArray2 = new String[]{"Sequence Number", string};
        objectArray = new Object[this.maxNoOfSequences][objectArray2.length];
        for (int i = 0; i < this.maxNoOfSequences; ++i) {
            objectArray[i][0] = Integer.toString(i + 1);
            for (int j = 1; j < objectArray2.length; ++j) {
                objectArray[i][j] = "";
            }
        }
        this.retOverviewTable = this.myView.setRetOverviewParameters(objectArray, (String[])objectArray2);
        ListSelectionModel listSelectionModel = this.retOverviewTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.listenerOfRetTable = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = RetCascadingController.this.retOverviewTable.getSelectedRows();
                int[] nArray2 = RetCascadingController.this.retOverviewTable.getSelectedColumns();
                boolean bl = false;
                if (nArray.length > 0 && nArray2.length > 0) {
                    if (RetCascadingController.this.selectedRowRetOverview != nArray[0] || RetCascadingController.this.selectedColRetOverview != nArray2[0]) {
                        RetCascadingController.this.selectedRowRetOverview = nArray[0];
                        RetCascadingController.this.selectedColRetOverview = nArray2[0];
                        bl = true;
                    }
                } else if (RetCascadingController.this.selectedRowRetOverview != -1 && RetCascadingController.this.selectedColRetOverview != -1) {
                    RetCascadingController.this.selectedRowRetOverview = -1;
                    RetCascadingController.this.selectedColRetOverview = -1;
                    bl = true;
                }
                if (bl) {
                    RetCascadingController.this.arrangeRetTable();
                }
            }
        };
        listSelectionModel.addListSelectionListener(this.listenerOfRetTable);
        this.retOverviewTable.getColumnModel().getSelectionModel().addListSelectionListener(this.listenerOfRetTable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void arrangeRetTable() {
        SectorAntenna sectorAntenna = null;
        CustomerParameter customerParameter = null;
        CustomerParameter customerParameter2 = null;
        CustomerParameter customerParameter3 = null;
        CustomerParameter customerParameter4 = null;
        CustomerParameter customerParameter5 = null;
        try {
            block12: {
                block11: {
                    if (this.selectedColSectorAntennaOverview < 1 || this.selectedRowSectorAntennaOverview < 0 || this.selectedRowRetOverview < 0) break block11;
                    if (this.myView.getConfigFlags()[this.selectedColSectorAntennaOverview][this.selectedRowSectorAntennaOverview][this.selectedRowRetOverview] != -1) break block12;
                }
                String string = "-";
                this.myView.setRetConfigurationParameters(0, 0, string, null, null, null, null, null, null);
                return;
            }
            sectorAntenna = this.activeSectorAntennas.get(this.selectedColSectorAntennaOverview - 1).length == 1 && this.selectedRowSectorAntennaOverview == 1 ? this.activeSectorAntennas.get(this.selectedColSectorAntennaOverview - 1)[this.selectedRowSectorAntennaOverview - 1] : this.activeSectorAntennas.get(this.selectedColSectorAntennaOverview - 1)[this.selectedRowSectorAntennaOverview];
            int n = sectorAntenna.getAntennaNum();
            String string = Integer.toString(this.selectedRowRetOverview + 1);
            String string2 = MessageFormat.format("S{0}_", sectorAntenna.getSectorString());
            string2 = string2 + MessageFormat.format("SEQ{0}_", string);
            String string3 = BemUtil.getCustomerParameterName(string2, "antennaType", n);
            customerParameter = this.rbs.getCustomerParameterObject(string3);
            if (!this.customerParameterNames.contains(string3)) {
                this.customerParameterNames.add(string3);
            }
            string3 = BemUtil.getCustomerParameterName(string2, "userLabel", n);
            customerParameter2 = this.rbs.getCustomerParameterObject(string3);
            if (!this.customerParameterNames.contains(string3)) {
                this.customerParameterNames.add(string3);
            }
            string3 = BemUtil.getCustomerParameterName(string2, "uniqueHwId", n);
            customerParameter3 = this.rbs.getCustomerParameterObject(string3);
            if (!this.customerParameterNames.contains(string3)) {
                this.customerParameterNames.add(string3);
            }
            string3 = BemUtil.getCustomerParameterName(string2, "electricalTilt", n);
            customerParameter4 = this.rbs.getCustomerParameterObject(string3);
            if (!this.customerParameterNames.contains(string3)) {
                this.customerParameterNames.add(string3);
            }
            if (string.equals("1")) {
                string3 = BemUtil.getCustomerParameterName(string2, "mechanicalTilt", n);
                customerParameter5 = this.rbs.getCustomerParameterObject(string3);
                if (!this.customerParameterNames.contains(string3)) {
                    this.customerParameterNames.add(string3);
                }
            }
            this.listenerOfTextField = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    RetCascadingController.this.updateText();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    RetCascadingController.this.updateText();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    RetCascadingController.this.updateText();
                }
            };
            this.myView.setRetConfigurationParameters(sectorAntenna.getSectorNum(), sectorAntenna.getAntennaNum(), string, customerParameter, customerParameter3, customerParameter4, customerParameter5, customerParameter2, this.listenerOfTextField);
            return;
        }
        catch (BemException bemException) {
            this.displayError(bemException);
        }
    }

    private void updateText() {
        if (this.selectedColSectorAntennaOverview < 0 || this.selectedRowSectorAntennaOverview < 0 || this.selectedRowRetOverview < 0) {
            return;
        }
        this.changeTableCellStatus(this.selectedColSectorAntennaOverview, this.selectedRowSectorAntennaOverview, this.selectedRowRetOverview, 2);
    }

    public int checkInputValidation(SectorAntenna sectorAntenna, int n) {
        String string = Integer.toString(sectorAntenna.getSectorNum());
        int n2 = sectorAntenna.getAntennaNum();
        String string2 = n2 > 1 ? Integer.toString(n2) : "";
        String string3 = MessageFormat.format("S{0}_", string);
        string3 = string3 + MessageFormat.format("SEQ{0}_", n);
        Vector<String> vector = new Vector<String>();
        vector.add(string3 + "antennaType" + string2);
        vector.add(string3 + "uniqueHwId" + string2);
        vector.add(string3 + "electricalTilt" + string2);
        if (n == 1) {
            vector.add(string3 + "mechanicalTilt" + string2);
        }
        vector.add(string3 + "userLabel" + string2);
        try {
            for (String string4 : vector) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string4);
                if (customerParameter.isDefault() || customerParameter.getValue().equals("") || customerParameter.getValue().equals("##UNDEFINED")) continue;
                for (String string5 : vector) {
                    customerParameter = this.rbs.getCustomerParameterObject(string5);
                    if (!customerParameter.isValidValue()) {
                        return 3;
                    }
                    if (!string5.endsWith("uniqueHwId") && !string5.substring(0, string5.length() - 2).endsWith("uniqueHwId") || !customerParameter.getValue().equals("")) continue;
                    return 3;
                }
                return 2;
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
            return 1;
        }
        return 1;
    }

    public boolean checkUniqueHwIdConsistency() throws BemException {
        String string = null;
        for (int i = 0; i < this.activeSectorAntennas.size(); ++i) {
            Vector<String> vector = new Vector<String>();
            String string2 = null;
            SectorAntenna[] sectorAntennaArray = this.activeSectorAntennas.get(i);
            int n = sectorAntennaArray[0].getSectorNum();
            for (int j = 0; j < sectorAntennaArray.length; ++j) {
                int n2 = sectorAntennaArray[j].getAntennaNum();
                for (int k = 1; k <= this.maxNoOfSequences; ++k) {
                    string = MessageFormat.format("S{0}_", Integer.toString(n));
                    string = string + MessageFormat.format("SEQ{0}_", k);
                    CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string = string + "uniqueHwId" + (n2 == 1 ? "" : Integer.toString(n2)));
                    string2 = customerParameter.getValue();
                    if (vector.contains(string2)) {
                        this.displayErrorMessage("The unique hardware id for sector " + n + ", antenna " + n2 + ", sequence " + k + " allready exists.\n All uniqueHwIds must be different in one sector.");
                        this.changeTableCellStatus(i + 1, n2, k - 1, 3);
                        return false;
                    }
                    if (string2.equals("##UNDEFINED") || string2.equals("")) continue;
                    vector.add(customerParameter.getValue());
                }
            }
        }
        return true;
    }

    public int[] getEquipedSectors() {
        return this.equipedSectors;
    }

    private boolean checkActiveSequences() {
        String string = null;
        String string2 = null;
        for (int i = 0; i < this.activeSectorAntennas.size(); ++i) {
            boolean bl = false;
            SectorAntenna[] sectorAntennaArray = this.activeSectorAntennas.get(i);
            string = sectorAntennaArray[0].getSectorString();
            for (int j = 0; j < sectorAntennaArray.length; ++j) {
                string2 = sectorAntennaArray[j].getAntennaString();
                for (int k = 1; k <= this.maxNoOfSequences; ++k) {
                    int n = this.checkInputValidation(sectorAntennaArray[j], k);
                    this.changeTableCellStatus(i + 1, j, k - 1, n);
                    if (k == 1 && n == 1) {
                        this.displayErrorMessage("The external antenna in sequence 1 have to be configured for sector " + string + ", antenna " + string2 + ".");
                        return false;
                    }
                    if (n == 2) {
                        if (k <= 1) continue;
                        bl = true;
                        continue;
                    }
                    if (n != 3) continue;
                    this.displayErrorMessage("The external antenna for sector " + string + ", antenna " + string2 + ", sequence " + k + ", is not configured correctly.");
                    return false;
                }
            }
            if (bl) continue;
            this.displayErrorMessage("At least two external antennas have to be configured for sector " + string + ", antenna " + string2 + ".");
            return false;
        }
        return true;
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.customerParameterNames.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                if (customerParameter.isDefault()) continue;
                if (customerParameter.getValue().equals("")) {
                    customerParameter.setValue("##UNDEFINED");
                    continue;
                }
                arrayList.add(string);
            }
            this.rbs.checkConsistency("AntennaSystemCI", arrayList);
            bl = this.checkUniqueHwIdConsistency();
            if (bl) {
                bl = this.checkActiveSequences();
            }
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            String string2 = this.myView.getGuiNameForCustomerParameter(string);
            String string3 = customerParameterException.getReason();
            this.displayErrorMessage(string2 + ":\n" + string3);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        this.myView.removeListenerOfTextField(this.listenerOfTextField);
        this.secterAntennaOverviewTable.getSelectionModel().removeListSelectionListener(this.listenerOfSATable);
        this.secterAntennaOverviewTable.getColumnModel().getSelectionModel().removeListSelectionListener(this.listenerOfSATable);
        this.retOverviewTable.getSelectionModel().removeListSelectionListener(this.listenerOfRetTable);
        this.retOverviewTable.getColumnModel().getSelectionModel().removeListSelectionListener(this.listenerOfRetTable);
        return true;
    }

    protected void refresh() {
        RadioEquipmentProvider radioEquipmentProvider = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class);
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        if (this.rbs.isPantherHybridRbs()) {
            RadioEquipmentProvider radioEquipmentProvider2 = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class, 1);
            int[] nArray2 = radioEquipmentProvider2.getEquippedSectors();
            this.equipedSectors = WizardHelp.mergeIntArray(nArray, nArray2);
        } else {
            this.equipedSectors = nArray;
        }
    }

    public void changeTableCellStatus(int n, int n2, int n3, int n4) {
        int[][][] nArray = this.myView.getConfigFlags();
        nArray[n][n2][n3] = n4;
    }

    private static class SectorAntenna {
        private int sectorNum;
        private int antennaNum;

        public SectorAntenna(int n, int n2) {
            this.sectorNum = n;
            this.antennaNum = n2;
        }

        public int getSectorNum() {
            return this.sectorNum;
        }

        public int getAntennaNum() {
            return this.antennaNum;
        }

        public String getSectorString() {
            return Integer.toString(this.sectorNum);
        }

        public String getAntennaString() {
            return Integer.toString(this.antennaNum);
        }
    }
}

