/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.AntennaCablesController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.RadioBuildingBlockListener;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SectorOptionsDuwView;

public class SectorOptionsDuwController
extends BemWizardGuiController {
    private SectorOptionsDuwView view;
    private Rbs rbs;
    private final List customerParameterNames = new ArrayList();
    private int noOfSectors;
    private Enumeration[] radioBuildingBlockParameters;
    private Enumeration[] sectorSequenceParameters;
    private Enumeration[] primaryPortIdParameters;
    private Enumeration[] secondaryPortIdParameters;
    private Enumeration[] lineRateParameters;
    private Enumeration[] auUnitTypeParameters;
    private Enumeration[] radioSharedBySectorParameters;
    private RadioBuildingBlockListener[] rbbListeners;

    protected void init() {
        this.view = (SectorOptionsDuwView)this.getView();
        this.wizardHelp = WizardHelp.getTheInstance();
        this.rbs = SiteCIModel.getInstance().getRbs();
        this.noOfSectors = this.rbs.getMaxNumberOfSectors();
        this.updateCustomerParameters();
    }

    private void updateCustomerParameters() {
        this.customerParameterNames.clear();
        try {
            this.radioBuildingBlockParameters = new Enumeration[this.noOfSectors];
            this.sectorSequenceParameters = new Enumeration[this.noOfSectors];
            this.primaryPortIdParameters = new Enumeration[this.noOfSectors];
            this.secondaryPortIdParameters = new Enumeration[this.noOfSectors];
            this.lineRateParameters = new Enumeration[this.noOfSectors];
            this.auUnitTypeParameters = new Enumeration[this.noOfSectors];
            this.radioSharedBySectorParameters = new Enumeration[this.noOfSectors];
            boolean bl = this.rbs.isPantherHybridRbs();
            for (int i = 0; i < this.noOfSectors; ++i) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, 1);
                String string6 = MessageFormat.format("S{0}_", n);
                String string7 = this.getRadioBuildingBlockName(string6);
                if (this.rbs.isParameterSupported(string7)) {
                    this.radioBuildingBlockParameters[i] = (Enumeration)this.rbs.getCustomerParameterObject(string7);
                }
                if (bl && n < 7) continue;
                String string8 = this.getSectorSequenceName(string6);
                if (this.rbs.isParameterSupported(string8)) {
                    this.sectorSequenceParameters[i] = (Enumeration)this.rbs.getCustomerParameterObject(string8);
                }
                if (this.rbs.isParameterSupported(string5 = this.getPrimaryPortIdName(string6))) {
                    this.primaryPortIdParameters[i] = (Enumeration)this.rbs.getCustomerParameterObject(string5);
                }
                if (this.rbs.isParameterSupported(string4 = this.getSecondaryPortIdName(string6))) {
                    this.secondaryPortIdParameters[i] = (Enumeration)this.rbs.getCustomerParameterObject(string4);
                }
                if (this.rbs.isParameterSupported(string3 = this.getLineRateName(string6))) {
                    this.lineRateParameters[i] = (Enumeration)this.rbs.getCustomerParameterObject(string3);
                }
                if (this.rbs.isParameterSupported(string2 = this.getAuUnitTypeName(string6))) {
                    this.auUnitTypeParameters[i] = (Enumeration)this.rbs.getCustomerParameterObject(string2);
                }
                if (!this.rbs.isParameterSupported(string = this.getRadioSharedBySectorName(string6))) continue;
                this.radioSharedBySectorParameters[i] = (Enumeration)this.rbs.getCustomerParameterObject(string);
            }
            this.view.setRadioBuildingBlock(this.radioBuildingBlockParameters);
            this.view.setSectorSequence(this.sectorSequenceParameters);
            this.view.setPrimaryPortId(this.primaryPortIdParameters);
            this.view.setSecondaryPortId(this.secondaryPortIdParameters);
            this.view.setLineRate(this.lineRateParameters);
            this.view.setAuUnitType(this.auUnitTypeParameters);
            this.view.setRadioSharedBySector(this.radioSharedBySectorParameters);
            this.view.setNumberOfSectors(this.noOfSectors);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "updateCustomerParameters()", null, "Setting up window for input", exception);
            System.out.println(wizardException.getMessage());
            super.displayError(wizardException);
            return;
        }
    }

    private String getRadioBuildingBlockName(String string) {
        return string + "radioBuildingBlock";
    }

    private String getSectorSequenceName(String string) {
        return string + "sectorSequenceNumber";
    }

    private String getPrimaryPortIdName(String string) {
        return string + "primaryPortId";
    }

    private String getSecondaryPortIdName(String string) {
        return string + "secondaryPortId";
    }

    private String getLineRateName(String string) {
        return string + "cpriLineRate";
    }

    private String getAuUnitTypeName(String string) {
        return string + "auUnitType";
    }

    private String getRadioSharedBySectorName(String string) {
        return string + "radioSharedBySector";
    }

    protected void beforeVisible() {
        if (super.getPreviousControllerClass() == null) {
            super.setPreviousEnabled(false);
        }
        this.setWindowTitle();
        this.view.updateGui();
    }

    protected void afterVisible() {
        try {
            this.setupRbbListeners(this.rbs.isPantherHybridRbs());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "Error", 0);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.rbs.checkConsistency("RadioEquipmentCI");
            this.addNumberOfRxBranchesListener();
            this.updateCarrierInfo();
            if (AIRUtil.getInstance(this.rbs).isAntFeederPageSkipped()) {
                this.wizardHelp.excludeSlides(AntennaCablesController.class.getSimpleName(), AntennaCablesController.class.getSimpleName());
            }
        }
        catch (Exception exception) {
            this.displayNextError(this.view, exception);
            bl = false;
        }
        if (bl) {
            this.removeRbbListeners(this.rbs.isPantherHybridRbs());
        }
        return bl;
    }

    private void addNumberOfRxBranchesListener() throws BemException {
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, 1);
            int n2 = 0;
            if (this.rbs.isPantherHybridRbs() && n >= 7) {
                n2 = 1;
            }
            if (this.radioBuildingBlockParameters[i].isDefault()) continue;
            ((AbstractAntennaSystemCI)this.rbs.getAntennaSystemProvider(n2)).addNumberOfRxBranchesListener(n);
        }
    }

    private void removeNumberOfRxBranchesListener() throws BemException {
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, 1);
            int n2 = 0;
            if (this.rbs.isPantherHybridRbs() && n >= 7) {
                n2 = 1;
            }
            ((AbstractAntennaSystemCI)this.rbs.getAntennaSystemProvider(n2)).removeAllNumberOfRxBranchesListener(n);
        }
    }

    private void updateCarrierInfo() throws BemException {
        for (int i = 1; i <= this.noOfSectors; ++i) {
            int n = 0;
            if (this.rbs.isPantherHybridRbs() && i >= 7) {
                n = 1;
            }
            int n2 = this.rbs.getMaxNumberOfCarriers();
            String string = Integer.valueOf(i).toString();
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                int n3 = j + 1;
                String string2 = "";
                String string3 = MessageFormat.format("S{0}_C{1}_", string, String.valueOf(n3));
                string2 = string3 + "cellCreated";
                bl = this.rbs.isParameterSupported(string2);
                if (!bl) continue;
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                string2 = string3 + "cellIdentity";
                int n4 = this.rbs.getRadioEquipmentProvider(n).getMaxNumberOfCarriers(i);
                if (n3 <= n4) continue;
                customerParameter.setValue("NO");
            }
        }
    }

    protected boolean previous() {
        boolean bl = true;
        try {
            this.removeNumberOfRxBranchesListener();
        }
        catch (Exception exception) {
            this.displayNextError(this.view, exception);
            bl = false;
        }
        return bl;
    }

    private void setupRbbListeners(boolean bl) {
        this.rbbListeners = new RadioBuildingBlockListener[this.noOfSectors];
        int n = 1;
        if (bl) {
            n = 7;
        }
        for (int i = n; i <= this.noOfSectors; ++i) {
            RadioBuildingBlockListener radioBuildingBlockListener;
            int n2 = i - 1;
            String string = MessageFormat.format("S{0}_", i);
            String string2 = this.getRadioBuildingBlockName(string);
            if (!this.rbs.isParameterSupported(string2)) continue;
            this.rbbListeners[n2] = radioBuildingBlockListener = new RadioBuildingBlockListener(this.sectorSequenceParameters[n2], this.primaryPortIdParameters[n2], this.secondaryPortIdParameters[n2], this.lineRateParameters[n2], this.auUnitTypeParameters[n2], this.radioSharedBySectorParameters[n2]);
            this.radioBuildingBlockParameters[n2].addCustomerParameterListener(radioBuildingBlockListener);
        }
    }

    private void removeRbbListeners(boolean bl) {
        int n = 1;
        if (bl) {
            n = 7;
        }
        for (int i = n; i <= this.noOfSectors; ++i) {
            int n2 = i - 1;
            this.radioBuildingBlockParameters[n2].removeCustomerParameterListener(this.rbbListeners[n2]);
        }
    }
}

