/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.AbstractPowerSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.AbstractPowerSupplyCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SiteLocationViewer;

public class SiteLocationController
extends BemWizardGuiController {
    private SiteLocationViewer myView = null;
    private WizardCIModel siteCIModel;
    private Rbs rbs;
    private final List customerParameterNames = new ArrayList();
    private boolean isPowerSupported;
    private boolean isAlarmSupported;

    protected void init() {
        this.myView = (SiteLocationViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.siteCIModel = SiteCIModel.getInstance();
        this.rbs = this.siteCIModel.getRbs();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        super.setPreviousEnabled(false);
        super.setPreviousVisible(false);
        try {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("siteName");
            CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject("logicalName");
            CustomerParameter customerParameter3 = this.rbs.getCustomerParameterObject("latitude");
            CustomerParameter customerParameter4 = this.rbs.getCustomerParameterObject("longitude");
            CustomerParameter customerParameter5 = this.rbs.getCustomerParameterObject("altitude");
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject("tolerance");
            this.customerParameterNames.add("siteName");
            this.customerParameterNames.add("logicalName");
            this.customerParameterNames.add("latitude");
            this.customerParameterNames.add("longitude");
            this.customerParameterNames.add("altitude");
            this.customerParameterNames.add("tolerance");
            this.myView.setSiteNameParameter(customerParameter);
            this.myView.setLogicalNameParameter(customerParameter2);
            this.myView.setWantedPositionParameters(customerParameter3, customerParameter4, customerParameter5, integerParameter);
            this.isAlarmSupported = this.rbs.isConfigurationItemSupported("AlarmCI");
            this.isPowerSupported = this.rbs.isConfigurationItemSupported("PowerSystemCI");
            if (this.isPowerSupported) {
                ConfigurationItem configurationItem = this.rbs.getConfigItem("PowerSystemCI");
                if (configurationItem instanceof AbstractPowerSupplyCI) {
                    AbstractPowerSupplyCI abstractPowerSupplyCI = (AbstractPowerSupplyCI)configurationItem;
                    this.isPowerSupported = abstractPowerSupplyCI.isConfPowerSupplySupported();
                } else if (configurationItem instanceof AbstractPowerSystemCI) {
                    AbstractPowerSystemCI abstractPowerSystemCI = (AbstractPowerSystemCI)configurationItem;
                    this.isPowerSupported = abstractPowerSystemCI.isConfPowerSupplySupported();
                }
            }
            if (!this.isAlarmSupported && !this.isPowerSupported) {
                this.wizardHelp.excludeSlides("OptionalEquipmentController", "OptionalEquipmentController");
            }
            this.checkSectorOptions();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("SiteLocationController", "afterVisible()", null, "Setting up window for input", exception);
            this.displayError(wizardException);
            return;
        }
    }

    private void checkSectorOptions() {
        try {
            boolean bl = false;
            if (this.rbs.isPantherHybridRbs()) {
                bl = true;
            } else {
                RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider();
                bl = radioEquipmentProvider.mainRemoteRbs();
            }
            if (!bl) {
                this.wizardHelp.excludeSlides("SectorOptionsController", "SectorOptionsController");
            }
        }
        catch (Exception exception) {
            this.displayError(exception);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.rbs.checkConsistency("AntennaSystemCI", this.customerParameterNames);
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

