/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlFileHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.ExternalConfigurator;
import se.ericsson.wcdma.rbs.bem.wizard.util.Preconditions;
import se.ericsson.wcdma.rbs.bem.wizard.util.PreconditionsCheck;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.rbs.bem.wizard.view.ProgressDialogView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.FileInputSiteController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.RegressionTestPostControlRunner;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.RegressionTestPreControlRunner;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.FileInputSiteView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.WelcomeViewer;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class WelcomeController
extends AbstractApplicationController {
    private WelcomeViewer myView = null;
    private WizardHelper wizardHelp = null;
    private final Class nextController = FileInputSiteController.class;
    private final Class nextView = FileInputSiteView.class;
    private final String configurationVersion = WizardCommon.WIZARD_LDN_CONFIGURATIONVERSION;
    private MoHandler theMoHandler;

    protected void init() {
        this.theMoHandler = new MoHandlerImpl();
        this.myView = (WelcomeViewer)((Object)this.getView());
        this.myView.getNextButton().addActionListener(new NextButtonListener());
        this.myView.getCancelButton().addActionListener(new CancelButtonListener());
    }

    protected boolean canStop() {
        return true;
    }

    protected void beforeVisible() {
        boolean bl = WizardLaunchChecker.wizardStarted();
        if (!bl) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    protected void afterVisible() {
        this.wizardHelp = WizardHelp.getTheInstance();
        this.setWindowSubTitle();
        boolean bl = this.startRegressionTestIfApplicable();
        if (bl) {
            return;
        }
        try {
            this.setProductData();
            DuwUtil.setup();
            if (DuwUtil.hasDuw()) {
                WizardHelp.getTheInstance().setDuwPageOrder();
            }
        }
        catch (Exception exception) {
            this.showError(exception.toString());
        }
    }

    protected void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    protected void cancel() {
        WizardLaunchChecker.wizardStopped();
        this.getApplication().stopApplication();
    }

    protected void viewClosing() {
        this.cancel();
    }

    private void setWindowSubTitle() {
        this.myView.setHeaderText("Site Equipment Configuration ");
    }

    public Class getNextControllerClass() {
        return this.nextController;
    }

    public Class getNextViewClass() {
        return this.nextView;
    }

    private boolean startRegressionTestIfApplicable() {
        boolean bl = RegressionTestInDesigntestUtils.getRegressionTest();
        if (bl) {
            ExternalConfigurator externalConfigurator = null;
            String string = RegressionTestInDesigntestUtils.getInputFilePathName();
            boolean bl2 = WelcomeController.parseXML(string, this.wizardHelp.getDtdFilePath(), externalConfigurator);
            if (bl2) {
                this.startDialog(true, "NCONF_NPC_PROGRESS_DIALOG_TITLE", null, ProgressDialogView.class, RegressionTestPreControlRunner.class);
                this.startDialog(true, "NCONF_NPC_PROGRESS_DIALOG_TITLE", null, ProgressDialogView.class, RegressionTestPostControlRunner.class);
                this.getApplication().stopApplicationNoCheck();
            }
        }
        return bl;
    }

    public static boolean parseXML(String string, String string2, ExternalConfigurator externalConfigurator) {
        boolean bl = false;
        XmlFileHandler xmlFileHandler = null;
        ServiceValue serviceValue = null;
        try {
            xmlFileHandler = XmlFileHandler.getInstance();
            serviceValue = xmlFileHandler.startParsing(string, string2);
            externalConfigurator.setServiceValue(serviceValue);
            externalConfigurator.setUseFileInput(true);
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("    RegressionTestInDesigntestUtils.parseXML()  Exception=" + exception.toString());
            System.out.println("    xmlName=" + string);
            System.out.println("    dtdFilePath=" + string2);
        }
        return bl;
    }

    private void setProductData() throws NoSuchFieldException, IOException, MoHandlerException {
        Object object;
        BemMo bemMo = this.theMoHandler.getMo(this.configurationVersion);
        BemMo bemMo2 = (BemMo)this.theMoHandler.getAttribute(bemMo, "currentUpgradePackage");
        NalStruct nalStruct = (NalStruct)this.theMoHandler.getAttribute(bemMo2, "administrativeData");
        String string = (String)nalStruct.getMemberValue("productNumber");
        String string2 = (String)nalStruct.getMemberValue("productRevision");
        String string3 = WizardHelp.getTheInstance().getDtdFilePath();
        InputStream inputStream = WelcomeController.class.getResourceAsStream(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string4 = "";
        char[] cArray = new char[4096];
        int n = bufferedReader.read(cArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray);
        while (n != -1) {
            n = bufferedReader.read(cArray);
            stringBuffer.append(cArray);
        }
        string4 = stringBuffer.toString();
        bufferedReader.close();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "<!");
        String string5 = "";
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n2 = ((String)object).indexOf("revision");
            if (n2 == -1) continue;
            int n3 = ((String)object).indexOf("(");
            int n4 = ((String)object).indexOf(")");
            if (n3 == -1 || n4 == -1) continue;
            string5 = ((String)object).substring(n3 + 1, n4);
            break;
        }
        object = ExceptionProperties.getRevisionProperties();
        ((ExceptionProperties)object).setProperty("Upgrade Package Revision", string + " rev " + string2);
        ((ExceptionProperties)object).setProperty("DTD version", "Site : " + string5);
        String string6 = "* Software package\n  Product number: " + string + "\n" + "  Product revision: " + string2 + "\n" + "  DTD version: " + string5;
        this.myView.setProductData(string6);
    }

    private boolean isWizardRun() {
        Preconditions preconditions = null;
        boolean bl = false;
        try {
            preconditions = new PreconditionsCheck().checkPreconditions(WizardCommon.WIZARD_IS_WIZARD_RUN_SITE);
            bl = preconditions.getPreconditionsFullfilled();
        }
        catch (WizardException wizardException) {
            this.showMessageDialog("Could not read information from node\n" + wizardException.toString(), null, "BEM_INFORMATION_TITLE", null, 1, null);
        }
        return bl;
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WelcomeController.this.cancel();
        }
    }

    class NextButtonListener
    implements ActionListener {
        NextButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (WelcomeController.this.isWizardRun()) {
                WelcomeController.this.showMessageDialog("NCONF_SITE_WIZARD_ALREADY_RUN", null, "BEM_INFORMATION_TITLE", null, 1, null);
                WelcomeController.this.cancel();
                return;
            }
            Object[][] objectArray = new String[0][0];
            WelcomeController.this.startWizard(false, "NCONF_SITE_WIZARD_WINDOW_TITLE", null, WelcomeController.this.getNextViewClass(), WelcomeController.this.getNextControllerClass(), objectArray);
            WelcomeController.this.myView.setTheViewToDummy();
        }
    }
}

