/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntennaBranch;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.AntennaBranchController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.AntennaBranchViewer;

public class AntennaBranchView
extends BemWizardGuiView
implements AntennaBranchViewer {
    private JPanel antennaBranchMainPanel = null;
    private JPanel antennaBranchOverviewPanel = null;
    private JPanel antennaBranchConfigPanel = null;
    private JTable antennaBranchOverviewTable = null;
    private JLabel sectorLabel;
    private JLabel sectorNumberLabel;
    private JLabel branchLabel;
    private JLabel branchNameLabel;
    private JLabel cpNameLabels;
    private JComponent cpValueFields;
    private static final String[] cpDescriptions = new String[]{"FQ band low edge (0.1 MHz):", "FQ band high edge (0.1 MHz):", "Antenna supervision threshold (%):"};
    private AntennaBranchController controller = null;
    private int selectedRow = -1;
    private int selectedColumn = -1;

    protected void init() {
        super.init();
        this.initiateMainPanel();
    }

    public void setController(AntennaBranchController antennaBranchController) {
        this.controller = antennaBranchController;
    }

    public void initiateMainPanel() {
        this.antennaBranchMainPanel = new JPanel();
        this.antennaBranchMainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.antennaBranchMainPanel);
    }

    protected String getSubHeading() {
        return BemLanguageHelp.getTranslation("NCONF_SITE_ANT_BRANCH_SUB_TITLE");
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public JTable setAntennaBranchOverviewParameters(Object[][] objectArray, String[] stringArray) {
        if (this.antennaBranchOverviewTable == null) {
            this.antennaBranchOverviewTable = new JTable(objectArray, stringArray){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.antennaBranchOverviewTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    this.setForeground(Color.BLACK);
                    if (n2 == 0) {
                        this.setHorizontalAlignment(0);
                    } else {
                        switch (AntennaBranchView.this.controller.getSectorAntennaState()[n2 - 1][n]) {
                            case 0: {
                                this.setHorizontalAlignment(0);
                                this.setText("*");
                                break;
                            }
                            case 2: {
                                this.setHorizontalAlignment(4);
                                String string = AntennaBranchView.this.controller.getActiveSectors()[n2 - 1] + "-" + ServiceCommon.BRANCH_NAMES[n];
                                this.setText(string);
                                break;
                            }
                            case 4: {
                                this.setHorizontalAlignment(2);
                                this.setText("Incorrect");
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 3: {
                                this.setHorizontalAlignment(0);
                                this.setText("-");
                                break;
                            }
                        }
                    }
                    return this;
                }
            };
            this.antennaBranchOverviewTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
            this.antennaBranchOverviewTable.setSelectionMode(0);
            this.antennaBranchOverviewTable.setCellSelectionEnabled(true);
            this.antennaBranchOverviewTable.setRowHeight(this.getFont().getSize() + 10);
            JScrollPane jScrollPane = new JScrollPane(this.antennaBranchOverviewTable);
            jScrollPane.setPreferredSize(new Dimension(630, 150));
            this.antennaBranchOverviewPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.antennaBranchOverviewTable.setModel(new DefaultTableModel(objectArray, stringArray));
        }
        this.antennaBranchMainPanel.add((Component)this.antennaBranchOverviewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 10, 2, 10), 0, 0));
        return this.antennaBranchOverviewTable;
    }

    public void setListenerForAntennaBranchOverviewTable(ListSelectionListener listSelectionListener) {
        this.antennaBranchOverviewTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.antennaBranchOverviewTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void setAntennaBranchConfigurationParameters(int n, int n2, int n3, int n4, int n5) {
    }

    public void updateSelectedCell() {
        this.selectedRow = this.antennaBranchOverviewTable.getSelectedRow();
        this.selectedColumn = this.antennaBranchOverviewTable.getSelectedColumn();
    }

    public void arrangeOverviewTable(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n + 1];
        stringArray[0] = "Antenna branch";
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = "Sector " + nArray[i - 1];
        }
        Object[][] objectArray = new Object[ServiceCommon.BRANCH_NAMES.length][stringArray.length];
        for (int i = 0; i < ServiceCommon.BRANCH_NAMES.length; ++i) {
            objectArray[i][0] = ServiceCommon.BRANCH_NAMES[i];
            for (int j = 1; j < stringArray.length; ++j) {
                objectArray[i][j] = "";
            }
        }
        if (this.antennaBranchOverviewPanel == null) {
            this.antennaBranchOverviewPanel = new JPanel();
            this.antennaBranchOverviewPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Antenna Branch Overview"));
            this.setAntennaBranchOverviewParameters(objectArray, stringArray);
        } else {
            this.setAntennaBranchOverviewParameters(objectArray, stringArray);
        }
    }

    public void arrangeAntennaConfigTable() {
        if (this.antennaBranchConfigPanel != null) {
            this.antennaBranchMainPanel.remove(this.antennaBranchConfigPanel);
        }
        this.antennaBranchConfigPanel = new JPanel();
        this.antennaBranchConfigPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Antenna Branch Configuration"));
        this.antennaBranchConfigPanel.setLayout(new GridBagLayout());
        this.sectorLabel = new JLabel("Sector");
        String string = "-";
        if (this.selectedColumn >= 1 && this.selectedRow >= 0) {
            if (this.controller.getSectorAntennaState()[this.selectedColumn - 1][this.selectedRow] != 3) {
                string = String.valueOf(this.controller.getActiveSectors()[this.selectedColumn - 1]);
            }
        }
        this.sectorNumberLabel = new JLabel(string);
        this.branchLabel = new JLabel("Branch");
        String string2 = "-";
        if (this.selectedRow >= 0 && this.selectedColumn >= 1) {
            if (this.controller.getSectorAntennaState()[this.selectedColumn - 1][this.selectedRow] != 3) {
                string2 = ServiceCommon.BRANCH_NAMES[this.selectedRow];
            }
        }
        this.branchNameLabel = new JLabel(string2);
        this.antennaBranchConfigPanel.add((Component)this.sectorLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 17, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaBranchConfigPanel.add((Component)this.sectorNumberLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaBranchConfigPanel.add((Component)this.branchLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 17, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaBranchConfigPanel.add((Component)this.branchNameLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 12, 1, new Insets(5, 10, 5, 10), 0, 0));
        int n = this.controller.getSectorNumber(this.selectedColumn - 1);
        String string3 = MessageFormat.format("S{0}_", n);
        for (int i = 0; i < cpDescriptions.length; ++i) {
            if (n >= 0 && AIRUtil.getInstance(SiteCIModel.getInstance().getRbs()).isAir4SectorAntenna(n, false)) {
                if (AntennaBranchController.attrNames[i].equals("antennaSupervisionBranch")) continue;
            }
            this.cpNameLabels = new JLabel(cpDescriptions[i]);
            if (this.selectedRow < 0 || this.selectedColumn < 1) {
                this.cpValueFields = new JLabel("-");
            } else if (this.controller.getSectorAntennaState()[this.selectedColumn - 1][this.selectedRow] != 3) {
                String string4 = string3 + AntennaBranchController.attrNames[i] + ServiceCommon.BRANCH_NAMES[this.selectedRow];
                CustomerParameter customerParameter = this.controller.getCP(string4);
                if ((string4.contains("fqBandHighEdgeBranch") || string4.contains("fqBandLowEdgeBranch")) && SectorUtil.isDualBand(SiteCIModel.getInstance().getRbs(), n)) {
                    customerParameter.setValue(String.valueOf(MimAntennaBranch.DEFAULT_FQBANDHIGHEDGE));
                    this.cpValueFields = new JLabel(customerParameter.getValue());
                } else {
                    this.cpValueFields = new CustomerParameterTextField(customerParameter);
                }
                this.cpValueFields.setPreferredSize(new Dimension(50, 20));
                customerParameter.addCustomerParameterListener(this.controller.getTextFieldListener());
            } else {
                this.cpValueFields = new JLabel("-");
            }
            this.antennaBranchConfigPanel.add((Component)this.cpNameLabels, new GridBagConstraints(0, i + 2, 1, 1, 1.0, 1.0, 18, 17, new Insets(5, 10, 5, 10), 0, 0));
            this.antennaBranchConfigPanel.add((Component)this.cpValueFields, new GridBagConstraints(1, i + 2, 1, 1, 0.0, 0.0, 12, 1, new Insets(5, 10, 5, 10), 0, 0));
        }
        this.antennaBranchMainPanel.add((Component)this.antennaBranchConfigPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 18, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaBranchMainPanel.repaint();
        this.antennaBranchMainPanel.validate();
    }

    public void setFocusOnCustomerParameterComponent(String string) {
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = "";
        String string3 = " Branch ";
        int n = Integer.valueOf(string.substring(1, 2));
        String string4 = string.substring(string.length() - 1, string.length());
        string2 = this.antennaBranchOverviewTable.getColumnName(n) + string3 + string4;
        return string2;
    }

    public void editingStopped() {
        this.antennaBranchOverviewTable.editingStopped(new ChangeEvent(this));
    }
}

