/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.RbsLocalCellViewer;

public class RbsLocalCellView
extends BemWizardGuiView
implements RbsLocalCellViewer {
    private JPanel rbsLocalCellMainPanel = null;
    private GridBagLayout gridBagLayout = null;
    private JPanel[] sectorPanels;
    private CustomerParameterTable[] sectorTables;
    private CustomerParameter allocationModeParam = null;
    private Box sectorsPanel;
    private Box carrierAllocationModePanel;
    private static final int maxNoOfSectors = 12;

    protected void init() {
        try {
            super.init();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initiateMainPanel() {
        this.gridBagLayout = new GridBagLayout();
        this.rbsLocalCellMainPanel = new JPanel(this.gridBagLayout);
        this.sectorPanels = new JPanel[12];
        this.sectorTables = new CustomerParameterTable[12];
        this.sectorsPanel = Box.createVerticalBox();
        this.carrierAllocationModePanel = Box.createHorizontalBox();
        this.rbsLocalCellMainPanel.add((Component)this.carrierAllocationModePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rbsLocalCellMainPanel.add((Component)this.sectorsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rbsLocalCellMainPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.addMainPanel(this.rbsLocalCellMainPanel);
        for (int i = 0; i < 12; ++i) {
            TitledBorder titledBorder = new TitledBorder("Sector " + (i + 1));
            this.sectorPanels[i] = new JPanel();
            this.sectorPanels[i].setLayout(this.gridBagLayout);
            this.sectorPanels[i].setBorder(titledBorder);
        }
    }

    void jbInit() throws Exception {
        this.initiateMainPanel();
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_RBS_SUB_HEADING");
    }

    public void setSectorTableParameters(int n, Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        if (this.sectorTables[n - 1] == null) {
            CustomerParameterTable customerParameterTable = new CustomerParameterTable(objectArray, stringArray, stringArray2);
            customerParameterTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)customerParameterTable.getTableHeader(), "North");
            jPanel.add((Component)customerParameterTable, "Center");
            jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.sectorTables[n - 1] = customerParameterTable;
            this.sectorsPanel.add(this.sectorPanels[n - 1]);
            this.sectorPanels[n - 1].add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void removeUnconfiguredSectorTable(int n) {
        this.sectorPanels[n - 1].removeAll();
        this.sectorsPanel.remove(this.sectorPanels[n - 1]);
        this.sectorTables[n - 1] = null;
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        for (int i = 0; i < 12; ++i) {
            if (this.sectorTables[i] == null || !this.sectorTables[i].isParameterInTable(string)) continue;
            this.sectorTables[i].setFocusOnCell(string);
        }
    }

    public String getGuiNameForCustomerParameter(String string) {
        for (int i = 0; i < 12; ++i) {
            if (this.sectorTables[i] == null || !this.sectorTables[i].isParameterInTable(string)) continue;
            return this.sectorTables[i].getRowAndColumnName(string);
        }
        return "";
    }

    public void setCarrierAllocationModeParameter(CustomerParameter customerParameter) {
        if (this.allocationModeParam == null) {
            this.allocationModeParam = customerParameter;
            CustomerParameterComboBox customerParameterComboBox = new CustomerParameterComboBox((Enumeration)customerParameter);
            CustomerParameterPanel customerParameterPanel = new CustomerParameterPanel("Carrier Allocation Mode:", customerParameterComboBox);
            customerParameterPanel.setMaximumSize(customerParameterPanel.getMinimumSize());
            this.carrierAllocationModePanel.add(customerParameterPanel);
            this.carrierAllocationModePanel.add(Box.createHorizontalGlue());
        }
    }
}

