/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.Cursor;
import java.awt.Image;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationView;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.wcdma.support.gui.guilib.infra.Application;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.Resources;

public abstract class AbstractApplication
implements Application,
Resources {
    private String applicationName;
    private final Class viewClass;
    private final Class controllerClass;
    private final boolean isSingleton;
    private ApplicationManager applicationManager;
    private BemLaunchable bemLaunchable;
    private Properties environment;
    private Locale locale;
    private ApplicationPresenter applicationPresenter;

    public AbstractApplication(Class clazz, Class clazz2, boolean bl) {
        this.viewClass = clazz;
        this.controllerClass = clazz2;
        this.isSingleton = bl;
        if (!AbstractApplicationView.class.isAssignableFrom(clazz)) {
            Error error = new Error("ViewClass=" + clazz.getName() + " is not derrived from " + AbstractApplicationView.class.getName() + "!");
            Nal.getLog().nalTraceError(this.getClass(), "Failed constructing AbstractApplication!", error);
            throw error;
        }
        if (!AbstractApplicationController.class.isAssignableFrom(clazz2)) {
            Error error = new Error("ControllerClass=" + clazz2.getName() + " is not derrived from " + AbstractApplicationController.class.getName() + "!");
            Nal.getLog().nalTraceError(this.getClass(), "Failed constructing AbstractApplication!", error);
            throw error;
        }
    }

    public Image getMinimizeIconImage() {
        return this.getBemLaunchable().getMinimizeIconImage();
    }

    public String getApplicationViewClassName() {
        return this.viewClass.getName();
    }

    public String getApplicationControllerClassName() {
        return this.controllerClass.getName();
    }

    public String getEnvironmentBundleName() {
        return null;
    }

    public String getLanguageBundleName() {
        return "se.ericsson.wcdma.rbs.bem.common.resources.language.RbsLanguage";
    }

    public String getToolTipBundleName() {
        return "se.ericsson.wcdma.rbs.bem.common.resources.language.RbsTooltip";
    }

    public String getHelpBundleName() {
        return "se.ericsson.wcdma.rbs.bem.help.resources.RbsHelp";
    }

    protected void init(ApplicationManager applicationManager, BemLaunchable bemLaunchable, boolean bl, Locale locale, Properties properties) {
        this.applicationManager = applicationManager;
        this.bemLaunchable = bemLaunchable;
        this.applicationName = bemLaunchable.getApplName();
        this.locale = locale;
        String string = this.getEnvironmentBundleName();
        if (string != null) {
            ApplicationManager.loadBundle(string, locale, properties);
        }
        this.setEnvironment(properties);
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    public BemLaunchable getBemLaunchable() {
        return this.bemLaunchable;
    }

    public String getApplName() {
        return this.bemLaunchable != null ? this.bemLaunchable.getApplName() : null;
    }

    boolean isLaunchedStandAlone() {
        if (this.bemLaunchable == BemLaunchable.UNKNOWN) {
            return false;
        }
        return this.bemLaunchable.isLaunchedStandAlone();
    }

    public String getHostname() {
        if (this.bemLaunchable != null) {
            return this.bemLaunchable.getHostname();
        }
        return null;
    }

    ApplicationPresenter getApplicationPresenter() {
        return this.applicationPresenter;
    }

    void setApplicationPresenter(ApplicationPresenter applicationPresenter) {
        this.applicationPresenter = applicationPresenter;
    }

    public JFrame getJFrame() {
        JFrame jFrame = this.applicationPresenter.getJFrame();
        return jFrame;
    }

    public AbstractHelp getHelp() {
        if (this.applicationPresenter != null) {
            return this.applicationPresenter.getHelp();
        }
        return null;
    }

    public void stopApplication() {
        Nal.getLog().nalTraceEnter(this.getClass(), "stopApplication() for " + this.applicationName);
        ToolTipManager.sharedInstance().setEnabled(false);
        this.applicationManager.stopApplication(this);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolTipManager.sharedInstance().setEnabled(true);
                }
            });
        }
        catch (Exception exception) {
            Log.logWarning("GuiLib exception in stopApplication() for " + this.applicationName + " when re-enabling tooltip", exception);
        }
    }

    public void stopApplicationNoCheck() {
        Nal.getLog().nalTraceEnter(this.getClass(), "stopApplicationNoCheck() for " + this.applicationName);
        this.applicationManager.stopApplicationNoCheck(this);
        if (this.bemLaunchable != null) {
            this.bemLaunchable.exit();
        }
    }

    public Object getParameter(String string) {
        return this.applicationPresenter.getParameter(string);
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    void setEnvironment(Properties properties) {
        this.environment = properties;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.applicationPresenter.updateLocale(locale);
    }

    public ResourceBundle getLanguageBundle() {
        return this.applicationPresenter.getLanguageManager().getLanguageBundle();
    }

    public ResourceBundle getToolTipBundle() {
        return this.applicationPresenter.getLanguageManager().getToolTipBundle();
    }

    public String getTitle() {
        return this.applicationPresenter.getTitle();
    }

    public String getUserId() {
        String string = "Undefined User";
        try {
            string = System.getProperty("user.name");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public void setTitle(String string, Object[] objectArray) {
        this.applicationPresenter.setTitle(string, objectArray);
    }

    public void addStatusBar() {
        this.applicationPresenter.addStatusBar();
    }

    public String getStatus() {
        return this.applicationPresenter.getStatus();
    }

    public void setStatus(String string, Object[] objectArray) {
        this.applicationPresenter.setStatus(string, objectArray);
    }

    public void setStatus(String string) {
        this.applicationPresenter.setStatus(string);
    }

    public void setCursor(Cursor cursor) {
        this.applicationPresenter.setCursor(cursor, true);
    }

    public boolean isVisible() {
        return this.applicationPresenter.isVisible();
    }

    public void setVisible(boolean bl) {
        this.applicationPresenter.setVisible(bl);
    }

    public void bringToFront() {
        this.applicationPresenter.bringToFront();
    }

    public void setEnabled(boolean bl) {
        this.applicationPresenter.setEnabled(bl, true);
    }

    public boolean isEnabled() {
        return this.applicationPresenter.isEnabled();
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }
}

