/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperty;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.wcdma.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.wcdma.support.gui.guilib.infra.LanguageManager;

public class ApplicationManager {
    static final String SUPPORT_PRESENTATION = "gsl.supportpresentation";
    static final String SUPPORT_LOOK_AND_FEEL = "gsl.supportlookandfeel";
    static final String SYSTEM_LIBRARY = "gsl.systemlibrary";
    static final String LOG_LEVEL = "gsl.loglevel";
    static final String GUILIB_LOG_LEVEL = "gsl.guilib.loglevel";
    static final String MEASUREMENT_INFO_ON = "gsl.measurementinfoon";
    static final String LOG_TO_STD_OUT = "gsl.guilib.logtostdout";
    static final String LOG_TO_FILE = "gsl.guilib.logtofile";
    static final String LOG_FILE_NAME_PREFIX = "gsl.guilib.logfilenameprefix";
    private static final String INSTALL_PARAM_FILE = "se.ericsson.wcdma.rbs.bem.common.resources.InstallationParameters";
    private final Vector initialApplications = new Vector();
    private final String initialClassName;
    private final Object[][] initialParams;
    private final Vector applications = new Vector();
    private final Properties environment = new Properties();
    private static ClassLoader myClassLoader;
    private Hashtable objectNamingService;
    static final int SDI = 0;
    static final int MDI = 1;
    static final int DESKTOP = 2;
    static final int TABBED = 3;
    static final String[] PRESENTATION_TYPE_KEYS;
    static final int[] PRESENTATION_TYPE_VALUES;
    private final LauncherInterface launcher;
    private final Launchable launchableApplication;
    private ProgressListenerInterface progressListener;
    private static String host;

    public static Properties setDefaultEmasProperties(Properties properties) {
        ApplicationManager.setIfUndefined(properties, "emas.mainwindow.mainmenu.filename", "/se/ericsson/wcdma/rbs/bem/common/resources/TaskConfigurationFile.txt");
        ApplicationManager.setIfUndefined(properties, "emas.mainwindow.viewmanagers.filename", "/se/ericsson/wcdma/rbs/bem/common/resources/Viewmanagers.properties");
        ApplicationManager.setIfUndefined(properties, "emas.mainwindow.language.properties", "se.ericsson.wcdma.rbs.bem.common.resources.language.MainWindowLanguage");
        return properties;
    }

    private static void setIfUndefined(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            properties.setProperty(string, string2);
        }
    }

    public boolean hasNESameVersion() {
        return this.launcher.hasNESameVersion(host, this.launchableApplication);
    }

    public Collection getConfigurationFiles() {
        return this.launcher.getConfigurationFiles(this.launchableApplication);
    }

    public Launchable runApplication(String string) {
        try {
            return this.launcher.runApplication(string, host, EmasSystemProperties.getProperties(), this.launchableApplication);
        }
        catch (Exception exception) {
            Log.logError("Exception in runApplication", exception);
            this.progressListener.close();
            throw new RuntimeException(exception);
        }
    }

    public static ApplicationManager Launchermain(LaunchProperties launchProperties, BemLaunchable bemLaunchable, ProgressListenerInterface progressListenerInterface) {
        String string;
        String string2 = launchProperties.getHostname();
        Properties properties = launchProperties.getCopy();
        LauncherInterface launcherInterface = bemLaunchable.getLauncher();
        Launchable launchable = bemLaunchable.getParentLaunchable();
        ApplicationManager.setDefaultEmasProperties(properties);
        ApplicationManager applicationManager = null;
        String[] stringArray = new String[properties.size() * 2 + 3];
        Object[][] objectArray = null;
        String string3 = "-host";
        String string4 = string2;
        host = string2;
        Enumeration<?> enumeration = properties.propertyNames();
        int n = 3;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string != null && string != "") {
                Log.trace(" key: " + string);
                String string5 = properties.getProperty(string);
                Log.trace(" val: " + string5);
                stringArray[n] = string;
                stringArray[++n] = string5;
            }
            ++n;
        }
        EmasSystemProperties.setInitialProperties(properties);
        Properties properties2 = launcherInterface.getApplVersion(launchable);
        EmasSystemProperties.setProperty(LaunchProperty.CUSTOM_APPL_PROD_NO, properties2.getProperty(LaunchProperty.CUSTOM_APPL_PROD_NO.KEY, ""));
        EmasSystemProperties.setProperty(LaunchProperty.HOSTNAME, string2);
        string = EmasSystemProperties.getProperty(LaunchProperty.APPL_TO_RUN.KEY);
        Log.trace("initialClassName" + string);
        stringArray[0] = string;
        stringArray[1] = string3;
        stringArray[2] = string4;
        try {
            objectArray = ApplicationManager.createInitialParameters(stringArray);
        }
        catch (ParseException parseException) {
            Log.assertion(false, "Illegal argument list in Launchermain" + parseException);
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ApplicationManager.println("");
            ApplicationManager.println("Class not found: " + string);
            ApplicationManager.printUsage();
        }
        try {
            applicationManager = new ApplicationManager(string, objectArray, launcherInterface, launchable, progressListenerInterface);
            applicationManager.startInitialApplication(bemLaunchable, true);
        }
        catch (Throwable throwable) {
            ApplicationManager.println("Unknown exception in main: " + throwable);
            throwable.printStackTrace();
        }
        return applicationManager;
    }

    private static Object[][] createInitialParameters(String[] stringArray) throws ParseException {
        if (stringArray.length == 1) {
            return null;
        }
        if ((stringArray.length - 1) % 2 != 0) {
            throw new ParseException("Odd number of arguments", 0);
        }
        int n = (stringArray.length - 1) / 2;
        Object[][] objectArray = new Object[n][2];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2 + 1;
            String string = stringArray[n2];
            if (string.length() == 1) {
                throw new ParseException("Argument " + string + " too short!", i);
            }
            objectArray[i][0] = string.substring(1);
            objectArray[i][1] = stringArray[n2 + 1];
        }
        return objectArray;
    }

    public ApplicationManager(String string, Object[][] objectArray, LauncherInterface launcherInterface, Launchable launchable) {
        this.launcher = launcherInterface;
        this.launchableApplication = launchable;
        Log.trace("ApplicationManager: <constructor>. ClassLoader: " + this.getClass().getClassLoader());
        myClassLoader = this.getClass().getClassLoader();
        this.initialClassName = string;
        this.initialParams = (Object[][])objectArray.clone();
    }

    private ApplicationManager(String string, Object[][] objectArray, LauncherInterface launcherInterface, Launchable launchable, ProgressListenerInterface progressListenerInterface) {
        this(string, objectArray, launcherInterface, launchable);
        this.progressListener = progressListenerInterface;
    }

    boolean isInitialApplication(AbstractApplication abstractApplication) {
        for (int i = 0; i < this.initialApplications.size(); ++i) {
            if (abstractApplication != (AbstractApplication)this.initialApplications.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    Properties getEnvironment() {
        return this.environment;
    }

    private static void printUsage() {
        ApplicationManager.println("");
        ApplicationManager.println("usage: java.exe application.ApplicationManager <application class name> [-<arg name> <arg value>]");
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private void configure() {
        ApplicationManager.loadBundle(INSTALL_PARAM_FILE, LanguageManager.EMPTY_LOCALE, this.environment);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.trace("System locale: " + Locale.getDefault().getDisplayName());
        Log.trace("Environment properties: " + this.environment);
    }

    private void setEmasPropsToSystem() {
        try {
            Properties properties = EmasSystemProperties.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = EmasSystemProperties.getProperty(string);
                if (string2 == null) continue;
                System.setProperty(string, string2);
            }
            Log.trace("Emas props copied to system props");
        }
        catch (SecurityException securityException) {
            Log.logError("Prohibited by SecurityManager to set the properties.", securityException);
        }
    }

    private void removeEmasPropsFromSystem() {
        try {
            Properties properties = EmasSystemProperties.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                Properties properties2 = System.getProperties();
                ((Hashtable)properties2).remove(string);
            }
            Log.trace("Emas props removed from system props");
        }
        catch (SecurityException securityException) {
            Log.logError("Prohibited by SecurityManager to remove property from system properties", securityException);
        }
    }

    AbstractApplication getFirstInitialApplication() {
        return (AbstractApplication)this.initialApplications.firstElement();
    }

    Enumeration getAllApplications() {
        int n;
        Vector vector = new Vector();
        for (n = 0; n < this.initialApplications.size(); ++n) {
            vector.add(this.initialApplications.elementAt(n));
        }
        for (n = 0; n < this.applications.size(); ++n) {
            vector.add(this.applications.elementAt(n));
        }
        return vector.elements();
    }

    private synchronized AbstractApplication startInitialApplication(BemLaunchable bemLaunchable, boolean bl) {
        Log.traceFlow();
        this.configure();
        AbstractApplication abstractApplication = this.startApplicationImpl(this.initialClassName, this.initialParams, bemLaunchable, true, bl);
        return abstractApplication;
    }

    synchronized AbstractApplication startApplication(final String string, final Object[][] objectArray, final BemLaunchable bemLaunchable, final boolean bl, final boolean bl2) {
        AbstractApplication abstractApplication = null;
        if (SwingUtilities.isEventDispatchThread()) {
            abstractApplication = this.startApplicationImpl(string, objectArray, bemLaunchable, bl, bl2);
        } else if (this.initialApplications.size() > 0) {
            String string2 = "Trying to start application \"" + string + "\" from other thread than the event dispatch thread";
            Log.logError(string2);
            Log.assertion(false, string2);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    ApplicationManager.this.startApplicationImpl(string, objectArray, bemLaunchable, bl, bl2);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
                if (this.progressListener != null) {
                    this.progressListener.close();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return abstractApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractApplication startApplicationImpl(String string, Object[][] objectArray, BemLaunchable bemLaunchable, boolean bl, boolean bl2) {
        int n;
        Log.measure("start", true, "Application start");
        Log.logNotify("ApplicationManager: Starting application \"" + bemLaunchable.getApplName());
        Log.trace("ApplicationManager: Starting application... " + string);
        AbstractApplication abstractApplication = null;
        AbstractPresenter abstractPresenter = null;
        Locale locale = this.initialApplications.size() <= 0 ? LanguageManager.EMPTY_LOCALE : this.getFirstInitialApplication().getLocale();
        Log.trace("ApplicationManager: Setting locale for application " + string + " to " + locale.getDisplayLanguage());
        Properties properties = bl ? this.environment : this.getFirstInitialApplication().getEnvironment();
        for (int i = 0; i < this.applications.size(); ++i) {
            if (!string.equals(this.applications.elementAt(i).getClass().getName())) continue;
            abstractApplication = (AbstractApplication)this.applications.elementAt(i);
            break;
        }
        if (abstractApplication != null && abstractApplication.isSingleton()) {
            abstractApplication.getApplicationPresenter().getViewContainer().bringToFront();
            return abstractApplication;
        }
        Object object = null;
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                if (!"VIEWELEMENT".equals(objectArray[n][0])) continue;
                object = objectArray[n][1];
            }
        }
        for (n = 0; n < this.applications.size(); ++n) {
            if (!string.equals(this.applications.elementAt(n).getClass().getName())) continue;
            abstractApplication = (AbstractApplication)this.applications.elementAt(n);
            if (object == null || abstractApplication.getApplicationPresenter().getParameter("VIEWELEMENT") != object) continue;
            abstractApplication.getApplicationPresenter().getViewContainer().bringToFront();
            return abstractApplication;
        }
        Log.log(4, "Environment properties: " + properties);
        try {
            Class<?> clazz = Class.forName(string);
            abstractApplication = (AbstractApplication)clazz.newInstance();
            abstractApplication.init(this, bemLaunchable, bl, locale, properties);
            Class<?> clazz2 = Class.forName(abstractApplication.getApplicationViewClassName());
            Class<?> clazz3 = Class.forName(abstractApplication.getApplicationControllerClassName());
            if (bl) {
                this.initialApplications.add(abstractApplication);
            } else {
                this.applications.addElement(abstractApplication);
            }
            this.setEmasPropsToSystem();
            Log.trace("System.properties=" + System.getProperties());
            abstractPresenter = AbstractPresenter.createPresenter(null, abstractApplication, ApplicationPresenter.class, clazz2, clazz3, objectArray);
            abstractPresenter.setTitleNoTranslation(bemLaunchable.getWindowsTitle());
            if (bl2 && abstractPresenter.isVisible() && !abstractPresenter.isDisposed()) {
                abstractPresenter.setVisible(true);
                if (!abstractPresenter.isDisposed()) {
                    if (abstractPresenter.getViewContainer() != null) {
                        abstractPresenter.getViewContainer().bringToFront();
                        Log.trace("ApplicationManager: Application started " + string);
                    } else if (this.initialApplications.size() <= 0) {
                        String string2 = "ApplicationManager: Can't start application: " + abstractApplication;
                        Log.logError(string2);
                    } else {
                        String string3 = "ApplicationManager: Can't start application: " + abstractApplication;
                        Log.logError(string3);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            String string4 = "ApplicationManager: Can't start application: " + abstractApplication;
            Log.logError(string4, throwable);
            if (abstractPresenter != null) {
                this.disposeApplication(abstractApplication, false);
            } else if (bl) {
                this.initialApplications.remove(abstractApplication);
            } else {
                this.applications.remove(abstractApplication);
            }
            Log.assertion(false, string4);
        }
        finally {
            this.removeEmasPropsFromSystem();
            Log.trace("ApplicationManager:Restored System Properties=" + System.getProperties());
        }
        Log.measure("start", false);
        return abstractApplication;
    }

    synchronized void stopApplication(AbstractApplication abstractApplication) {
        if (!abstractApplication.isLaunchedStandAlone()) {
            this.stopApplicationCheckFirst(abstractApplication);
        } else if (!this.isInitialApplication(abstractApplication)) {
            this.stopApplicationCheckFirst(abstractApplication);
        } else if (this.isInitialApplication(abstractApplication) && this.initialApplications.size() > 1) {
            this.stopApplicationCheckFirst(abstractApplication);
        } else {
            this.stopApplicationManager();
        }
    }

    private void stopApplicationCheckFirst(AbstractApplication abstractApplication) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.stopApplicationCheckFirstImpl(abstractApplication);
        } else {
            final AbstractApplication abstractApplication2 = abstractApplication;
            Runnable runnable = new Runnable(){

                public void run() {
                    ApplicationManager.this.stopApplicationCheckFirstImpl(abstractApplication2);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopApplicationCheckFirstImpl(AbstractApplication abstractApplication) {
        if (this.canStop(abstractApplication)) {
            abstractApplication.stopApplicationNoCheck();
        }
    }

    void stopApplicationNoCheck(AbstractApplication abstractApplication) {
        Log.log(5, "ApplicationManager.stop (" + this.applications.size() + "): " + abstractApplication);
        this.disposeApplication(abstractApplication, true);
    }

    private void disposeApplication(AbstractApplication abstractApplication, boolean bl) {
        try {
            ApplicationPresenter applicationPresenter = abstractApplication.getApplicationPresenter();
            applicationPresenter.setVisible(false);
            applicationPresenter.stopNoCheck();
            applicationPresenter.dispose();
        }
        catch (Throwable throwable) {
            Log.logError("Could not stop application: ", throwable);
        }
        boolean bl2 = false;
        if (this.isInitialApplication(abstractApplication)) {
            bl2 = this.initialApplications.remove(abstractApplication);
            if (this.initialApplications.size() <= 0) {
                // empty if block
            }
        } else {
            bl2 = this.applications.removeElement(abstractApplication);
        }
        if (!bl2) {
            String string = "Application not found: " + abstractApplication;
            if (bl) {
                Log.assertion(false, string);
            } else {
                Log.logError(string);
            }
        }
    }

    synchronized void stopApplicationManager() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.stopApplicationManagerImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    ApplicationManager.this.stopApplicationManagerImpl();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void stopApplicationManagerImpl() {
        if (this.initialApplications.size() > 0) {
            Log.trace("ApplicationManager: Trying to stop ApplicationManager");
            if (this.canStopAllApplications()) {
                Enumeration enumeration = ((Vector)this.applications.clone()).elements();
                while (enumeration.hasMoreElements()) {
                    ((AbstractApplication)enumeration.nextElement()).stopApplicationNoCheck();
                }
                Log.assertion(this.applications.size() == 0, "Applications size > 0");
                enumeration = ((Vector)this.initialApplications.clone()).elements();
                while (enumeration.hasMoreElements()) {
                    ((AbstractApplication)enumeration.nextElement()).stopApplicationNoCheck();
                }
                Log.trace("ApplicationManager stopped");
                this.launcher.onExit(this.launchableApplication);
            }
        } else {
            Log.logWarning("### ApplicationManager already stopped");
        }
    }

    private boolean canStopAllApplications() {
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getAllApplications();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("  - ");
            stringBuffer.append(((AbstractApplication)enumeration.nextElement()).getTitle());
            stringBuffer.append("\n");
            ++n;
        }
        Hashtable hashtable = this.getFirstInitialApplication().getApplicationPresenter().getController().getExternalApplications();
        if (hashtable != null) {
            objectArray = hashtable.keys();
            while (objectArray.hasMoreElements()) {
                stringBuffer.append("  - ");
                stringBuffer.append((String)objectArray.nextElement());
                stringBuffer.append("\n");
                ++n;
            }
        }
        objectArray = new Object[]{stringBuffer.toString()};
        if (n > 0) {
            int n2 = this.getFirstInitialApplication().getApplicationPresenter().getController().showConfirmDialog("GSL_STOP_ALL_APP_MSG", objectArray, "GSL_STOP_ALL_APP_TITLE", null, 0, 2, null);
            return n2 == 0;
        }
        return true;
    }

    private boolean canStop(AbstractApplication abstractApplication) {
        boolean bl = true;
        try {
            if (!abstractApplication.getApplicationPresenter().canStop()) {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            Log.logError("Exception in canStop for application: " + abstractApplication, throwable);
        }
        return bl;
    }

    Hashtable getObjectNamingService() {
        if (this.objectNamingService == null) {
            this.objectNamingService = new Hashtable();
        }
        return this.objectNamingService;
    }

    static void loadBundle(String string, Locale locale, Properties properties) {
        Log.trace("loadBundle: " + string + " " + locale);
        Log.assertion(!string.equals(""), "Not allowed to specify empty string as bundle name");
        Log.measure("loadBundle", true, "Loading bundle");
        try {
            ResourceBundle resourceBundle = GuilibResourceBundle.getBundle(string, locale, myClassLoader);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                properties.put(string2, resourceBundle.getObject(string2));
            }
        }
        catch (Throwable throwable) {
            String string3 = "Could not create ResourceBundle: " + string;
            Log.trace(string3);
            Log.assertion(false, string3);
        }
        Log.measure("loadBundle", false);
    }

    static {
        PRESENTATION_TYPE_KEYS = new String[]{"GSL_DESKTOP", "GSL_MDI", "GSL_SDI", "GSL_TABBED"};
        PRESENTATION_TYPE_VALUES = new int[]{2, 1, 0, 3};
    }
}

