/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.Dimension;
import se.ericsson.wcdma.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractWizardController;
import se.ericsson.wcdma.support.gui.guilib.infra.ViewContainer;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardDefaultController;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardDefaultView;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardPresenter;

class WizardSlidePresenter
extends AbstractPresenter {
    private WizardDefaultView defaultView;
    private WizardDefaultController defaultController;
    private static int MINIMUM_WIDTH = 400;
    private static int MINIMUM_HEIGHT = 200;
    private WizardSlidePresenter nextPresenter = null;
    private WizardSlidePresenter previousPresenter = null;

    WizardSlidePresenter() {
    }

    ViewContainer createViewContainer() {
        return null;
    }

    WizardDefaultView getWizardDefaultView() {
        return this.defaultView;
    }

    AbstractWizardController getPreviousController() {
        return (AbstractWizardController)this.previousPresenter.getController();
    }

    Dimension getPreferredSize() {
        Dimension dimension = this.getView().getPreferredSize();
        if (dimension.width < MINIMUM_WIDTH) {
            dimension.width = MINIMUM_WIDTH;
        }
        if (dimension.height < MINIMUM_HEIGHT) {
            dimension.height = MINIMUM_HEIGHT;
        }
        return dimension;
    }

    WizardSlidePresenter getNextPresenter() {
        return this.nextPresenter;
    }

    WizardSlidePresenter getPreviousPresenter() {
        return this.previousPresenter;
    }

    protected void init() {
        this.previousPresenter = ((WizardPresenter)this.getParentPresenter()).getSlidePresenter();
        this.getView().init();
        this.getController().init();
        this.defaultView = (WizardDefaultView)this.createView(WizardDefaultView.class);
        this.defaultView.init();
        this.defaultController = (WizardDefaultController)this.createController(WizardDefaultController.class);
        this.defaultController.init();
    }

    boolean isFirst() {
        boolean bl = true;
        if (this.previousPresenter != null || ((AbstractWizardController)this.getController()).getPreviousViewClass() != null) {
            bl = false;
        }
        return bl;
    }

    boolean isResizable() {
        return this.getView().isResizable();
    }

    boolean isLast() {
        return ((AbstractWizardController)this.getController()).getNextViewClass() == null;
    }

    void setNextPresenter(WizardSlidePresenter wizardSlidePresenter) {
        this.nextPresenter = wizardSlidePresenter;
    }

    void setPreviousPresenter(WizardSlidePresenter wizardSlidePresenter) {
        this.previousPresenter = wizardSlidePresenter;
    }

    void updateLookAndFeel() {
        ComponentToolkit.updateLookAndFeel(this.defaultView);
        ComponentToolkit.updateLookAndFeel(this.getView());
        super.updateLookAndFeel();
    }

    void disposePresenter() {
        try {
            this.getParentPresenter().removeChildPresenter(this);
        }
        catch (Exception exception) {
            Log.logError("could not remove child presenter", exception);
        }
        super.dispose();
        this.defaultView.dispose();
        this.defaultController.dispose();
        this.defaultView = null;
        this.defaultController = null;
        this.nextPresenter = null;
        this.previousPresenter = null;
    }

    void disposePreviousPresenter() {
        if (this.previousPresenter != null) {
            this.previousPresenter.disposePreviousPresenter();
            this.previousPresenter.disposePresenter();
            this.previousPresenter = null;
        }
    }
}

