/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.resources;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;

public abstract class ResourceConstant {
    protected static final ArrayList allConstants = new ArrayList();
    public final String PATH;
    private URL cashedUrl;
    private String cashedFileName;

    public ResourceConstant(String string) {
        this.PATH = string;
        allConstants.add(this);
    }

    public synchronized URL getUrl() {
        if (this.cashedUrl == null) {
            this.cashedUrl = this.getClass().getClassLoader().getResource(this.PATH);
            if (this.cashedUrl == null) {
                this.getClass().getClassLoader();
                this.cashedUrl = ClassLoader.getSystemResource(this.PATH);
            }
            if (this.cashedUrl == null) {
                IOException iOException = new IOException("Could not find resource file=" + this.PATH + "!");
                Nal.getLog().nalTraceError(this.getClass(), "Bad ResourceConstant " + this + "!", iOException);
            }
        }
        return this.cashedUrl;
    }

    public abstract void dispose();

    protected abstract boolean junitIsLoadable();

    public synchronized String toString() {
        if (this.cashedFileName == null) {
            int n = this.PATH.lastIndexOf(47);
            this.cashedFileName = this.PATH.substring(n + 1);
        }
        return this.cashedFileName;
    }

    protected static synchronized String junitListMissingResourceFiles() {
        ArrayList<ResourceConstant> arrayList = new ArrayList<ResourceConstant>();
        for (ResourceConstant resourceConstant : allConstants) {
            if (!resourceConstant.junitIsLoadable()) {
                arrayList.add(resourceConstant);
            }
            resourceConstant.dispose();
        }
        return arrayList.toString();
    }

    protected static synchronized ArrayList junitGetAllConstants() {
        return allConstants;
    }
}

