/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.sync.EthernetPortRef;
import se.ericsson.cello.sync.SyncEthEgressMoGen;
import se.ericsson.cello.transaction.Coordinator;

public class SyncEthEgressMoImpl
extends SyncEthEgressMoGen {
    private static final int NSS_FROCLASS_ETHERNET_PORT = 1;

    public SyncEthEgressMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public SyncEthEgressMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("portRef");
        Coordinator coordinator = setRequestContext.getCoordinator();
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("froClassNo", this.getFroClassNum(managedObject)));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("isReservedByAnotherMo", this.isReservedByAnotherMO(managedObject, coordinator)));
    }

    protected void validatePortRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        super.validatePortRef(managedObject, setRequestContext);
        if (!(managedObject instanceof EthernetPortRef)) {
            throw new InvalidReferenceException("SyncEthEgress", "Reference should be of type EthernetPort only.");
        }
    }

    private int isReservedByAnotherMO(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray;
        int n = 0;
        if (managedObject instanceof EthernetPortRef && (managedObjectArray = ((EthernetPortRef)managedObject).getReservedBy(coordinator)) != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (managedObjectArray[i].getType().equalsIgnoreCase("SyncEthEgress")) continue;
                n = 1;
            }
        }
        return n;
    }

    private int getFroClassNum(ManagedObject managedObject) {
        int n = 0;
        if (managedObject instanceof EthernetPortRef) {
            n = 1;
        }
        return n;
    }
}

