/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sync;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sync.SystemClockDistributionMo;
import se.ericsson.cello.transaction.Coordinator;

public abstract class SystemClockDistributionMoGen
extends CelloMao
implements SystemClockDistributionMo {
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final String FROID = "froid";
    protected static final int MO_DATA_REVISION_LATEST = 9000;

    protected SystemClockDistributionMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "SystemClockDistribution", string, coordinator);
        this.froProxy = froProxy;
        String string2 = MoAttributeValidator.checkAndGetStringAttribute((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"SystemClockDistribution");
        this.validateUserLabel(string2, coordinator);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"SystemClockDistribution");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        SignedIntParameter signedIntParameter = new SignedIntParameter("piuId", this.getPiuId(coordinator));
        arrayList.add(signedIntParameter);
        SignedIntParameter signedIntParameter2 = new SignedIntParameter("smn", this.getSmn(coordinator));
        arrayList.add(signedIntParameter2);
        SignedIntParameter signedIntParameter3 = new SignedIntParameter("apn", this.getApn(coordinator));
        arrayList.add(signedIntParameter3);
        FroData froData = this.froProxy.create(coordinator, arrayList);
        int n = froData.getFroId();
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    protected abstract int getPiuId(Coordinator var1) throws MoAccessException;

    protected abstract int getSmn(Coordinator var1) throws MoAccessException;

    protected abstract int getApn(Coordinator var1) throws MoAccessException;

    public SystemClockDistributionMoGen(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("userLabel");
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("SystemClockDistribution");
        }
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.data.delete(coordinator);
        super.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getSystemClockDistributionId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("SystemClockDistributionId", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getType() {
        return "SystemClockDistribution";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "SystemClockDistribution");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "SystemClockDistribution");
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "SystemClockDistribution");
            }
            this.validateUserLabel((String)objectArray[i], coordinator);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
            if (arrayList.size() <= 0) continue;
            this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private Map getFroAttributes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.froProxy.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    protected void validateUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"SystemClockDistribution", (int)128, (int)0);
    }
}

