/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.logging.TraceGroup;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class LoggerImpl
implements AbstractLogger {
    private static final String LOG_FILE_PATH = File.separator + "d" + File.separator + "log_files" + File.separator + "upgrade.log";
    private static final Class THIS_CLASS = LoggerImpl.class;
    private static final AbstractLogger LOGGER = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String TRACE_TRACE = " TRACE";
    private static final String TRACE_INFO = " INFO: ";
    private static final String TRACE_ENTER = " ENTER: ";
    private static final String TRACE_ERROR = " ERROR: ";
    private static final String TRACE_PARAM = " PARAM: ";
    private static final String TRACE_RETRN = " RETRN: ";
    private static final String TRACE_GENERAL = " TRACE_GENERAL_3: ";
    private static final String TRACE_DEBUG = " TRACE_DEBUG_5: ";
    private static final String TRACE_TIMER = " TRACE_TIMER_2: ";
    private static final String TRACE_ABNORMAL = " TRACE_ABNORMAL_1: ";
    private static final String TRACE_SEND_SIG = " SEND_SIG: ";
    private static final String TRACE_REC_SIG = " REC_SIG: ";
    private static final String TRACE_STATE = " STATE: ";
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("[yyyy-MM-dd HH.mm.ss.SSS]", Locale.getDefault());
    private String logFilePath = LOG_FILE_PATH;

    public LoggerImpl(boolean resetLogFile) {
        String useLogFileProp = System.getProperty("se.ericsson.crbs.omf.aue.LogToFile");
        if (useLogFileProp != null && useLogFileProp.equalsIgnoreCase("true")) {
            String logFilePathProp = System.getProperty("se.ericsson.crbs.omf.aue.LogFilePath");
            if (logFilePathProp != null) {
                this.logFilePath = logFilePathProp;
            }
            AueUtil.writeToFile(this.logFilePath, "Reset by Step1", !resetLogFile);
            LOGGER.addListeningLogger(this);
        }
    }

    public void addListeningLogger(AbstractLogger notUsed) {
    }

    public void removeListeningLogger(AbstractLogger notUsed) {
    }

    private void trace(TraceGroup group, Class clazz, String msg) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(this.getTraceGroup(group.getGroupNumber())).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void info(Class clazz, String msg) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_INFO).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceAbnormal(Class clazz, String msg) {
        this.trace(TraceGroup.ABNORMAL, clazz, msg);
    }

    public void traceDebug(Class clazz, String msg) {
        this.trace(TraceGroup.DEBUG, clazz, msg);
    }

    public void traceDebugStackTrace(Class clazz, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        stringWriter.flush();
        StringBuffer msg = new StringBuffer("");
        try {
            stringWriter.close();
        }
        catch (IOException e) {
            msg.append(e.getMessage());
        }
        msg.append(stringWriter.toString());
        this.trace(TraceGroup.DEBUG, clazz, msg.toString());
    }

    public void traceEnter(Class clazz, String msg) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_ENTER).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceError(Class clazz, String msg) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_ERROR).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceError(Class clazz, String msg, Throwable throwable) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_ERROR).append(msg).append(" ").append(AueUtil.convertToString(throwable));
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceGeneral(Class clazz, String msg) {
        this.trace(TraceGroup.GENERAL, clazz, msg);
    }

    public void traceParam(Class clazz, String msg) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_PARAM).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceReturn(Class clazz, String msg) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_RETRN).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceRecSig(Class clazz, String msg, InSignal inSignal) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_REC_SIG).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceSendSig(Class clazz, String msg, OutSignal outSignal, OseProcess oseProcess) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_SEND_SIG).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceState(Class clazz, String msg) {
        StringBuffer buf = new StringBuffer(this.getTime(System.currentTimeMillis())).append(" ").append(Thread.currentThread().getName()).append(" ").append(clazz.getName()).append(TRACE_STATE).append(msg);
        AueUtil.appendToFile(this.logFilePath, buf.toString());
    }

    public void traceTimer(Class clazz, String msg) {
        this.trace(TraceGroup.TIMER, clazz, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTime(long desiredTime) {
        SimpleDateFormat simpleDateFormat = TIME_FORMAT;
        synchronized (simpleDateFormat) {
            return TIME_FORMAT.format(new Date(desiredTime));
        }
    }

    private String getTraceGroup(int traceGroupNumber) {
        String traceGroup;
        switch (traceGroupNumber) {
            case 1: {
                traceGroup = TRACE_ABNORMAL;
                break;
            }
            case 2: {
                traceGroup = TRACE_TIMER;
                break;
            }
            case 3: {
                traceGroup = TRACE_GENERAL;
                break;
            }
            case 5: {
                traceGroup = TRACE_DEBUG;
                break;
            }
            default: {
                traceGroup = TRACE_TRACE;
            }
        }
        return traceGroup;
    }
}

