/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.logging;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.TraceGroup;

public class StdioLogger
implements AbstractLogger {
    protected boolean basicOn;
    protected boolean debugOn;
    protected boolean enterReturnOn;
    private final List listeningLoggers = new ArrayList();

    public StdioLogger() {
        this(true, true, true);
    }

    StdioLogger(boolean basicOn, boolean debugOn, boolean enterReturnOn) {
        String envShowOutputString = System.getProperty("show.output", "false");
        boolean envShowOutput = "on".equalsIgnoreCase(envShowOutputString) || "true".equalsIgnoreCase(envShowOutputString);
        this.basicOn = basicOn && envShowOutput;
        this.debugOn = debugOn && envShowOutput;
        this.enterReturnOn = enterReturnOn && envShowOutput;
    }

    public void info(Class clazz, String msg) {
        if (this.basicOn) {
            StringBuffer buf = new StringBuffer().append("INFO :").append(clazz).append(' ').append(msg);
            System.out.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.info(clazz, msg);
        }
    }

    private void trace(TraceGroup group, Class clazz, String msg) {
        if (this.debugOn) {
            StringBuffer buf = new StringBuffer().append("TRACE:").append(group).append(' ').append(clazz).append(' ').append(msg);
            System.out.println(buf.toString());
        }
    }

    public void traceAbnormal(Class clazz, String msg) {
        this.trace(TraceGroup.ABNORMAL, clazz, msg);
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceAbnormal(clazz, msg);
        }
    }

    public void traceDebug(Class clazz, String msg) {
        if (this.debugOn) {
            this.trace(TraceGroup.DEBUG, clazz, msg);
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceDebug(clazz, msg);
        }
    }

    public void traceDebugStackTrace(Class clazz, Throwable exc) {
        if (this.debugOn) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exc.printStackTrace(printWriter);
            stringWriter.flush();
            String msg = "";
            try {
                stringWriter.close();
            }
            catch (IOException e) {
                msg = msg + e.getMessage();
            }
            msg = msg + stringWriter.toString();
            this.trace(TraceGroup.DEBUG, clazz, msg);
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceDebugStackTrace(clazz, exc);
        }
    }

    public void traceEnter(Class clazz, String msg) {
        if (this.enterReturnOn) {
            StringBuffer buf = new StringBuffer().append("ENTER:").append(clazz).append(' ').append(msg);
            System.out.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceEnter(clazz, msg);
        }
    }

    public void traceError(Class clazz, String msg) {
        if (this.basicOn) {
            StringBuffer buf = new StringBuffer().append("ERROR:").append(clazz).append(' ').append(msg);
            System.err.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceError(clazz, msg);
        }
    }

    public void traceError(Class clazz, String msg, Throwable throwable) {
        if (this.basicOn) {
            StringBuffer buf = new StringBuffer().append("ERROR:").append(clazz).append(' ').append(msg).append(' ').append(throwable);
            System.err.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceError(clazz, msg, throwable);
        }
    }

    public void traceGeneral(Class clazz, String msg) {
        if (this.debugOn) {
            this.trace(TraceGroup.GENERAL, clazz, msg);
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceGeneral(clazz, msg);
        }
    }

    public void traceParam(Class clazz, String msg) {
        if (this.debugOn) {
            StringBuffer buf = new StringBuffer().append("PARAM:").append(clazz).append(' ').append(msg);
            System.out.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceParam(clazz, msg);
        }
    }

    public void traceReturn(Class clazz, String msg) {
        if (this.enterReturnOn) {
            StringBuffer buf = new StringBuffer().append("RETRN:").append(clazz).append(' ').append(msg);
            System.out.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceReturn(clazz, msg);
        }
    }

    public void traceTimer(Class clazz, String msg) {
        this.trace(TraceGroup.TIMER, clazz, msg);
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceTimer(clazz, msg);
        }
    }

    public void traceRecSig(Class clazz, String msg, InSignal inSignal) {
        if (this.debugOn) {
            StringBuffer buf = new StringBuffer();
            buf.append("RESIG:").append(clazz).append(' ').append(msg);
            try {
                int sigNo = inSignal.getSigNo();
                buf.append(", SigNo: ").append(sigNo);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            System.out.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceRecSig(clazz, msg, inSignal);
        }
    }

    public void traceSendSig(Class clazz, String msg, OutSignal outSignal, OseProcess oseProcess) {
        if (this.debugOn) {
            StringBuffer buf = new StringBuffer();
            buf.append("SESIG:").append(clazz).append(' ').append(msg);
            try {
                int sigNo = outSignal.javaToOse();
                buf.append(", SigNo: ").append(sigNo);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            System.out.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceSendSig(clazz, msg, outSignal, oseProcess);
        }
    }

    public void traceState(Class clazz, String msg) {
        if (this.debugOn) {
            StringBuffer buf = new StringBuffer().append("STATE:").append(clazz).append(' ').append(msg);
            System.out.println(buf.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger listeningLogger = (AbstractLogger)this.listeningLoggers.get(i);
            listeningLogger.traceState(clazz, msg);
        }
    }

    public void addListeningLogger(AbstractLogger logger) {
        this.listeningLoggers.add(logger);
    }

    public void removeListeningLogger(AbstractLogger logger) {
        this.listeningLoggers.remove(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLogger[] getListeningLoggers() {
        List list = this.listeningLoggers;
        synchronized (list) {
            AbstractLogger[] result = new AbstractLogger[this.listeningLoggers.size()];
            this.listeningLoggers.toArray(result);
            return result;
        }
    }
}

