/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.data;

import java.util.Locale;
import se.ericsson.crbs.omf.aue.common.db.DbUtil;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class TableColumnHeaderData
implements Comparable {
    private static final Class THIS_CLASS = TableColumnHeaderData.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private String columnName;
    private String sqlType = "";
    private String momType = "";
    private Class javaType = String.class;
    private int length = -1;
    private boolean primaryKey = false;
    private String defaultValue = "";

    protected TableColumnHeaderData(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected void setColumnName(String columnName) {
        this.columnName = columnName;
        logger.traceDebug(THIS_CLASS, "setColumnName(" + columnName + ")");
    }

    public String getSqlType() {
        return this.sqlType;
    }

    protected void setSqlType(String sqlType) {
        this.sqlType = sqlType;
        this.momType = "";
        if (sqlType.equalsIgnoreCase("integer")) {
            this.javaType = Integer.class;
        } else if (sqlType.equalsIgnoreCase("varchar")) {
            this.javaType = String.class;
        }
        logger.traceDebug(THIS_CLASS, "setSqlType(" + sqlType + ")");
    }

    public String getMomType() {
        return this.momType;
    }

    protected void setMomType(String momType) {
        this.setSqlType(DbUtil.getSqlDataType(momType));
        this.momType = momType;
        this.length = 0;
        logger.traceDebug(THIS_CLASS, "setMomType(" + momType + ")");
    }

    public Class getJavaType() {
        return this.javaType;
    }

    protected void setLength(int length) {
        this.length = length;
        logger.traceDebug(THIS_CLASS, "setLength(" + length + ")");
    }

    public int getLength() {
        return this.length;
    }

    protected void setPrimaryKey(boolean isPrimaryKey) {
        this.primaryKey = isPrimaryKey;
        logger.traceDebug(THIS_CLASS, "setPrimaryKey(" + isPrimaryKey + ")");
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        logger.traceDebug(THIS_CLASS, "setDefaultValue(" + defaultValue + ")");
    }

    public int compareTo(Object otherObj) {
        int result = 0;
        if (otherObj != null && otherObj instanceof TableColumnHeaderData) {
            TableColumnHeaderData otherTableColumnHeaderData = (TableColumnHeaderData)otherObj;
            if ("froid".equalsIgnoreCase(this.columnName)) {
                result = -1;
            } else if ("froid".equalsIgnoreCase(otherTableColumnHeaderData.columnName)) {
                result = 1;
            } else {
                String columnNameOne = this.columnName.toLowerCase(Locale.getDefault());
                String columnNameTwo = otherTableColumnHeaderData.columnName.toLowerCase(Locale.getDefault());
                result = columnNameOne.compareTo(columnNameTwo);
            }
        }
        return result;
    }
}

