/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableCellData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableColumnHeaderData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

public class TableRowData
implements Comparable {
    private static final Class THIS_CLASS = TableRowData.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final List rowDataList = new ArrayList();

    protected TableRowData() {
    }

    protected void addRowData(TableColumnHeaderData tableColumnHeaderData, Object newRowData) {
        TableCellData tableCellData = new TableCellData(tableColumnHeaderData, newRowData);
        this.rowDataList.add(tableCellData);
        logger.traceDebug(THIS_CLASS, "addRowData(" + tableColumnHeaderData.getColumnName() + ")");
    }

    protected TableCellData[] getRowData() {
        TableCellData[] rowDataArray = new TableCellData[this.rowDataList.size()];
        this.rowDataList.toArray(rowDataArray);
        return rowDataArray;
    }

    protected int getSize() {
        return this.rowDataList.size();
    }

    protected void setColumnData(int columnIndex, Object columnValue) throws TableDataException {
        if (columnIndex < 0 || columnIndex >= this.rowDataList.size()) {
            String errorMsg = "Specified column, " + columnIndex + ", is not present in this row";
            logger.traceError(THIS_CLASS, errorMsg);
            throw new TableDataException(errorMsg);
        }
        TableCellData tableCellData = (TableCellData)this.rowDataList.get(columnIndex);
        tableCellData.setCellValue(columnValue);
        logger.traceDebug(THIS_CLASS, "setColumnData(" + columnIndex + ", " + columnValue + ")");
    }

    public boolean equals(Object otherObj) {
        boolean result = true;
        if (otherObj instanceof TableRowData) {
            TableRowData otherRowData = (TableRowData)otherObj;
            for (int i = 0; i < this.rowDataList.size(); ++i) {
                try {
                    boolean bl = result = result && this.rowDataList.get(i).equals(otherRowData.rowDataList.get(i));
                    if (result) continue;
                }
                catch (Exception e) {
                    result = false;
                }
                break;
            }
        } else {
            result = super.equals(otherObj);
        }
        return result;
    }

    public int hashCode() {
        return this.getAllColumnsConcatenated().hashCode();
    }

    public int compareTo(Object otherObj) {
        int result = 0;
        if (otherObj != null && otherObj instanceof TableRowData) {
            TableRowData otherRowData = (TableRowData)otherObj;
            result = this.getAllColumnsConcatenated().toLowerCase(Locale.getDefault()).compareTo(otherRowData.getAllColumnsConcatenated().toLowerCase(Locale.getDefault()));
        }
        return result;
    }

    private String getAllColumnsConcatenated() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.rowDataList.size(); ++i) {
            TableCellData tableCellData = (TableCellData)this.rowDataList.get(i);
            buffer.append(tableCellData.getTableColumnHeaderData().getColumnName());
        }
        return buffer.toString();
    }
}

