/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.treetable;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.gui.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeTableModel
extends DefaultTreeModel
implements TreeTableModel {
    private static final long serialVersionUID = -44558872125652389L;

    public AbstractTreeTableModel(TreeNode theRoot) {
        super(theRoot);
        this.root = theRoot;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object nodeObject) {
        if (nodeObject instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)nodeObject).isLeaf();
        }
        return this.getChildCount(nodeObject) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treepath, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parents, Object children) {
        for (int i = 0; i < this.getChildCount(parents); ++i) {
            if (!this.getChild(parents, i).equals(children)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listen) {
        this.listenerList.add(TreeModelListener.class, listen);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listen) {
        this.listenerList.remove(TreeModelListener.class, listen);
    }

    @Override
    protected void fireTreeNodesChanged(Object resource, Object[] treepath, int[] childrenIndices, Object[] childrens) {
        Object[] listener = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listener.length - 2; i >= 0; i -= 2) {
            if (listener[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(resource, treepath, childrenIndices, childrens);
            }
            ((TreeModelListener)listener[i + 1]).treeNodesChanged(event);
        }
    }

    @Override
    protected void fireTreeNodesInserted(Object sources, Object[] treepath, int[] childrenIndices, Object[] childrens) {
        Object[] listener = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listener.length - 2; i >= 0; i -= 2) {
            if (listener[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(sources, treepath, childrenIndices, childrens);
            }
            ((TreeModelListener)listener[i + 1]).treeNodesInserted(event);
        }
    }

    @Override
    protected void fireTreeNodesRemoved(Object resource, Object[] treepath, int[] childrenIndices, Object[] childrens) {
        Object[] listener = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listener.length - 2; i >= 0; i -= 2) {
            if (listener[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(resource, treepath, childrenIndices, childrens);
            }
            ((TreeModelListener)listener[i + 1]).treeNodesRemoved(event);
        }
    }

    @Override
    protected void fireTreeStructureChanged(Object resource, Object[] treepath, int[] childrenIndices, Object[] childrens) {
        Object[] listener = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listener.length - 2; i >= 0; i -= 2) {
            if (listener[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(resource, treepath, childrenIndices, childrens);
            }
            ((TreeModelListener)listener[i + 1]).treeStructureChanged(event);
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(Object nodes, int columns) {
        return this.getColumnClass(columns) == TreeTableModel.class;
    }

    @Override
    public void setValueAt(Object aValue, Object nodes, int columns) {
    }
}

