/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.gui.treetable.AbstractCellEditor;
import se.ericsson.cello.nex.gui.treetable.TreeTableModel;
import se.ericsson.cello.nex.gui.treetable.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = 1564066989259241234L;
    protected TreeTableCellRenderer treeTableCell;
    protected TreeTableModel treeTableModeler;
    protected TreeTableModelAdapter modeladapterTable;
    private int selected_columns;

    public JTreeTable(TreeTableModel treeTableModelInput) {
        this.treeTableModeler = treeTableModelInput;
        this.treeTableCell = new TreeTableCellRenderer(this.treeTableModeler);
        this.modeladapterTable = new TreeTableModelAdapter(this.treeTableModeler, this.treeTableCell);
        super.setModel(this.modeladapterTable);
        ListToTreeSelectionModelWrapper treeSelectionWrapperModel = new ListToTreeSelectionModelWrapper();
        this.treeTableCell.setSelectionModel(treeSelectionWrapperModel);
        this.setSelectionModel(treeSelectionWrapperModel.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.treeTableCell);
        TreeTableCellEditor treeTableEditor = new TreeTableCellEditor();
        this.setDefaultEditor(TreeTableModel.class, treeTableEditor);
        this.setShowGrid(true);
        this.setGridColor(Color.black);
        this.setShowVerticalLines(true);
        this.setDoubleBuffered(true);
        this.setIntercellSpacing(new Dimension(1, 0));
        if (this.treeTableCell.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    public void resizeAndRepaintTable() {
        this.resizeAndRepaint();
    }

    public void updateUI() {
        super.updateUI();
        if (this.treeTableCell != null) {
            this.treeTableCell.updateUI();
        }
    }

    public void columnMoved(TableColumnModelEvent event) {
        this.updateUI();
    }

    public void setRowHeight(int newrowHeight) {
        super.setRowHeight(newrowHeight);
        if (this.treeTableCell != null && this.treeTableCell.getRowHeight() != newrowHeight) {
            this.treeTableCell.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.treeTableCell;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public void changeSelection(int rowIndexes, int columnIndexes, boolean toggle, boolean extending) {
        super.changeSelection(rowIndexes, columnIndexes, toggle, extending);
        this.selected_columns = 0;
    }

    public void selectTheColumn(int columnNumberSelect) {
        if (columnNumberSelect > 0) {
            try {
                this.setColumnSelectionInterval(columnNumberSelect, columnNumberSelect);
                this.setRowSelectionInterval(0, this.getRowCount() - 1);
                this.selected_columns = columnNumberSelect;
            }
            catch (Exception exception) {}
        } else {
            this.selected_columns = 0;
        }
    }

    public int getTheSelectedColumn() {
        return this.selected_columns;
    }

    private void sortColumns(int rowIndex) {
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -1073390187644180553L;
        protected boolean updatingListSelectModels;

        public ListToTreeSelectionModelWrapper() {
            ListSelectionListener listSelectionListener = this.createListSelectionListener();
            this.getListSelectionModel().addListSelectionListener(listSelectionListener);
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectModels) {
                this.updatingListSelectModels = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectModels = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent eventSelect) {
                if (!ListToTreeSelectionModelWrapper.this.updatingListSelectModels) {
                    ListToTreeSelectionModelWrapper.this.updatingListSelectModels = true;
                    try {
                        int minSelectionRow = ListToTreeSelectionModelWrapper.this.listSelectionModel.getMinSelectionIndex();
                        int maxSelectionRow = ListToTreeSelectionModelWrapper.this.listSelectionModel.getMaxSelectionIndex();
                        ListToTreeSelectionModelWrapper.this.clearSelection();
                        if (minSelectionRow != -1 && maxSelectionRow != -1) {
                            for (int counterRow = minSelectionRow; counterRow <= maxSelectionRow; ++counterRow) {
                                TreePath selTreePath;
                                if (!ListToTreeSelectionModelWrapper.this.listSelectionModel.isSelectedIndex(counterRow) || (selTreePath = JTreeTable.this.treeTableCell.getPathForRow(counterRow)) == null) continue;
                                ListToTreeSelectionModelWrapper.this.addSelectionPath(selTreePath);
                            }
                        }
                    }
                    finally {
                        ListToTreeSelectionModelWrapper.this.updatingListSelectModels = false;
                    }
                }
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rows, int column) {
            return JTreeTable.this.treeTableCell;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int countColumn = JTreeTable.this.getColumnCount() - 1; countColumn >= 0; --countColumn) {
                    if (JTreeTable.this.getColumnClass(countColumn) != TreeTableModel.class) continue;
                    MouseEvent mouseevent = (MouseEvent)eventObject;
                    MouseEvent newMouseEvent = new MouseEvent(JTreeTable.this.treeTableCell, mouseevent.getID(), mouseevent.getWhen(), mouseevent.getModifiers(), mouseevent.getX() - JTreeTable.this.getCellRect((int)0, (int)countColumn, (boolean)true).x, mouseevent.getY(), mouseevent.getClickCount(), mouseevent.isPopupTrigger());
                    JTreeTable.this.treeTableCell.dispatchEvent(newMouseEvent);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private static final long serialVersionUID = 7098645708770959532L;
        protected int visibleRenderer;

        public TreeTableCellRenderer(TreeModel newtreemodels) {
            super(newtreemodels);
            super.setOpaque(true);
            Font font = this.getFont();
            Font tfont = new Font(font.getName(), 1, font.getSize());
            this.setFont(tfont);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcellRenderer = this.getCellRenderer();
            if (tcellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcellRenderer = (DefaultTreeCellRenderer)tcellRenderer;
                dtcellRenderer.setBorderSelectionColor(null);
                dtcellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeigh) {
            if (rowHeigh > 0) {
                super.setRowHeight(rowHeigh);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeigh) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int width, int heigh) {
            super.setBounds(x, 0, width, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphic) {
            graphic.translate(0, -this.visibleRenderer * this.getRowHeight());
            super.paint(graphic);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean Selected, boolean Focus, int rowvalue, int columnvalue) {
            Color col = table.getSelectionBackground();
            if (Selected) {
                this.setBackground(col);
            } else {
                col = table.getBackground();
                this.setBackground(col);
            }
            this.visibleRenderer = rowvalue;
            return this;
        }
    }
}

