/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.treetable;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.gui.treetable.TreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private static final long serialVersionUID = -6152506822830154628L;
    JTree jTree;
    TreeTableModel treeTM;

    public TreeTableModelAdapter(TreeTableModel treeTM, JTree jTree) {
        this.jTree = jTree;
        this.treeTM = treeTM;
        TreeExpansionListener treeExpansionListener = new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        };
        jTree.addTreeExpansionListener(treeExpansionListener);
        TreeModelListener treeModelListener = new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        };
        treeTM.addTreeModelListener(treeModelListener);
    }

    public Object nodeForRow(int r) {
        TreePath path = this.jTree.getPathForRow(r);
        if (null == path) {
            return null;
        }
        return path.getLastPathComponent();
    }

    public int getColumnCount() {
        return this.treeTM.getColumnCount();
    }

    public String getColumnName(int c) {
        return this.treeTM.getColumnName(c);
    }

    public Class getColumnClass(int c) {
        return this.treeTM.getColumnClass(c);
    }

    public int getRowCount() {
        return this.jTree.getRowCount();
    }

    public Object getValueAt(int r, int c) {
        return this.treeTM.getValueAt(this.nodeForRow(r), c);
    }

    public boolean isCellEditable(int r, int c) {
        return this.treeTM.isCellEditable(this.nodeForRow(r), c);
    }

    public void setValueAt(Object v, int r, int c) {
        this.treeTM.setValueAt(v, this.nodeForRow(r), c);
    }

    protected void delayedFireTableDataChanged() {
        Runnable runnable = new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

