/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.GuiView;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;

public class WillExpandListener
implements TreeWillExpandListener {
    private GuiView view;
    private MoTreeTableModel model;
    private JTree tree;

    public WillExpandListener(GuiView aView, JTree aTree, MoTreeTableModel aModel) {
        this.view = aView;
        this.model = aModel;
        this.tree = aTree;
    }

    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        NexLog.logger().finest("treeWillExpand");
        TreePath treePath = event.getPath();
        NexTreeNode node = (NexTreeNode)treePath.getLastPathComponent();
        int rowNumber = this.tree.getRowForPath(treePath);
        if (0 == node.getChildCount() && !node.hasFetchedChildren()) {
            this.view.monitorTreeProcess("", this.model.asynchronousExpandNode(node, new ExpandCallback<Void>(rowNumber)));
        } else if (node.isPartiallyExpanded() && this.tree.hasBeenExpanded(treePath)) {
            ModelCallback<NexTreeNode> callBackForGuiUpdate = new ModelCallback<NexTreeNode>(){

                @Override
                public void run(NexTreeNode node, boolean cancelled) {
                    WillExpandListener.this.view.expandToNode(node);
                }
            };
            this.view.monitorTreeProcess("", this.model.asynchronousRefreshNode(node, callBackForGuiUpdate));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpandCallback<T>
    extends ModelCallback<T> {
        private int rowToSelect;

        public ExpandCallback(int rowToSelect) {
            this.rowToSelect = rowToSelect;
        }

        @Override
        public void run(T result, boolean cancelled) {
            if (cancelled) {
                WillExpandListener.this.view.setStatusMessage("The expansion was aborted.");
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WillExpandListener.this.tree.setSelectionRow(ExpandCallback.this.rowToSelect);
                    }
                });
            }
        }
    }
}

