/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.parser;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.nex.NexLog;

public class Parser {
    private Document document;
    private static final String NEX_SCHEMA = "NEX.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parser(InputSource xmlSource, boolean validate) throws SAXException, IOException, ParserConfigurationException {
        ClassLoader savedClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            DOMParser parser = new DOMParser();
            NexLog.logger().info("DOMParser is: " + parser);
            parser.setFeature("http://apache.org/xml/features/xinclude", true);
            parser.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            parser.parse(xmlSource);
            this.document = parser.getDocument();
            if (validate) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource schemaFile = new StreamSource(Parser.class.getResourceAsStream(NEX_SCHEMA));
                Schema schema = factory.newSchema(schemaFile);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(this.document));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedClassloader);
        }
    }

    public Parser(InputSource xmlSource) throws SAXException, IOException, ParserConfigurationException {
        this(xmlSource, false);
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRoot() {
        return this.document.getDocumentElement();
    }
}

