/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xml.sax.InputSource;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.utils.ViewFileReaderException;
import se.ericsson.cello.nex.viewservices.viewlist.model.ViewLoadModuleData;
import se.ericsson.cello.nex.viewservices.viewlist.model.ViewlistXmlModel;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.launcher.util.EmasUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewJarfileReader {
    private static final boolean VALIDATE_XML_FILE = true;
    private static final String VIEW_FILE_ENCODING = "ISO-8859-1";

    public static void fetchPreDefViews(URL viewlistURL, URL viewRepository, ToolServicesI toolServices, Map<String, String> mapWithNames) throws ViewFileReaderException {
        String urlString;
        NexLog.logger().fine("");
        NexLog.logger().info("Read URL: " + viewlistURL);
        ViewFileReaderException exceptionToThrow = null;
        ArrayList<ViewLoadModuleData> viewlist = new ArrayList<ViewLoadModuleData>();
        boolean readTextualViewList = false;
        if (viewlistURL.toString().endsWith(".xml")) {
            try {
                ViewJarfileReader.listViewsInXml(viewlistURL, viewlist);
                NexLog.logger().info("Viewlist.xml has been parsed. ");
            }
            catch (ViewFileReaderException e) {
                ViewFileReaderException exceptionFromReadingViewlistXml = e;
                NexLog.logger().info(e.getClass().getName() + " when trying to read viewlist.xml on the node.");
                urlString = viewlistURL.toExternalForm().replace("/cello/emas/viewlist.xml", "/cello/emas/viewlist.txt");
                try {
                    NexLog.logger().warning(".Will try with viewlist.txt instead.");
                    viewlistURL = new URL(urlString);
                    readTextualViewList = true;
                }
                catch (Exception malEx) {
                    NexLog.logger().info("Failed constructing URL to viewlist.txt. " + malEx);
                    readTextualViewList = false;
                    exceptionToThrow = exceptionFromReadingViewlistXml;
                }
            }
        } else {
            readTextualViewList = true;
        }
        if (readTextualViewList) {
            try {
                ViewJarfileReader.listViewsInTxt(viewlistURL, viewlist);
                NexLog.logger().info("Viewlist.txt has been parsed. ");
            }
            catch (ViewFileReaderException e) {
                exceptionToThrow = e;
            }
        }
        ViewFileReaderException xmlException = null;
        ViewFileReaderException txtException = null;
        if (exceptionToThrow == null && (exceptionToThrow = (xmlException = ViewJarfileReader.getViewListElements(viewlistURL, viewRepository, toolServices, mapWithNames, viewlist, readTextualViewList))) != null && !readTextualViewList) {
            viewlist = new ArrayList();
            urlString = viewlistURL.toExternalForm().replace("/cello/emas/viewlist.xml", "/cello/emas/viewlist.txt");
            NexLog.logger().warning("Will try with viewlist.txt instead.");
            readTextualViewList = true;
            try {
                mapWithNames.clear();
                viewlistURL = new URL(urlString);
                ViewJarfileReader.listViewsInTxt(viewlistURL, viewlist);
                txtException = ViewJarfileReader.getViewListElements(viewlistURL, viewRepository, toolServices, mapWithNames, viewlist, readTextualViewList);
                if (txtException != null) {
                    ViewJarfileReader.setCause(exceptionToThrow, txtException);
                } else {
                    exceptionToThrow = null;
                }
            }
            catch (MalformedURLException ex) {
                ViewJarfileReader.setCause(exceptionToThrow, ex);
            }
            catch (ViewFileReaderException e) {
                ViewJarfileReader.setCause(exceptionToThrow, e);
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
    }

    private static ViewFileReaderException getViewListElements(URL viewlistURL, URL viewRepository, ToolServicesI toolServices, Map<String, String> mapWithNames, Collection<ViewLoadModuleData> viewlist, boolean readTextualViewList) {
        ViewFileReaderException exceptionToThrow = null;
        if (viewlist.isEmpty()) {
            NexLog.logger().info("No list of views could be constructed from " + viewlistURL);
        } else {
            String a_jarName = "";
            ViewLoadModuleData jarFile2 = null;
            try {
                for (ViewLoadModuleData jarFile2 : viewlist) {
                    ViewFileReaderException excep;
                    String viewsProblem;
                    a_jarName = jarFile2.filePathOnNode;
                    if (0 == a_jarName.trim().length()) {
                        NexLog.logger().warning("View jar file path is missing in viewlist file. ");
                        continue;
                    }
                    if (!(a_jarName = a_jarName.trim()).startsWith("/")) {
                        a_jarName = "/" + a_jarName;
                    }
                    URL a_JarURL = new URL(viewRepository.toString() + a_jarName);
                    String a_cashedFilePath = "";
                    try {
                        if (!jarFile2.productNumber.equals("") && !jarFile2.productRevision.equals("") && toolServices.getLauncher() instanceof LauncherInterface.RevB) {
                            LauncherInterface.RevB launcherRevB = (LauncherInterface.RevB)toolServices.getLauncher();
                            a_cashedFilePath = launcherRevB.getFile(a_JarURL, jarFile2.productName, jarFile2.productNumber, jarFile2.productRevision, (DownloadListener)new StubbedDownloadListener());
                        } else {
                            a_cashedFilePath = toolServices.getLauncher().getFile(a_JarURL, (DownloadListener)new StubbedDownloadListener());
                            if (!readTextualViewList && (jarFile2.productNumber.equals("") || jarFile2.productRevision.equals(""))) {
                                String viewsProblem2 = "ProductNumber or ProductRevision is missing for view " + a_JarURL + " in viewlist.xml.";
                                NexLog.logger().warning(viewsProblem2);
                            }
                        }
                        mapWithNames.putAll(ViewJarfileReader.getPreDefinedViewNames(a_cashedFilePath));
                    }
                    catch (LauncherException e) {
                        viewsProblem = "LauncherException when reading a view file from node, or from cache. \nURL: " + a_JarURL + "\n" + e.getMessage();
                        NexLog.logger().warning(viewsProblem + NexLog.stackToString((Exception)((Object)e)));
                        if (!a_cashedFilePath.equalsIgnoreCase("")) {
                            viewsProblem = ViewJarfileReader.removeFileIfPossible(a_cashedFilePath) ? viewsProblem + " " + a_cashedFilePath + " was deleted.\n" : viewsProblem + " " + a_cashedFilePath + " is corrupt. Please, remove it.\n";
                        }
                        excep = new ViewFileReaderException((Throwable)e, viewsProblem, a_jarName);
                        if (null == exceptionToThrow) {
                            exceptionToThrow = excep;
                            continue;
                        }
                        ViewJarfileReader.setCause(exceptionToThrow, excep);
                    }
                    catch (ViewFileReaderException vex) {
                        if (null == exceptionToThrow) {
                            exceptionToThrow = vex;
                            continue;
                        }
                        ViewJarfileReader.setCause(exceptionToThrow, vex);
                    }
                    catch (Exception ex) {
                        viewsProblem = ex.getClass().getName() + " when reading a file which contains view files. " + a_cashedFilePath;
                        NexLog.logger().warning(viewsProblem + "\n" + NexLog.stackToString(ex));
                        excep = new ViewFileReaderException((Throwable)ex, viewsProblem);
                        if (null == exceptionToThrow) {
                            exceptionToThrow = excep;
                            continue;
                        }
                        ViewJarfileReader.setCause(exceptionToThrow, excep);
                    }
                }
            }
            catch (Exception e) {
                String viewsProblem = e.getClass().getName() + " when reading a file from the node which contains view files. " + a_jarName;
                NexLog.logger().warning(viewsProblem + "\n" + NexLog.stackToString(e));
                ViewFileReaderException excep = new ViewFileReaderException((Throwable)e, viewsProblem);
                if (null == exceptionToThrow) {
                    exceptionToThrow = excep;
                }
                ViewJarfileReader.setCause(exceptionToThrow, excep);
            }
        }
        return exceptionToThrow;
    }

    public static InputSource getViewInputSource(String viewName, Map<String, String> jarFilePathMap) throws IOException, ViewFileReaderException {
        NexLog.logger().fine("viewName is: " + viewName);
        String jarFileName = jarFilePathMap.get(viewName);
        String viewFileName = viewName.replace(' ', '_') + ".xml";
        NexLog.logger().fine("jarFileName is: " + jarFileName);
        if (null == jarFileName) {
            NexLog.logger().warning("No pre-defined view file name for: " + viewName);
            return null;
        }
        JarFile aJarFile = null;
        try {
            aJarFile = new JarFile(jarFileName, true);
        }
        catch (IOException ioe) {
            NexLog.logger().warning(ioe.getClass().getName() + " when reading a view jar file from cache.\n");
            throw ioe;
        }
        Enumeration<JarEntry> jarFileEntries = aJarFile.entries();
        StringBuilder resultingSourceString = new StringBuilder();
        while (jarFileEntries.hasMoreElements()) {
            JarEntry entry = jarFileEntries.nextElement();
            String entryName = entry.getName();
            int b = entryName.lastIndexOf("/") + 1;
            if (entry.isDirectory() || entry.getName().contains("META-INF") || !entryName.substring(b).equals(viewFileName)) continue;
            String fileContents = ViewJarfileReader.readFromFileInsideJarAndWriteToString(jarFileName, viewFileName, aJarFile, entry);
            resultingSourceString.append(fileContents);
            break;
        }
        ViewJarfileReader.closeJarFileIfPossible(aJarFile);
        String stringView = "";
        stringView = resultingSourceString.toString().contains("xi:include") ? ViewJarfileReader.replaceIncludeStatements(jarFilePathMap, resultingSourceString) : resultingSourceString.toString();
        resultingSourceString = null;
        return new InputSource(new StringReader(stringView));
    }

    private static void listViewsInXml(URL viewlistURL, Collection<ViewLoadModuleData> viewlist) throws ViewFileReaderException {
        InputStream is = null;
        try {
            is = EmasUtilities.getInstance().getInputStreamByUrl(viewlistURL);
            InputSource source = new InputSource(is);
            ViewlistXmlModel viewListModel = new ViewlistXmlModel(source, true);
            Collection<ViewLoadModuleData> allViewsInXml = viewListModel.getAllViewLoadModules();
            viewlist.addAll(allViewsInXml);
        }
        catch (IOException e) {
            String viewsProblem = e.getClass().getName() + " Reading viewlist.xlm failed." + viewlistURL + "\n" + e.getMessage();
            NexLog.logger().info(viewsProblem);
            throw new ViewFileReaderException((Throwable)e, viewsProblem);
        }
        catch (Exception e) {
            String viewsProblem = e.getClass().getName() + " when reading the file which contains a list of available view files: " + viewlistURL + "\n    " + e.getMessage();
            NexLog.logger().info(viewsProblem);
            throw new ViewFileReaderException((Throwable)e, viewsProblem);
        }
        finally {
            EmasUtilities.closeInputStream((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void listViewsInTxt(URL viewlistURL, Collection<ViewLoadModuleData> viewlist) throws ViewFileReaderException {
        ViewFileReaderException exception = null;
        BufferedReader in = null;
        try {
            InputStream is = EmasUtilities.getInstance().getInputStreamByUrl(viewlistURL);
            in = new BufferedReader(new InputStreamReader(is));
            String aJarfileName = in.readLine();
            while (aJarfileName != null) {
                if (aJarfileName.trim().length() > 0) {
                    viewlist.add(new ViewLoadModuleData(aJarfileName, "", "", ""));
                }
                aJarfileName = in.readLine();
            }
        }
        catch (IOException e) {
            String viewsProblem = e.getClass().getName() + " Reading viewlist.txt failed." + viewlistURL;
            NexLog.logger().warning(viewsProblem + "\n" + NexLog.stackToString(e));
            exception = new ViewFileReaderException((Throwable)e, viewsProblem);
            ViewJarfileReader.closeBufferedReaderIfPossible(in);
        }
        catch (Exception e2) {
            String viewsProblem = e2.getClass().getName() + " when reading the file which contains a list of available view files. " + viewlistURL;
            NexLog.logger().warning(viewsProblem + "\n" + NexLog.stackToString(e2));
            exception = new ViewFileReaderException((Throwable)e2, viewsProblem);
            {
                catch (Throwable throwable) {
                    ViewJarfileReader.closeBufferedReaderIfPossible(in);
                    throw throwable;
                }
            }
            ViewJarfileReader.closeBufferedReaderIfPossible(in);
        }
        ViewJarfileReader.closeBufferedReaderIfPossible(in);
        if (null != exception) {
            throw exception;
        }
    }

    private static String readFromFileInsideJarAndWriteToString(String jarFileName, String viewFileName, JarFile aJarFile, JarEntry entry) throws ViewFileReaderException {
        StringBuilder fileContents = null;
        InputStream in = null;
        try {
            Charset charset;
            in = aJarFile.getInputStream(entry);
            ReadableByteChannel channel = Channels.newChannel(in);
            ByteBuffer buffer = ByteBuffer.allocate(32768);
            if (Charset.isSupported(VIEW_FILE_ENCODING)) {
                charset = Charset.forName(VIEW_FILE_ENCODING);
            } else {
                NexLog.logger().warning("Could not find char set for encoding ISO-8859-1, will try with default instead");
                charset = Charset.defaultCharset();
            }
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer charBuffer = null;
            fileContents = new StringBuilder();
            while (channel.read(buffer) != -1) {
                buffer.flip();
                charBuffer = decoder.decode(buffer);
                fileContents.append(charBuffer.toString());
                buffer.clear();
            }
            channel.close();
        }
        catch (IOException ioEx) {
            NexLog.logger().warning(ioEx.getClass().getName() + " while reading xml file inside view jar file: " + viewFileName + "\n" + NexLog.stackToString(ioEx));
            throw new ViewFileReaderException((Throwable)ioEx, "Could not read a view XML file named " + viewFileName + " inside a jar file", jarFileName);
        }
        finally {
            ViewJarfileReader.closeInputStreamIfPossible(in);
            ViewJarfileReader.closeJarFileIfPossible(aJarFile);
        }
        return fileContents.toString();
    }

    private static String replaceIncludeStatements(Map<String, String> jarFilePathMap, StringBuilder resultingSourceString) throws ViewFileReaderException {
        int begin = resultingSourceString.indexOf("xi:include");
        while (begin > -1 && -1 != (begin = resultingSourceString.indexOf("href", begin))) {
            String filenametoReplace;
            String x_viewName;
            String x_inJarFileName;
            begin = resultingSourceString.indexOf("\"", begin);
            int x_end = resultingSourceString.indexOf("\"", begin + 1);
            if (-1 == begin || -1 == x_end) break;
            if ((x_inJarFileName = jarFilePathMap.get(x_viewName = (filenametoReplace = resultingSourceString.substring(++begin, x_end)).substring(0, filenametoReplace.lastIndexOf(".xml")).replace('_', ' '))) != null) {
                String fileNameInJar = ViewJarfileReader.constructIncludeFileName(filenametoReplace, x_inJarFileName);
                resultingSourceString.replace(begin, x_end, fileNameInJar);
            }
            begin = resultingSourceString.indexOf("xi:include", x_end);
        }
        return resultingSourceString.toString();
    }

    private static String constructIncludeFileName(String filenametoReplace, String inJarFileName) {
        String addressToJarContents = "!/";
        String fileDelimiter = System.getProperties().getProperty("file.separator");
        StringBuilder newFileName = new StringBuilder();
        newFileName.append("jar:file:");
        newFileName.append(fileDelimiter);
        newFileName.append(fileDelimiter);
        newFileName.append(inJarFileName);
        newFileName.append(addressToJarContents);
        newFileName.append(filenametoReplace);
        NexLog.logger().fine("View file to include: " + newFileName.toString());
        return newFileName.toString();
    }

    /*
     * Exception decompiling
     */
    private static Map<String, String> getPreDefinedViewNames(String aFileName) throws ViewFileReaderException, IOException, FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean removeFileIfPossible(String path) {
        NexLog.logger().info("Will remove file: " + path);
        boolean deleted = false;
        try {
            File f1 = new File(path);
            deleted = f1.delete();
        }
        catch (SecurityException secEx) {
            deleted = false;
            NexLog.logger().fine("Was not able to delete " + path + " " + secEx.toString());
        }
        return deleted;
    }

    private static void closeJarFileIfPossible(JarFile fis) {
        NexLog.logger().finest("Will close Jar file.");
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                NexLog.logger().fine("Unexpected IOException during close of a Jar file. " + ioe);
            }
        }
    }

    private static void closeInputStreamIfPossible(InputStream fis) {
        NexLog.logger().finest("Will close input stream.");
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                NexLog.logger().fine("Unexpected IOException during close of a FileInputStream. " + ioe);
            }
        }
    }

    private static void closeBufferedReaderIfPossible(BufferedReader reader) {
        NexLog.logger().finest("Will close buffered reader.");
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                NexLog.logger().fine("Unexpected IOException during close of a BufferedReader. " + ioe);
            }
        }
    }

    private static void setCause(Throwable e1, Throwable e2) {
        if (null != e1 && null != e2) {
            Throwable tmp = e1;
            while (tmp.getCause() != null) {
                tmp = tmp.getCause();
            }
            tmp.initCause(e2);
        }
    }

    private static class StubbedDownloadListener
    implements DownloadListener {
        private StubbedDownloadListener() {
        }

        public void connecting(String arg0, String arg1) {
            NexLog.logger().fine("connecting");
        }

        public void downloadFailed(String arg0) {
            NexLog.logger().warning("downloadfailed");
        }

        public void downloading(String arg0, int arg1, int arg2) {
            NexLog.logger().fine("downloading");
        }

        public void finished(String arg0) {
            NexLog.logger().fine("finished(" + arg0 + ")");
        }

        public void finished(String arg0, String arg1) {
            NexLog.logger().fine("finished(" + arg0 + "," + arg1 + ")");
        }

        public void updating(String arg0, int arg1, int arg2) {
            NexLog.logger().fine("updating(" + arg0 + "," + arg1 + "," + arg2 + ")");
        }
    }
}

