/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.security.StructCipherImpl;
import se.ericsson.cello.security.TlsMo;
import se.ericsson.cello.security.ipom_tls_mi;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public abstract class TlsMoGen
extends CelloMao
implements TlsMo {
    protected String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"cipherFilter", "enabledCipher", "supportedCipher"};
    protected String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"TlsId", "userLabel", "cipherFilter"};
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipom_tls_mi());
    protected MaoFroIndicationHandler indHandler;
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 17100;

    protected TlsMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, InitialMaoContext initialMaoContext, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "Tls", string, coordinator, initialMaoContext);
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("Tls");
        setRequestContextImpl.assertAllowedAttributes(this.NON_READONLY_MOM_ATTRIBUTES, "Tls");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "Tls", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        this.data.setRevision(17100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"Tls");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"cipherFilter", (AttrList)attrList, (Class)String.class, (String)"Tls");
        if (string3 == null) {
            string3 = "";
        }
        this.validateCipherFilter(string3, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("cipherFilter", string3));
        this.onCreate((SetRequestContext)setRequestContextImpl);
        FroData froData = setRequestContextImpl.sendCreateRequest(this.froProxy);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
    }

    public TlsMoGen(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(17100);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(null));
    }

    protected TlsMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "Tls", string, null);
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), "Tls", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, 1));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, ""));
        this.data.setRevision(17100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, 1);
    }

    public TlsMoGen(MoData moData, InitialMaoContext initialMaoContext, boolean bl, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(17100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, 1);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        return object;
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
    }

    protected void updateParamChangedInd(Map map, String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (this.getNamingAttributeValue().equals("1")) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.deleteMo(coordinator);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.onDelete(coordinator);
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setCipherFilter(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("cipherFilter", string, coordinator);
    }

    public String getCipherFilter(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("cipherFilter", coordinator);
    }

    public Struct[] getEnabledCipher(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("enabledCipher", coordinator);
    }

    public Struct[] getSupportedCipher(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("supportedCipher", coordinator);
    }

    public String getType() {
        return "Tls";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), this.ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            StringParameter stringParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
            } else if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("cipherFilter")) {
                stringParameter = (StringParameter)getRequestContextImpl.getParameter("cipherFilter");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("Tls", "Missing parameter from FRO: cipherFilter", "getAttributes", -1);
                }
                objectArray[i] = stringParameter.getValue();
            } else if (stringArray[i].equalsIgnoreCase("enabledCipher")) {
                stringParameter = (ArrayParameter)getRequestContextImpl.getParameter("enabledCipher");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("Tls", "Missing parameter from FRO: enabledCipher", "getAttributes", -1);
                }
                objectArray[i] = StructCipherImpl.toStructArray((ArrayParameter)stringParameter);
            } else if (stringArray[i].equalsIgnoreCase("supportedCipher")) {
                stringParameter = (ArrayParameter)getRequestContextImpl.getParameter("supportedCipher");
                if (stringParameter == null) {
                    throw new FroRequestFailedException("Tls", "Missing parameter from FRO: supportedCipher", "getAttributes", -1);
                }
                objectArray[i] = StructCipherImpl.toStructArray((ArrayParameter)stringParameter);
            } else {
                objectArray[i] = super.getAttribute(stringArray[i], coordinator);
            }
            objectArray[i] = this.onGetAttributes((GetRequestContext)getRequestContextImpl, stringArray[i], objectArray[i]);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("Tls");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "Tls");
            }
            if (string.equalsIgnoreCase("cipherFilter")) {
                if (object instanceof String) {
                    string2 = (String)object;
                    this.validateCipherFilter(string2, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("cipherFilter", string2));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("cipherFilter", "Tls");
            }
            throw new NoSuchAttributeException(string, "Tls");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                StringParameter stringParameter;
                string = (String)iterator.next();
                if (string.equals("cipherFilter")) {
                    stringParameter = (StringParameter)map.get("cipherFilter");
                    setRequestContextImpl.addAvcNotification("cipherFilter", (Object)stringParameter.getValue());
                } else if (string.equals("enabledCipher")) {
                    stringParameter = (ArrayParameter)map.get("enabledCipher");
                    setRequestContextImpl.addAvcNotification("enabledCipher", (Object)StructCipherImpl.toStructArray((ArrayParameter)stringParameter));
                } else if (string.equals("supportedCipher")) {
                    stringParameter = (ArrayParameter)map.get("supportedCipher");
                    setRequestContextImpl.addAvcNotification("supportedCipher", (Object)StructCipherImpl.toStructArray((ArrayParameter)stringParameter));
                } else {
                    MessageLog.traceError(this.getClass(), (String)("Unknown attribute in parameterChanged(): " + string));
                }
                this.updateParamChangedInd(map, string, (SetRequestContext)setRequestContextImpl);
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)("Attribute tag not found. " + moAccessException.toString()));
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"Tls");
    }

    protected void validateCipherFilter(String string, SetRequestContext setRequestContext) throws MoAccessException {
    }
}

