/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.oti.util.ASN1Encoder;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

public final class PrivateKeyDH
implements DHPrivateKey {
    final CL3 CL3Handle;

    PrivateKeyDH(CL3 handle) {
        this.CL3Handle = handle;
    }

    public BigInteger getX() {
        return new BigInteger(1, CL3.dhGetPrivateKey((CL3)this.CL3Handle));
    }

    public DHParameterSpec getParams() {
        DHParameterSpec params = new DHParameterSpec(new BigInteger(CL3.dhGetModulus((CL3)this.CL3Handle)), new BigInteger(CL3.dhGetBaseGenerator((CL3)this.CL3Handle)));
        return params;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] getEncoded() {
        byte[] encoding = ASN1Encoder.getEncoding((Object)this.toASN1Node());
        return encoding;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    private Object[] toASN1Node() {
        Object[] dhParameters = new Object[]{new BigInteger(CL3.dhGetModulus((CL3)this.CL3Handle)), new BigInteger(CL3.dhGetBaseGenerator((CL3)this.CL3Handle)), BigInteger.ZERO};
        Object[] algorithm = new Object[]{new int[]{1, 2, 840, 113549, 1, 3, 1}, dhParameters};
        Object[] privateKeyInfo = new Object[]{BigInteger.ZERO, algorithm, CL3.dhGetPrivateKey((CL3)this.CL3Handle)};
        return privateKeyInfo;
    }
}

