/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.oti.security.provider.CertificateVerifierSecurity;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.X509TrustManager;

public final class J9X509TrustManager
implements X509TrustManager {
    private final KeyStore keyStore;

    public J9X509TrustManager(KeyStore ks) {
        this.keyStore = ks;
    }

    public void checkClientTrusted(X509Certificate[] certificates, String authenticationType) throws CertificateException {
        this.checkTrusted(certificates, authenticationType);
    }

    public void checkServerTrusted(X509Certificate[] certificates, String authenticationType) throws CertificateException {
        this.checkTrusted(certificates, authenticationType);
    }

    private void checkTrusted(X509Certificate[] certificates, String authenticationType) throws CertificateException {
        if (certificates == null || certificates.length == 0 || authenticationType == null || authenticationType.length() == 0) {
            throw new IllegalArgumentException();
        }
        CertificateVerifierSecurity.verifyCertificateChain((KeyStore)this.keyStore, (X509Certificate[])certificates, (Date)new Date());
    }

    public X509Certificate[] getAcceptedIssuers() {
        Vector<Certificate> result = null;
        try {
            result = new Vector<Certificate>(this.keyStore.size());
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (this.keyStore.isCertificateEntry(alias)) {
                    result.add(this.keyStore.getCertificate(alias));
                    continue;
                }
                Certificate[] certs = this.keyStore.getCertificateChain(alias);
                if (certs == null || certs.length <= 0) continue;
                result.add(certs[certs.length - 1]);
            }
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        return result.toArray(new X509Certificate[result.size()]);
    }
}

