/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;

public abstract class Certificate {
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Certificate c = null;
        try {
            c = (Certificate)o;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        try {
            return Arrays.equals(this.getEncoded(), c.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public int hashCode() {
        byte[] bytes;
        try {
            bytes = this.getEncoded();
        }
        catch (CertificateException certificateException) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < bytes.length) {
            result += bytes[i] * i;
            ++i;
        }
        return result;
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();
}

