/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.ByteArray;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLSessionImpl;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.Platform;

abstract class AbstractSessionContext
implements SSLSessionContext {
    private static final int DEFAULT_SESSION_TIMEOUT_SECONDS = 28800;
    volatile int maximumSize;
    volatile int timeout = 28800;
    final long sslCtxNativePointer = NativeCrypto.SSL_CTX_new();
    static final int OPEN_SSL = 1;
    static final int OPEN_SSL_WITH_OCSP = 2;
    static final int OPEN_SSL_WITH_TLS_SCT = 3;
    private final Map sessions = new LinkedHashMap(){
        private static final long serialVersionUID = -7489291500279637668L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            boolean remove;
            boolean bl = remove = AbstractSessionContext.this.maximumSize > 0 && this.size() > AbstractSessionContext.this.maximumSize;
            if (remove) {
                this.remove(eldest.getKey());
                AbstractSessionContext.this.sessionRemoved((SSLSession)eldest.getValue());
            }
            return false;
        }
    };

    AbstractSessionContext(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator sessionIterator() {
        Map map = this.sessions;
        synchronized (map) {
            SSLSession[] array = this.sessions.values().toArray(new SSLSession[this.sessions.size()]);
            return Arrays.asList(array).iterator();
        }
    }

    public final Enumeration getIds() {
        final Iterator i = this.sessionIterator();
        return new Enumeration(){
            private SSLSession next;

            /*
             * Unable to fully structure code
             */
            public boolean hasMoreElements() {
                if (this.next == null) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    session = (SSLSession)i.next();
                    if (!Platform.SSLSession_isValid(session)) continue;
                    this.next = session;
                    return true;
lbl7:
                    // 2 sources

                    ** while (i.hasNext())
                }
lbl8:
                // 1 sources

                this.next = null;
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    byte[] id = this.next.getId();
                    this.next = null;
                    return id;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public final int getSessionCacheSize() {
        return this.maximumSize;
    }

    public final int getSessionTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trimToSize() {
        Map map = this.sessions;
        synchronized (map) {
            int size = this.sessions.size();
            if (size > this.maximumSize) {
                int removals = size - this.maximumSize;
                Iterator i = this.sessions.values().iterator();
                do {
                    SSLSession session = (SSLSession)i.next();
                    i.remove();
                    this.sessionRemoved(session);
                } while (--removals > 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds < 0");
        }
        this.timeout = seconds;
        Map map = this.sessions;
        synchronized (map) {
            Iterator i = this.sessions.values().iterator();
            while (i.hasNext()) {
                SSLSession session = (SSLSession)i.next();
                if (Platform.SSLSession_isValid(session)) continue;
                i.remove();
                this.sessionRemoved(session);
            }
        }
    }

    protected abstract void sessionRemoved(SSLSession var1);

    public void setSessionCacheSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        int oldMaximum = this.maximumSize;
        this.maximumSize = size;
        if (size < oldMaximum) {
            this.trimToSize();
        }
    }

    public byte[] toBytes(SSLSession session) {
        if (!(session instanceof OpenSSLSessionImpl)) {
            return null;
        }
        OpenSSLSessionImpl sslSession = (OpenSSLSessionImpl)session;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream daos = new DataOutputStream(baos);
            daos.writeInt(3);
            byte[] data = sslSession.getEncoded();
            daos.writeInt(data.length);
            daos.write(data);
            Certificate[] certs = session.getPeerCertificates();
            daos.writeInt(certs.length);
            int i = 0;
            while (i < certs.length) {
                Certificate cert = certs[i];
                data = cert.getEncoded();
                daos.writeInt(data.length);
                daos.write(data);
                ++i;
            }
            List ocspResponses = sslSession.getStatusResponses();
            daos.writeInt(ocspResponses.size());
            Iterator iter = ocspResponses.iterator();
            while (iter.hasNext()) {
                byte[] ocspResponse = (byte[])iter.next();
                daos.writeInt(ocspResponse.length);
                daos.write(ocspResponse);
            }
            byte[] tlsSctData = sslSession.getTlsSctData();
            if (tlsSctData != null) {
                daos.writeInt(tlsSctData.length);
                daos.write(tlsSctData);
            } else {
                daos.writeInt(0);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            System.err.println("Failed to convert saved SSL Session: " + e.getMessage());
            return null;
        }
        catch (CertificateEncodingException e) {
            AbstractSessionContext.log(e);
            return null;
        }
    }

    OpenSSLSessionImpl toSession(byte[] data, String host, int port) {
        byte[] tlsSctData;
        byte[] ocspData;
        X509Certificate[] certs;
        byte[] sessionData;
        block12: {
            int tlsSctDataLength;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dais = new DataInputStream(bais);
            int type = dais.readInt();
            if (type != 1 && type != 2 && type != 3) {
                throw new IOException("Unexpected type ID: " + type);
            }
            int length = dais.readInt();
            sessionData = new byte[length];
            dais.readFully(sessionData);
            int count = dais.readInt();
            certs = new X509Certificate[count];
            int i = 0;
            while (i < count) {
                length = dais.readInt();
                byte[] certData = new byte[length];
                dais.readFully(certData);
                try {
                    certs[i] = OpenSSLX509Certificate.fromX509Der(certData);
                }
                catch (Exception e) {
                    throw new IOException("Can not read certificate " + i + "/" + count);
                }
                ++i;
            }
            ocspData = null;
            if (type >= 2) {
                int countOcspResponses = dais.readInt();
                dais.skipBytes(countOcspResponses);
                if (countOcspResponses >= 1) {
                    int ocspLength = dais.readInt();
                    ocspData = new byte[ocspLength];
                    dais.readFully(ocspData);
                    int i2 = 1;
                    while (i2 < countOcspResponses) {
                        ocspLength = dais.readInt();
                        dais.skipBytes(ocspLength);
                        ++i2;
                    }
                }
            }
            tlsSctData = null;
            if (type == 3 && (tlsSctDataLength = dais.readInt()) > 0) {
                tlsSctData = new byte[tlsSctDataLength];
                dais.readFully(tlsSctData);
            }
            if (dais.available() == 0) break block12;
            AbstractSessionContext.log((Throwable)((Object)new AssertionError((Object)"Read entire session, but data still remains; rejecting")));
            return null;
        }
        try {
            return new OpenSSLSessionImpl(sessionData, host, port, certs, ocspData, tlsSctData, this);
        }
        catch (IOException e) {
            AbstractSessionContext.log(e);
            return null;
        }
        catch (Exception e) {
            AbstractSessionContext.log(e);
            return null;
        }
    }

    protected SSLSession wrapSSLSessionIfNeeded(SSLSession session) {
        if (session instanceof AbstractOpenSSLSession) {
            return Platform.wrapSSLSession((AbstractOpenSSLSession)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSession getSession(byte[] sessionId) {
        SSLSession session;
        if (sessionId == null) {
            throw new NullPointerException("sessionId == null");
        }
        ByteArray key = new ByteArray(sessionId);
        Map map = this.sessions;
        synchronized (map) {
            session = (SSLSession)this.sessions.get(key);
        }
        if (session != null && Platform.SSLSession_isValid(session)) {
            return this.wrapSSLSessionIfNeeded(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putSession(SSLSession session) {
        byte[] id = session.getId();
        if (id.length == 0) {
            return;
        }
        ByteArray key = new ByteArray(id);
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.put(key, session);
        }
    }

    static void log(Throwable t) {
        System.out.println("Error inflating SSL session: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getName()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            NativeCrypto.SSL_CTX_free(this.sslCtxNativePointer);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }
}

