/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.Platform;
import org.conscrypt.SSLClientSessionCache;

public class ClientSessionContext
extends AbstractSessionContext {
    private final Map sessionsByHostAndPort = new HashMap();
    private SSLClientSessionCache persistentCache;

    public ClientSessionContext() {
        super(10);
    }

    public int size() {
        return this.sessionsByHostAndPort.size();
    }

    public void setPersistentCache(SSLClientSessionCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionRemoved(SSLSession session) {
        String host = session.getPeerHost();
        int port = Platform.SSLSession_getPeerPort(session);
        if (host == null) {
            return;
        }
        HostAndPort hostAndPortKey = new HostAndPort(host, port);
        Map map = this.sessionsByHostAndPort;
        synchronized (map) {
            this.sessionsByHostAndPort.remove(hostAndPortKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSession getSession(String host, int port) {
        byte[] data;
        SSLSession session;
        if (host == null) {
            return null;
        }
        HostAndPort hostAndPortKey = new HostAndPort(host, port);
        Map map = this.sessionsByHostAndPort;
        synchronized (map) {
            session = (SSLSession)this.sessionsByHostAndPort.get(hostAndPortKey);
        }
        if (session != null && Platform.SSLSession_isValid(session)) {
            return this.wrapSSLSessionIfNeeded(session);
        }
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(host, port)) != null && (session = this.toSession(data, host, port)) != null && Platform.SSLSession_isValid(session)) {
            super.putSession(session);
            Map map2 = this.sessionsByHostAndPort;
            synchronized (map2) {
                this.sessionsByHostAndPort.put(hostAndPortKey, session);
            }
            return this.wrapSSLSessionIfNeeded(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSession(SSLSession session) {
        byte[] data;
        super.putSession(session);
        String host = session.getPeerHost();
        int port = Platform.SSLSession_getPeerPort(session);
        if (host == null) {
            return;
        }
        HostAndPort hostAndPortKey = new HostAndPort(host, port);
        Map map = this.sessionsByHostAndPort;
        synchronized (map) {
            this.sessionsByHostAndPort.put(hostAndPortKey, session);
        }
        if (this.persistentCache != null && (data = this.toBytes(session)) != null) {
            this.persistentCache.putSessionData(session, data);
        }
    }

    static class HostAndPort {
        final String host;
        final int port;

        HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode() * 31 + this.port;
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostAndPort)) {
                return false;
            }
            HostAndPort lhs = (HostAndPort)o;
            return this.host.equals(lhs.host) && this.port == lhs.port;
        }
    }
}

