/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import org.conscrypt.NativeCrypto;

public abstract class NativeRef {
    final long context;

    public NativeRef(long ctx) {
        if (ctx == 0L) {
            throw new NullPointerException("ctx == 0");
        }
        this.context = ctx;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NativeRef)) {
            return false;
        }
        return ((NativeRef)o).context == this.context;
    }

    public int hashCode() {
        return (int)this.context;
    }

    public static class EC_GROUP
    extends NativeRef {
        public EC_GROUP(long ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EC_GROUP_clear_free(this.context);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            super.finalize();
        }
    }

    public static class EC_POINT
    extends NativeRef {
        public EC_POINT(long ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EC_POINT_clear_free(this.context);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            super.finalize();
        }
    }

    public static class EVP_CIPHER_CTX
    extends NativeRef {
        public EVP_CIPHER_CTX(long ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_CIPHER_CTX_free(this.context);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            super.finalize();
        }
    }

    public static class EVP_MD_CTX
    extends NativeRef {
        public EVP_MD_CTX(long ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_MD_CTX_destroy(this.context);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            super.finalize();
        }
    }

    public static class EVP_PKEY
    extends NativeRef {
        public EVP_PKEY(long ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_PKEY_free(this.context);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            super.finalize();
        }
    }

    public static class EVP_PKEY_CTX
    extends NativeRef {
        public EVP_PKEY_CTX(long ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                NativeCrypto.EVP_PKEY_CTX_free(this.context);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            super.finalize();
        }
    }

    public static class HMAC_CTX
    extends NativeRef {
        public HMAC_CTX(long ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                NativeCrypto.HMAC_CTX_free(this.context);
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            super.finalize();
        }
    }
}

