/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayInputStream;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLBIOInputStream;

public final class OpenSSLBIOSource {
    private OpenSSLBIOInputStream source;

    public static OpenSSLBIOSource wrap(byte[] buffer) {
        return new OpenSSLBIOSource(new OpenSSLBIOInputStream(new ByteArrayInputStream(buffer), false));
    }

    public OpenSSLBIOSource(OpenSSLBIOInputStream source) {
        this.source = source;
    }

    public long getContext() {
        return this.source.getBioContext();
    }

    public synchronized void release() {
        if (this.source != null) {
            NativeCrypto.BIO_free_all(this.source.getBioContext());
            this.source = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }
}

