/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.math.BigInteger;
import java.security.PrivateKey;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLKeyHolder;
import org.conscrypt.Platform;

public final class OpenSSLECPrivateKey
implements PrivateKey,
OpenSSLKeyHolder {
    private static final long serialVersionUID = -4036633595001083922L;
    private static final String ALGORITHM = "EC";
    protected transient OpenSSLKey key;

    public OpenSSLECPrivateKey(OpenSSLKey key) {
        this.key = key;
    }

    public String getAlgorithm() {
        return ALGORITHM;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        return NativeCrypto.i2d_PKCS8_PRIV_KEY_INFO(this.key.getNativeRef());
    }

    public BigInteger getS() {
        return this.getPrivateKey();
    }

    private BigInteger getPrivateKey() {
        return new BigInteger(NativeCrypto.EC_KEY_get_private_key(this.key.getNativeRef()));
    }

    public OpenSSLKey getOpenSSLKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        Platform.unsupported("OpenSSLECPrivateKey.equals");
        return false;
    }

    public int hashCode() {
        return Platform.Arrays_hashCode(NativeCrypto.i2d_PKCS8_PRIV_KEY_INFO(this.key.getNativeRef()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("OpenSSLECPrivateKey{");
        sb.append("params={");
        sb.append(NativeCrypto.EVP_PKEY_print_params(this.key.getNativeRef()));
        sb.append("}}");
        return sb.toString();
    }
}

