/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLBIOInputStream;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.OpenSSLX509CertificateFactory;

public class OpenSSLX509CertPath
extends CertPath {
    private static final long serialVersionUID = -3249106005255170761L;
    private static final byte[] PKCS7_MARKER = new byte[]{45, 45, 45, 45, 45, 66, 69, 71, 73, 78, 32, 80, 75, 67, 83, 55};
    private static final int PUSHBACK_SIZE = 64;
    public static final String PKI_PATH = "PkiPath";
    public static final String PKCS7 = "PKCS7";
    private static final List ALL_ENCODINGS = Collections.unmodifiableList(Arrays.asList("PkiPath", "PKCS7"));
    private static final String DEFAULT_ENCODING = "PkiPath";
    private final List mCertificates;

    static Iterator getEncodingsIterator() {
        return ALL_ENCODINGS.iterator();
    }

    protected OpenSSLX509CertPath(List certificates) {
        super("X.509");
        this.mCertificates = certificates;
    }

    public List getCertificates() {
        return Collections.unmodifiableList(this.mCertificates);
    }

    private long[] getCertRefs() throws CertificateEncodingException {
        OpenSSLX509Certificate[] certs = new OpenSSLX509Certificate[this.mCertificates.size()];
        long[] certRefs = new long[certs.length];
        int i = 0;
        int j = certs.length - 1;
        while (j >= 0) {
            X509Certificate cert = (X509Certificate)this.mCertificates.get(i);
            certs[j] = cert instanceof OpenSSLX509Certificate ? (OpenSSLX509Certificate)cert : OpenSSLX509Certificate.fromX509Der(cert.getEncoded());
            certRefs[j] = certs[j].getContext();
            ++i;
            --j;
        }
        return certRefs;
    }

    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if ("PkiPath".equals(encoding)) {
            return NativeCrypto.ASN1_seq_pack_X509(this.getCertRefs());
        }
        if (PKCS7.equals(encoding)) {
            return NativeCrypto.i2d_PKCS7(this.getCertRefs());
        }
        throw new CertificateEncodingException("Unknown encoding " + encoding);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.getEncoded("PkiPath");
    }

    public Iterator getEncodings() {
        return OpenSSLX509CertPath.getEncodingsIterator();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CertPath fromPkiPathEncoding(InputStream inStream) throws CertificateException {
        ArrayList<OpenSSLX509Certificate> certs;
        long[] certRefs;
        OpenSSLBIOInputStream bis = new OpenSSLBIOInputStream(inStream, true);
        boolean markable = inStream.markSupported();
        if (markable) {
            inStream.mark(64);
        }
        try {
            try {
                certRefs = NativeCrypto.ASN1_seq_unpack_X509_bio(bis.getBioContext());
            }
            catch (Exception e) {
                if (!markable) throw new CertificateException(e.getMessage());
                try {
                    inStream.reset();
                    throw new CertificateException(e.getMessage());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new CertificateException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            bis.release();
            throw throwable;
        }
        {
            Object var6_10 = null;
            bis.release();
            if (certRefs == null) {
                return new OpenSSLX509CertPath(Collections.EMPTY_LIST);
            }
            certs = new ArrayList<OpenSSLX509Certificate>(certRefs.length);
        }
        int i = certRefs.length - 1;
        while (i >= 0) {
            if (certRefs[i] != 0L) {
                certs.add(new OpenSSLX509Certificate(certRefs[i]));
            }
            --i;
        }
        return new OpenSSLX509CertPath(certs);
    }

    private static CertPath fromPkcs7Encoding(InputStream inStream) throws CertificateException {
        try {
            if (inStream == null || inStream.available() == 0) {
                return new OpenSSLX509CertPath(Collections.EMPTY_LIST);
            }
        }
        catch (IOException e) {
            throw new CertificateException("Problem reading input stream: " + e.getMessage());
        }
        boolean markable = inStream.markSupported();
        if (markable) {
            inStream.mark(64);
        }
        PushbackInputStream pbis = new PushbackInputStream(inStream, 64);
        try {
            byte[] buffer = new byte[PKCS7_MARKER.length];
            int len = pbis.read(buffer);
            if (len < 0) {
                throw new OpenSSLX509CertificateFactory.ParsingException("inStream is empty");
            }
            pbis.unread(buffer, 0, len);
            if (len == PKCS7_MARKER.length && Arrays.equals(PKCS7_MARKER, buffer)) {
                return new OpenSSLX509CertPath(OpenSSLX509Certificate.fromPkcs7PemInputStream(pbis));
            }
            return new OpenSSLX509CertPath(OpenSSLX509Certificate.fromPkcs7DerInputStream(pbis));
        }
        catch (Exception e) {
            if (markable) {
                try {
                    inStream.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new CertificateException(e.getMessage());
        }
    }

    public static CertPath fromEncoding(InputStream inStream, String encoding) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("inStream == null");
        }
        if ("PkiPath".equals(encoding)) {
            return OpenSSLX509CertPath.fromPkiPathEncoding(inStream);
        }
        if (PKCS7.equals(encoding)) {
            return OpenSSLX509CertPath.fromPkcs7Encoding(inStream);
        }
        throw new CertificateEncodingException("Unknown encoding");
    }

    public static CertPath fromEncoding(InputStream inStream) throws CertificateException {
        return OpenSSLX509CertPath.fromEncoding(inStream, "PkiPath");
    }
}

