/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import javax.net.ssl.SSLSession;
import org.conscrypt.AbstractSessionContext;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLSessionImpl;
import org.conscrypt.Platform;
import org.conscrypt.SSLServerSessionCache;

public class ServerSessionContext
extends AbstractSessionContext {
    public static final int DEFAULT_CACHE_SIZE = 0;
    private SSLServerSessionCache persistentCache;

    public ServerSessionContext() {
        super(0);
        NativeCrypto.SSL_CTX_set_session_id_context(this.sslCtxNativePointer, new byte[]{32});
        this.setSessionCacheSize(0);
    }

    public void setPersistentCache(SSLServerSessionCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    protected void sessionRemoved(SSLSession session) {
    }

    public SSLSession getSession(byte[] sessionId) {
        OpenSSLSessionImpl session;
        byte[] data;
        SSLSession cachedSession = super.getSession(sessionId);
        if (cachedSession != null) {
            return cachedSession;
        }
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(sessionId)) != null && (session = this.toSession(data, null, -1)) != null && session.isValid()) {
            super.putSession(session);
            return Platform.wrapSSLSession(session);
        }
        return null;
    }

    void putSession(SSLSession session) {
        byte[] data;
        super.putSession(session);
        if (this.persistentCache != null && (data = this.toBytes(session)) != null) {
            this.persistentCache.putSessionData(session, data);
        }
    }

    public final void setSessionCacheSize(int size) throws IllegalArgumentException {
        NativeCrypto.SSL_CTX_set_session_cache_size(this.sslCtxNativePointer, size == 0 ? -1 : size);
        super.setSessionCacheSize(size);
    }
}

