/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.usaal;

import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.TransportNetworkMo;
import se.ericsson.cello.mao.DynamicReserver;
import se.ericsson.cello.mao.DynamicallyReservable;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.StrictTransactionHandler;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalList;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.usaal.UniSaalProfileMo;

public class UniSaalProfileMoImpl
extends ManagedObjectBase
implements UniSaalProfileMo,
Reservable,
DynamicallyReservable {
    private TransactionalList reservedBy = new TransactionalList((TransactionHandler)new StrictTransactionHandler());
    private StringAttribute userLabel;
    private IntegerAttribute timerPoll;
    private IntegerAttribute maxCC;
    private IntegerAttribute maxPD;
    private IntegerAttribute maxStat;
    private IntegerAttribute initialCredit;
    private IntegerAttribute timerKeepAlive;
    private IntegerAttribute timerNoResponse;
    private IntegerAttribute timerIdle;
    private IntegerAttribute congestionOnSet;
    private IntegerAttribute congestionAbatement;
    private IntegerAttribute timerCC;
    private MoData data;
    private static final String IDENTITY = "identity";
    private static final int TIMER_POLL_DEFAULT = 100;
    private static final int MAX_CC_DEFAULT = 4;
    private static final int MAX_PD_DEFAULT = 25;
    private static final int MAX_STAT_DEFAULT = 67;
    private static final int INITIAL_CREDIT_DEFAULT = 30;
    private static final int TIMER_KEEP_ALIVE_DEFAULT = 500;
    private static final int TIMER_NO_RESPONSE_DEFAULT = 4000;
    private static final int TIMER_IDLE_DEFAULT = 2000;
    private static final int TIMER_CC_DEFAULT = 1000;
    private static final int CONGESTION_ON_SET_DEFAULT = 90;
    private static final int CONGESTION_ABATEMENT_DEFAULT = 30;
    private static final int MAX_NO_UNISAAL_PROFILE_PER_NODE = 300;
    private static final int TIMER_POLL_MIN = 10;
    private static final int TIMER_POLL_MAX = 100000;
    private static final int MAX_CC_MIN = 0;
    private static final int MAX_CC_MAX = 100;
    private static final int MAX_PD_MIN = 10;
    private static final int MAX_PD_MAX = 10000;
    private static final int MAX_STAT_MIN = 3;
    private static final int MAX_STAT_MAX = 1001;
    private static final int INITIAL_CREDIT_MIN = 10;
    private static final int INITIAL_CREDIT_MAX = 1000;
    private static final int TIMER_KEEP_ALIVE_MIN = 10;
    private static final int TIMER_KEEP_ALIVE_MAX = 10000;
    private static final int TIMER_NO_RESPONSE_MIN = 10;
    private static final int TIMER_NO_RESPONSE_MAX = 100000;
    private static final int TIMER_IDLE_MIN = 1000;
    private static final int TIMER_IDLE_MAX = 600000;
    private static final int TIMER_CC_MIN = 10;
    private static final int TIMER_CC_MAX = 10000;
    private static final int CONGESTION_ON_SET_MIN = 0;
    private static final int CONGESTION_ON_SET_MAX = 100;
    private static final int CONGESTION_ABATEMENT_MIN = 0;
    private static final int CONGESTION_ABATEMENT_MAX = 100;
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_33 = 3300;
    private static final int MO_DATA_REVISION_LATEST = 3300;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UniSaalProfileMoImpl.checkTransaction(coordinator);
        UniSaalProfileMoImpl.checkParent(managedObject);
        MoAttributeValidator.checkIdentity((String)"UniSaalProfile", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"UniSaalProfile", (int)128, (int)0);
        int n = 100;
        int n2 = 4;
        int n3 = 25;
        int n4 = 67;
        int n5 = 30;
        int n6 = 500;
        int n7 = 4000;
        int n8 = 2000;
        int n9 = 1000;
        int n10 = 90;
        int n11 = 30;
        String[] stringArray = new String[]{"profileData"};
        if (attrList.contains(stringArray)) {
            if (!(attrList.getValue(attrList.indexOf("profileData")) instanceof Struct)) {
                throw new WrongAttributeTypeException("profileData", "UniSaalProfile");
            }
            Struct struct = (Struct)attrList.getValue(attrList.indexOf("profileData"));
            attrList.removeElementAt(attrList.indexOf("profileData"));
            if (struct.size() > 11) {
                throw new NoSuchFieldException("Unknown field in struct size = " + struct.size());
            }
            n3 = (Integer)struct.getValue("maxPD");
            n4 = (Integer)struct.getValue("maxStat");
            n5 = (Integer)struct.getValue("initialCredit");
            n6 = (Integer)struct.getValue("timerKeepAlive");
            n7 = (Integer)struct.getValue("timerNoResponse");
            n8 = (Integer)struct.getValue("timerIdle");
            n9 = (Integer)struct.getValue("timerCC");
            n = (Integer)struct.getValue("timerPoll");
            n2 = (Integer)struct.getValue("maxCC");
            n10 = (Integer)struct.getValue("congestionOnSet");
            n11 = (Integer)struct.getValue("congestionAbatement");
            UniSaalProfileMoImpl.checkAndGetMaxPD(n3, n5);
            UniSaalProfileMoImpl.checkAndGetMaxStat(n4);
            UniSaalProfileMoImpl.checkAndGetInitialCredit(n5);
            UniSaalProfileMoImpl.checkAndGetTimerKeepAlive(n6);
            UniSaalProfileMoImpl.checkAndGetTimerNoResponse(n7);
            UniSaalProfileMoImpl.checkAndGetTimerIdle(n8);
            UniSaalProfileMoImpl.checkAndGetTimerCC(n9);
            UniSaalProfileMoImpl.checkAndGetTimerPoll(n);
            UniSaalProfileMoImpl.checkAndGetMaxCC(n2);
            UniSaalProfileMoImpl.checkAndGetCongestionOnSet(n10);
            UniSaalProfileMoImpl.checkAndGetCongestionAbatement(n11, n10);
        }
        MoAttributeValidator.checkCardinality((String)"UniSaalProfile", (int)300);
        UniSaalProfileMoImpl.checkOtherAttributes(attrList);
        return new UniSaalProfileMoImpl(managedObject, string2, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, string, coordinator);
    }

    private UniSaalProfileMoImpl(ManagedObject managedObject, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "UniSaalProfile", string2, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.timerPoll = new IntegerAttribute("timerPoll", false, n);
        this.data.registerPersistentAttr((Attribute)this.timerPoll);
        this.maxCC = new IntegerAttribute("maxCC", false, n2);
        this.data.registerPersistentAttr((Attribute)this.maxCC);
        this.maxPD = new IntegerAttribute("maxPD", false, n3);
        this.data.registerPersistentAttr((Attribute)this.maxPD);
        this.maxStat = new IntegerAttribute("maxStat", false, n4);
        this.data.registerPersistentAttr((Attribute)this.maxStat);
        this.initialCredit = new IntegerAttribute("initialCredit", false, n5);
        this.data.registerPersistentAttr((Attribute)this.initialCredit);
        this.timerKeepAlive = new IntegerAttribute("timerKeepAlive", false, n6);
        this.data.registerPersistentAttr((Attribute)this.timerKeepAlive);
        this.timerNoResponse = new IntegerAttribute("timerNoResponse", false, n7);
        this.data.registerPersistentAttr((Attribute)this.timerNoResponse);
        this.timerIdle = new IntegerAttribute("timerIdle", false, n8);
        this.data.registerPersistentAttr((Attribute)this.timerIdle);
        this.timerCC = new IntegerAttribute("timerCC", false, n9);
        this.data.registerPersistentAttr((Attribute)this.timerCC);
        this.congestionOnSet = new IntegerAttribute("congestionOnSet", false, n10);
        this.data.registerPersistentAttr((Attribute)this.congestionOnSet);
        this.congestionAbatement = new IntegerAttribute("congestionAbatement", false, n11);
        this.data.registerPersistentAttr((Attribute)this.congestionAbatement);
        this.data.setRevision(3300);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public UniSaalProfileMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3300);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("timerPoll");
        moDataRecoveryHelper.assertAttribute("maxCC");
        moDataRecoveryHelper.assertAttribute("maxPD");
        moDataRecoveryHelper.assertAttribute("maxStat");
        moDataRecoveryHelper.assertAttribute("initialCredit");
        moDataRecoveryHelper.assertAttribute("timerKeepAlive");
        moDataRecoveryHelper.assertAttribute("timerNoResponse");
        moDataRecoveryHelper.assertAttribute("timerIdle");
        moDataRecoveryHelper.assertAttribute("timerCC");
        moDataRecoveryHelper.assertAttribute("congestionOnSet");
        moDataRecoveryHelper.assertAttribute("congestionAbatement");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.timerPoll = (IntegerAttribute)moData.getAttribute("timerPoll");
        this.maxCC = (IntegerAttribute)moData.getAttribute("maxCC");
        this.maxPD = (IntegerAttribute)moData.getAttribute("maxPD");
        this.maxStat = (IntegerAttribute)moData.getAttribute("maxStat");
        this.initialCredit = (IntegerAttribute)moData.getAttribute("initialCredit");
        this.timerKeepAlive = (IntegerAttribute)moData.getAttribute("timerKeepAlive");
        this.timerNoResponse = (IntegerAttribute)moData.getAttribute("timerNoResponse");
        this.timerIdle = (IntegerAttribute)moData.getAttribute("timerIdle");
        this.timerCC = (IntegerAttribute)moData.getAttribute("timerCC");
        this.congestionOnSet = (IntegerAttribute)moData.getAttribute("congestionOnSet");
        this.congestionAbatement = (IntegerAttribute)moData.getAttribute("congestionAbatement");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedBy.size(coordinator) > 0) {
            throw new MoReservedNotDeletableException("UniSaalProfile");
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.validateReserver(managedObject);
        this.reservedBy.add((Object)managedObject, coordinator);
    }

    public void recoverReservation(ManagedObject managedObject) throws InvalidReferenceException {
        this.validateReserver(managedObject);
        this.reservedBy.add((Object)managedObject);
    }

    private void validateReserver(ManagedObject managedObject) throws InvalidReferenceException {
        if (managedObject == null || !(managedObject instanceof DynamicReserver)) {
            throw new InvalidReferenceException("UniSaalProfile", (Object)managedObject);
        }
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.reservedBy.remove((Object)managedObject, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public String getIdentity(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"UniSaalProfile", (int)128, (int)0);
        UniSaalProfileMoImpl.checkTransaction(coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public Struct getProfileData(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[11];
        Object[] objectArray = new Object[11];
        stringArray[0] = "maxPD";
        objectArray[0] = new Integer(this.maxPD.getValue(coordinator));
        stringArray[1] = "maxStat";
        objectArray[1] = new Integer(this.maxStat.getValue(coordinator));
        stringArray[2] = "initialCredit";
        objectArray[2] = new Integer(this.initialCredit.getValue(coordinator));
        stringArray[3] = "timerKeepAlive";
        objectArray[3] = new Integer(this.timerKeepAlive.getValue(coordinator));
        stringArray[4] = "timerNoResponse";
        objectArray[4] = new Integer(this.timerNoResponse.getValue(coordinator));
        stringArray[5] = "timerIdle";
        objectArray[5] = new Integer(this.timerIdle.getValue(coordinator));
        stringArray[6] = "timerCC";
        objectArray[6] = new Integer(this.timerCC.getValue(coordinator));
        stringArray[7] = "timerPoll";
        objectArray[7] = new Integer(this.timerPoll.getValue(coordinator));
        stringArray[8] = "maxCC";
        objectArray[8] = new Integer(this.maxCC.getValue(coordinator));
        stringArray[9] = "congestionOnSet";
        objectArray[9] = new Integer(this.congestionOnSet.getValue(coordinator));
        stringArray[10] = "congestionAbatement";
        objectArray[10] = new Integer(this.congestionAbatement.getValue(coordinator));
        StructImpl structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (ManagedObject[])this.reservedBy.toArray(coordinator, (Object[])new ManagedObject[0]);
    }

    public String getType() {
        return "UniSaalProfile";
    }

    private static void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
    }

    private static void checkParent(ManagedObject managedObject) throws IllegalParentException {
        if (!(managedObject instanceof TransportNetworkMo)) {
            throw new IllegalParentException("UniSaalProfile");
        }
    }

    private static void checkAndGetTimerPoll(int n) throws MoAccessException {
        if (n < 10 || n > 100000) {
            throw new ValueOutOfRangeException("timerPoll", "UniSaalProfile");
        }
    }

    private static void checkAndGetMaxCC(int n) throws MoAccessException {
        if (n < 0 || n > 100) {
            throw new ValueOutOfRangeException("maxCC", "UniSaalProfile");
        }
    }

    private static void checkAndGetMaxPD(int n, int n2) throws MoAccessException {
        if (n < 10 || n > 10000) {
            throw new ValueOutOfRangeException("maxPD", "UniSaalProfile");
        }
        if (n >= n2) {
            throw new ValueOutOfRangeException("maxPD", "UniSaalProfile");
        }
    }

    private static void checkAndGetMaxStat(int n) throws MoAccessException {
        if (n < 3 || n > 1001) {
            throw new ValueOutOfRangeException("maxStat", "UniSaalProfile");
        }
        int n2 = n % 2;
        if (n2 == 0) {
            throw new ValueOutOfRangeException("maxStat", "UniSaalProfile");
        }
    }

    private static void checkAndGetInitialCredit(int n) throws MoAccessException {
        if (n < 10 || n > 1000) {
            throw new ValueOutOfRangeException("initialCredit", "UniSaalProfile");
        }
    }

    private static void checkAndGetTimerKeepAlive(int n) throws MoAccessException {
        if (n < 10 || n > 10000) {
            throw new ValueOutOfRangeException("timerKeepAlive", "UniSaalProfile");
        }
    }

    private static void checkAndGetTimerNoResponse(int n) throws MoAccessException {
        if (n < 10 || n > 100000) {
            throw new ValueOutOfRangeException("timerNoResponse", "UniSaalProfile");
        }
    }

    private static void checkAndGetTimerIdle(int n) throws MoAccessException {
        if (n < 1000 || n > 600000) {
            throw new ValueOutOfRangeException("timerIdle", "UniSaalProfile");
        }
    }

    private static void checkAndGetCongestionOnSet(int n) throws MoAccessException {
        if (n < 0 || n > 100) {
            throw new ValueOutOfRangeException("congestionOnSet", "UniSaalProfile");
        }
    }

    private static void checkAndGetCongestionAbatement(int n, int n2) throws MoAccessException {
        if (n < 0 || n > 100) {
            throw new ValueOutOfRangeException("congestionAbatement", "UniSaalProfile");
        }
        if (n >= n2) {
            throw new ValueOutOfRangeException("congestionAbatement", "UniSaalProfile");
        }
    }

    private static void checkAndGetTimerCC(int n) throws MoAccessException {
        if (n < 10 || n > 10000) {
            throw new ValueOutOfRangeException("timerCC", "UniSaalProfile");
        }
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        int n = attrList.size();
        if (n != 0) {
            throw new NoSuchAttributeException(attrList.getName(0), "UniSaalProfile");
        }
    }
}

