/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.equipment.HwLogFullException;
import se.ericsson.cello.equipment.NoAccessToHwLogException;
import se.ericsson.cello.equipment.RepairDeliveryNoteAlreadyExistsException;
import se.ericsson.cello.equipment.RepairDeliveryNoteDoesNotExistException;
import se.ericsson.cello.equipment.fropxy.OsaPiu2GetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiu3GetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiu3RestartRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiu4GetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuCreateCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuDeleteCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuGetDiskDataRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuHwTestResultRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaPiuOperatorReadRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuOperatorWriteRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetAdmStateCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetAllowedRestartsCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetAttributesCfm;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetDiskLimitRsp;
import se.ericsson.cello.equipment.fropxy.OsaPiuSetGroupNumberCfm;
import se.ericsson.cello.equipment.fropxy.PiuFroProxy;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.managedelement.suaccess.FroRequestFailedInformationException;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.RestartRejectedException;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.PmData;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.transaction.Coordinator;

public class NonGenericPiuFroProxyAdapter
implements PiuFroProxy {
    private static NonGenericPiuFroProxyAdapter thisProxyAdapter = null;
    OsaPiuMgmntProxy proxy = null;

    public static NonGenericPiuFroProxyAdapter instance(PVSession pVSession, MaoFroIndicationHandler maoFroIndicationHandler) {
        if (thisProxyAdapter == null) {
            thisProxyAdapter = new NonGenericPiuFroProxyAdapter(pVSession, maoFroIndicationHandler);
        }
        return thisProxyAdapter;
    }

    private NonGenericPiuFroProxyAdapter(PVSession pVSession, MaoFroIndicationHandler maoFroIndicationHandler) {
        this.proxy = OsaPiuMgmntProxy.instance(maoFroIndicationHandler);
        this.proxy.subscribeService(pVSession);
    }

    public FroData create(Coordinator coordinator, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"create(Coordinator c, Collection parameters)");
        ArrayList arrayList = (ArrayList)collection;
        StructParameter structParameter = (StructParameter)arrayList.get(4);
        OsaPiuCreateCfm osaPiuCreateCfm = this.proxy.sendOsaPiuCreateReq(((SignedIntParameter)arrayList.get(0)).getValue(), coordinator.getTransactionID(), ((UnsignedIntParameter)arrayList.get(1)).getValue(), ((SignedIntParameter)arrayList.get(2)).getValue(), ((SignedIntParameter)arrayList.get(3)).getValue(), ((StringParameter)structParameter.get("productNumber")).getValue(), ((StringParameter)structParameter.get("productRevision")).getValue(), ((StringParameter)structParameter.get("productName")).getValue(), ((StringParameter)structParameter.get("productionDate")).getValue(), ((StringParameter)structParameter.get("serialNumber")).getValue(), ((SignedIntParameter)arrayList.get(5)).getValue(), ((SignedIntParameter)arrayList.get(6)).getValue());
        this.checkSignal((Signal)osaPiuCreateCfm);
        if (osaPiuCreateCfm.getResult() != 1) {
            String string = this.proxy.getResultMsg(osaPiuCreateCfm.getResult());
            throw new FroRequestFailedException("PlugInUnit", "Osa fro ", "create " + string, osaPiuCreateCfm.getResult());
        }
        return new FroData(osaPiuCreateCfm.getFroId(), null);
    }

    public void delete(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator c, int froId,Collection parameters)");
        OsaPiuDeleteCfm osaPiuDeleteCfm = this.proxy.sendOsaPiuDeleteReq(coordinator.getTransactionID(), n);
        this.checkSignal((Signal)osaPiuDeleteCfm);
        String string = this.proxy.getResultMsg(osaPiuDeleteCfm.getResult());
        if (osaPiuDeleteCfm.getResult() != 1) {
            throw new FroRequestFailedException("PlugInUnit", "osa FRO", "Delete " + string, osaPiuDeleteCfm.getResult());
        }
    }

    public Map getAttributes(Coordinator coordinator, int n) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAttributes(Coordinator c, int froId)");
        HashMap<String, Object> hashMap = null;
        OsaPiu2GetAttributesRsp osaPiu2GetAttributesRsp = this.proxy.sendOsaPiu2GetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), n);
        this.checkSignal((Signal)osaPiu2GetAttributesRsp);
        if (osaPiu2GetAttributesRsp.getResult() != 1) {
            String string = this.proxy.getResultMsg(osaPiu2GetAttributesRsp.getResult());
            throw new FroRequestFailedException("PlugInUnit", "osa FRO", "getAttributes(Coordinator c, int froId): " + string, osaPiu2GetAttributesRsp.getResult());
        }
        hashMap = new HashMap<String, Object>();
        hashMap.put("piuFroId", new UnsignedIntParameter("piuFroId", osaPiu2GetAttributesRsp.getPiuInstanceId()));
        hashMap.put("slotFroId", new UnsignedIntParameter("slotFroId", osaPiu2GetAttributesRsp.getSlotInstanceId()));
        hashMap.put("role", new SignedIntParameter("role", osaPiu2GetAttributesRsp.getRole()));
        hashMap.put("administrativeState", new SignedIntParameter("administrativeState", osaPiu2GetAttributesRsp.getAdmState()));
        hashMap.put("operationalState", new SignedIntParameter("operationalState", osaPiu2GetAttributesRsp.getOperState()));
        StructParameter structParameter = new StructParameter("productData");
        structParameter.add((Parameter)new StringParameter("productNumber", osaPiu2GetAttributesRsp.getAdmProductNumber()));
        structParameter.add((Parameter)new StringParameter("productRevision", osaPiu2GetAttributesRsp.getAdmProductRevision()));
        structParameter.add((Parameter)new StringParameter("productName", osaPiu2GetAttributesRsp.getAdmProductName()));
        structParameter.add((Parameter)new StringParameter("productionDate", osaPiu2GetAttributesRsp.getAdmProductDate()));
        structParameter.add((Parameter)new StringParameter("serialNumber", osaPiu2GetAttributesRsp.getAdmSerialNumber()));
        hashMap.put("productData", structParameter);
        hashMap.put("piuGroupNumber", new SignedIntParameter("piuGroupNumber", osaPiu2GetAttributesRsp.getPiuGroupNumber()));
        hashMap.put("availabilityStatus", new SignedIntParameter("availabilityStatus", osaPiu2GetAttributesRsp.getAvailStatus()));
        hashMap.put("allowedSeqRestarts", new SignedIntParameter("allowedSeqRestarts", osaPiu2GetAttributesRsp.getAllowedSeqRestarts()));
        hashMap.put("hwTestStatus", new SignedIntParameter("hwTestStatus", osaPiu2GetAttributesRsp.getHwTestStatus()));
        hashMap.put("minimumHdVolumeDFreespace", new SignedIntParameter("minimumHdVolumeDFreespace", osaPiu2GetAttributesRsp.getDVolFreeLim()));
        hashMap.put("greenLed", new SignedIntParameter("greenLed", osaPiu2GetAttributesRsp.getGreenLed()));
        hashMap.put("yellowLed", new SignedIntParameter("yellowLed", osaPiu2GetAttributesRsp.getYellowLed()));
        hashMap.put("redLed", new SignedIntParameter("redLed", osaPiu2GetAttributesRsp.getRedLed()));
        if (osaPiu2GetAttributesRsp instanceof OsaPiu3GetAttributesRsp) {
            hashMap.put("operationalIndicator", new SignedIntParameter("operationalIndicator", ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getOperationalIndicator()));
            hashMap.put("faultIndicator", new SignedIntParameter("faultIndicator", ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getFaultIndicator()));
            hashMap.put("maintenanceIndicator", new SignedIntParameter("maintenanceIndicator", ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getMaintenanceIndicator()));
            hashMap.put("statusIndicator", new SignedIntParameter("statusIndicator", ((OsaPiu3GetAttributesRsp)osaPiu2GetAttributesRsp).getStatusIndicator()));
        } else {
            hashMap.put("operationalIndicator", new SignedIntParameter("operationalIndicator", 0));
            hashMap.put("faultIndicator", new SignedIntParameter("faultIndicator", 0));
            hashMap.put("maintenanceIndicator", new SignedIntParameter("maintenanceIndicator", 0));
            hashMap.put("statusIndicator", new SignedIntParameter("statusIndicator", 0));
        }
        if (osaPiu2GetAttributesRsp instanceof OsaPiu4GetAttributesRsp) {
            hashMap.put("signatureValidationService", new SignedIntParameter("signatureValidationService", ((OsaPiu4GetAttributesRsp)osaPiu2GetAttributesRsp).getSignatureValidationService()));
        } else {
            hashMap.put("signatureValidationService", new SignedIntParameter("signatureValidationService", 0));
        }
        return hashMap;
    }

    public Map getAttributes(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        return this.getAttributes(coordinator, n);
    }

    public Parameter getAttribute(Coordinator coordinator, int n, String string) throws MoAccessException {
        return null;
    }

    public PmData getPmAttributes(Coordinator coordinator, int n) throws MoAccessException {
        return null;
    }

    public void setAttributes(Coordinator coordinator, int n, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAttributes(Coordinator c, int froId, Collection parameters)");
        ArrayList arrayList = (ArrayList)collection;
        if (((Parameter)arrayList.get(0)).getName().equals("administrativeState")) {
            OsaPiuSetAdmStateCfm osaPiuSetAdmStateCfm = this.proxy.sendOsaPiuSetAdmStateReq(coordinator.getTransactionID(), n, ((SignedIntParameter)arrayList.get(0)).getValue(), ((UnsignedIntParameter)arrayList.get(1)).getValue(), (int)((UnsignedIntParameter)arrayList.get(2)).getValue());
            this.checkSignal((Signal)osaPiuSetAdmStateCfm);
            if (osaPiuSetAdmStateCfm.getResult() != 1) {
                String string = this.proxy.getResultMsg(osaPiuSetAdmStateCfm.getResult());
                throw new FroRequestFailedInformationException("PlugInUnit", "osa FRO", "setAdministrativeState " + string, osaPiuSetAdmStateCfm.getResult());
            }
        } else {
            throw new NoSuchAttributeException(((Parameter)arrayList.get(0)).getName(), "PlugInUnit");
        }
    }

    public void setAttribute(Coordinator coordinator, int n, Parameter parameter) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAttribute(Coordinator c, int froId, Parameter parameters)");
        if (parameter.getName().equals("allowedSeqRestarts")) {
            OsaPiuSetAllowedRestartsCfm osaPiuSetAllowedRestartsCfm = this.proxy.sendOsaPiuSetAllowedRestartsReq(coordinator.getTransactionID(), n, ((SignedIntParameter)parameter).getValue());
            this.checkSignal((Signal)osaPiuSetAllowedRestartsCfm);
            if (osaPiuSetAllowedRestartsCfm.getResult() != 1) {
                String string = this.proxy.getResultMsg(osaPiuSetAllowedRestartsCfm.getResult());
                throw new FroRequestFailedException("PlugInUnit", "setAllowedRestarts", string, osaPiuSetAllowedRestartsCfm.getResult());
            }
        } else if (parameter.getName().equals("piuGroupNumber")) {
            OsaPiuSetGroupNumberCfm osaPiuSetGroupNumberCfm = this.proxy.sendOsaPiuSetGroupNumberReq(coordinator.getTransactionID(), n, ((SignedIntParameter)parameter).getValue());
            this.checkSignal((Signal)osaPiuSetGroupNumberCfm);
            if (osaPiuSetGroupNumberCfm.getResult() != 1) {
                String string = this.proxy.getResultMsg(osaPiuSetGroupNumberCfm.getResult());
                throw new FroRequestFailedException("PlugInUnit", "PiuFro", "setMinimumHdVolumeDFreespace " + string, osaPiuSetGroupNumberCfm.getResult());
            }
        } else if (parameter.getName().equals("minimumHdVolumeDFreespace")) {
            OsaPiuSetDiskLimitRsp osaPiuSetDiskLimitRsp = this.proxy.sendOsaPiuSetDiskLimitReq(coordinator.getTransactionID(), n, ((SignedIntParameter)parameter).getValue());
            this.checkSignal((Signal)osaPiuSetDiskLimitRsp);
            if (osaPiuSetDiskLimitRsp.getResult() != 1) {
                String string = this.proxy.getResultMsg(osaPiuSetDiskLimitRsp.getResult());
                throw new FroRequestFailedException("PlugInUnit", "PiuFro", "setMinimumHdVolumeDFreespace " + string, osaPiuSetDiskLimitRsp.getResult());
            }
        } else {
            throw new NoSuchAttributeException(parameter.getName(), "PlugInUnit");
        }
    }

    public Map actionWithCfm(Coordinator coordinator, int n, int n2, Collection collection) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionWithCfm(Coordinator context, int froId,int actionType, Collection parameters)");
        if (n2 == 62) {
            OsaPiuOperatorReadRsp osaPiuOperatorReadRsp = null;
            osaPiuOperatorReadRsp = this.proxy.sendOsaReadRepairDelivNoteReq(n);
            this.checkSignal((Signal)osaPiuOperatorReadRsp);
            if (osaPiuOperatorReadRsp.getResult() == 25) {
                throw new RepairDeliveryNoteDoesNotExistException("Repair Delivery Note Not Exists");
            }
            if (osaPiuOperatorReadRsp.getResult() == 26) {
                throw new NoAccessToHwLogException("No Access To HwLog");
            }
            if (osaPiuOperatorReadRsp.getResult() != 24) {
                throw new FroRequestFailedException("PlugInUnit", "OsaPiu FRO", "ReadRepairDelivNote", osaPiuOperatorReadRsp.getResult());
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("deliveryNote", osaPiuOperatorReadRsp.getDeliveryNote());
            return hashMap;
        }
        if (n2 == 60) {
            ArrayList arrayList = (ArrayList)collection;
            OsaPiu3RestartRsp osaPiu3RestartRsp = null;
            osaPiu3RestartRsp = this.proxy.sendOsaPiu3RestartReq(n, ((SignedIntParameter)arrayList.get(0)).getValue(), ((SignedIntParameter)arrayList.get(1)).getValue(), ((StringParameter)arrayList.get(2)).getValue());
            this.checkSignal((Signal)osaPiu3RestartRsp);
            if (osaPiu3RestartRsp.getResult() == 18) {
                throw new RestartRejectedException("Restart Not allowed");
            }
            if (osaPiu3RestartRsp.getResult() != 1) {
                throw new FroRequestFailedException("PlugInUnit", "OsaPiu FRO", "Restart", osaPiu3RestartRsp.getResult());
            }
            return null;
        }
        if (n2 == 61) {
            OsaPiuOperatorWriteRsp osaPiuOperatorWriteRsp = null;
            osaPiuOperatorWriteRsp = this.proxy.sendOsaWriteRepairDelivNoteReq(((StringParameter)((ArrayList)collection).get(0)).getValue(), n);
            this.checkSignal((Signal)osaPiuOperatorWriteRsp);
            if (osaPiuOperatorWriteRsp.getResult() == 22) {
                throw new RepairDeliveryNoteAlreadyExistsException("Repair Delivery Note Already Exists");
            }
            if (osaPiuOperatorWriteRsp.getResult() == 23) {
                throw new NoAccessToHwLogException("No Access To HwLog");
            }
            if (osaPiuOperatorWriteRsp.getResult() == 27) {
                throw new HwLogFullException(" ");
            }
            if (osaPiuOperatorWriteRsp.getResult() != 21) {
                throw new FroRequestFailedException("PlugInUnit", "OsaPiu FRO", "WriteRepairDelivNote", osaPiuOperatorWriteRsp.getResult());
            }
            return null;
        }
        throw new ActionNotAllowedException("PlugInUnit", "There is no such action" + n2 + " on PIU MO, froId " + n);
    }

    public void actionWithoutCfm(Coordinator coordinator, int n, int n2, Collection collection) throws MoAccessException {
    }

    public void subscribeService() {
    }

    public void setPiuAttributes(Coordinator coordinator, int n, int n2, String string, String string2, String string3, String string4, String string5, int n3, int n4, int n5) throws MoAccessException {
        OsaPiuSetAttributesCfm osaPiuSetAttributesCfm = this.proxy.sendOsaPiuSetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), n, n2, string, string2, string3, string4, string5, n3, n4, n5);
        this.checkSignal((Signal)osaPiuSetAttributesCfm);
        if (osaPiuSetAttributesCfm.getResult() != 1) {
            String string6 = this.proxy.getResultMsg(osaPiuSetAttributesCfm.getResult());
            throw new FroRequestFailedException("PlugInUnit", "PIU Fro", "setPiuAttributes " + string6, osaPiuSetAttributesCfm.getResult());
        }
    }

    public Map getDiskDataFroAttributes(Coordinator coordinator, int n) throws MoAccessException {
        HashMap<String, Object> hashMap = null;
        OsaPiuGetDiskDataRsp osaPiuGetDiskDataRsp = this.proxy.sendOsaPiuGetDiskDataReq(n);
        this.checkSignal((Signal)osaPiuGetDiskDataRsp);
        if (osaPiuGetDiskDataRsp.getResult() != 1) {
            throw new FroRequestFailedException("PlugInUnit", "OsaPiuMgmnt", "GetOsaPiuDiskDataReq" + this.proxy.getResultMsg(osaPiuGetDiskDataRsp.getResult()), osaPiuGetDiskDataRsp.getResult());
        }
        hashMap = new HashMap<String, Object>();
        hashMap.put("piuFroId", new UnsignedIntParameter("piuFroId", osaPiuGetDiskDataRsp.getPiuInstanceId()));
        StructParameter structParameter = new StructParameter("diskData");
        structParameter.add((Parameter)new SignedIntParameter("hdVolumeDFreespace", osaPiuGetDiskDataRsp.getFreeSpaceD()));
        structParameter.add((Parameter)new SignedIntParameter("hdVolumePFreespace", osaPiuGetDiskDataRsp.getFreeSpaceP()));
        structParameter.add((Parameter)new SignedIntParameter("hdVolumeDSize", osaPiuGetDiskDataRsp.getTotalSizeD()));
        structParameter.add((Parameter)new SignedIntParameter("hdVolumePSize", osaPiuGetDiskDataRsp.getTotalSizeP()));
        hashMap.put("diskData", structParameter);
        return hashMap;
    }

    public Map getHwTestResult(int n, Coordinator coordinator, int n2) throws MoAccessException {
        HashMap<String, StringParameter> hashMap = null;
        OsaPiuHwTestResultRsp osaPiuHwTestResultRsp = this.proxy.sendOsaPiuHwTestResultReq(n, n2);
        this.checkSignal((Signal)osaPiuHwTestResultRsp);
        if (osaPiuHwTestResultRsp.getResult() != 1) {
            String string = this.proxy.getResultMsg(osaPiuHwTestResultRsp.getResult());
            throw new FroRequestFailedException("PlugInUnit", "get attributes", string, osaPiuHwTestResultRsp.getResult());
        }
        hashMap = new HashMap<String, StringParameter>();
        hashMap.put("hwTestResult", new StringParameter("hwTestResult", osaPiuHwTestResultRsp.getHwTestResult()));
        return hashMap;
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal != null) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal.getSigNo()));
        }
        if (signal == null) {
            throw new FroNotAccessibleException("PlugInUnit", "Resource fRo is not accessible.");
        }
    }
}

