/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.InSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.AdministrativeProdData;
import se.ericsson.cello.equipment.AutoConfigurationAlarm;
import se.ericsson.cello.equipment.AutoCreateFanMoAccess;
import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.EquipmentMoImpl;
import se.ericsson.cello.equipment.FanMoInternal;
import se.ericsson.cello.equipment.OperationalProdData;
import se.ericsson.cello.equipment.PfmPnpProxy;
import se.ericsson.cello.equipment.PfmUnitMo;
import se.ericsson.cello.equipment.PiuMoExtendImpl;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMoImpl;
import se.ericsson.cello.equipment.SwAllocationMarker;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerAccess;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerFactoryAccess;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.osa_pfmmi;
import se.ericsson.cello.equipment.suaccess.FanMoAttributesInformation;
import se.ericsson.cello.equipment.suaccess.FanMoSU_Access;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.PfmUnitBuildIF;
import se.ericsson.cello.managedelement.suaccess.ManagedElementDataMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConvertWeekOfYearToDate;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.TraceHelper;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumAdmState;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.util.library.Lib;

public class PfmUnitMoImpl
extends CelloMao
implements FanMoInternal,
PfmUnitMo,
Reservable,
SignalObserver,
FanMoSU_Access,
HardwareProductData,
PfmUnitBuildIF {
    private Coordinator coordinator = null;
    private static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new osa_pfmmi());
    private MoData data = null;
    private FroProxy pfmUnitGenericProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    private String previousSerialNo = "";
    private String serialNo = "";
    private static final int MO_DATA_REVISION = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private static final int RETRYCOUNTER = 60;
    public static final String LOWER = "LOWER";
    public static final String UPPER = "UPPER";
    private AutoConfigurationAlarm anAutoConfigurationAlarm = new AutoConfigurationAlarm();
    private static final String RECONFIGURATION_STATE = "reconfigurationState";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    protected static void create(ManagedObject managedObject, int n, int n2, int n3, int n4, String string, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        UpgradeTrace.debug((Class)PfmUnitMoImpl.class, (int)70, (String)("create(\n\tManagedObject: " + managedObject.getLocalDistinguishedName() + "\n\tint subracknumber: " + n + "\n\tint position: " + n2 + "\n\tint connectedXB Slot Position : " + n3 + "\n\tint adminState: " + n4 + "\n\tString identity: " + string + "\n\tCoordinator c: " + Lib.toString((Coordinator)coordinator) + "\n\tFroProxy & Indicationhandler" + "\n\t)"));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Subrack");
        ManagedObject managedObject2 = PfmUnitMoImpl.findSlot(managedObject, n3, coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("subrackNumber", n));
        arrayList.add(new SignedIntParameter("connectedToScx", n3));
        arrayList.add(new SignedIntParameter("position", n2));
        arrayList.add(new SignedIntParameter("administrativeState", n4));
        new PfmUnitMoImpl(managedObject, arrayList, managedObject2, n2, string, coordinator, froProxy, maoFroIndicationHandler);
    }

    private PfmUnitMoImpl(ManagedObject managedObject, ArrayList arrayList, ManagedObject managedObject2, int n, String string, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException, MoNameAlreadyTakenException {
        super(managedObject, "PfmUnit", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("ManagedObject connectedSlotMo: " + managedObject2.getLocalDistinguishedName() + "\n\tint position: " + n + "\n\tString identity: " + string + "\n\tParameters: " + TraceHelper.froParamToString((ArrayList)arrayList) + "\n\tCoordinator c: " + Lib.toString((Coordinator)coordinator) + "\n\tFroProxy : " + froProxy.getClass() + "\n\tIndicationHandler for service: " + maoFroIndicationHandler.getServiceName() + "\n\t)"));
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        this.pfmUnitGenericProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        FroData froData = this.pfmUnitGenericProxy.create(coordinator, (Collection)arrayList);
        int n2 = froData.getFroId();
        this.registerInitialData(n2, managedObject2, n, coordinator);
        MoFactory moFactory = MoFactoryMgr.instance().lookup("Equipment");
        EquipmentMo equipmentMo = (EquipmentMo)((SingletonMoFactory)moFactory).getMo();
        equipmentMo.actionTriggerLastHwPiChange(coordinator);
        ProductRepository.instance().registerHw((HardwareProductData)this, coordinator);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n2);
        PfmPnpProxy.instance().registerForPnpNotification(coordinator, this, n2);
        this.getMaoContext().getServiceRepository().addService((Object)this, PfmUnitBuildIF.class, coordinator);
    }

    public PfmUnitMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug((Class)PfmUnitMoImpl.class, (int)70, (String)("recovery constructor(\n\t modata recovereddata :" + moData + "\n\tFroProxy & Indicationhandler" + "\n\t)"));
        this.data = moData;
        this.pfmUnitGenericProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("piuType");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute(RECONFIGURATION_STATE);
        moDataRecoveryHelper.assertAttribute("connectedToScx");
        int n = ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null);
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, n);
        PfmPnpProxy.instance().registerForPnpNotification(null, this, n);
        ProductRepository.instance().registerHw((HardwareProductData)this);
        this.getMaoContext().getServiceRepository().addService((Object)this, PfmUnitBuildIF.class, null);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (((SubrackMoImpl)this.getParent()).getSystemParameterValue(73L, 0) != 1) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator) + " not allowed, PfmUnit is automatically deleted at delete of subrack"));
            throw new UndeletableMoException((ManagedObject)this);
        }
        this.deleteMo(coordinator);
    }

    protected void deleteMo(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteMo (Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deleteChildren(coordinator);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this, this.getReservedBy(coordinator)[0]);
        }
        this.pfmUnitGenericProxy.delete(coordinator, this.getFroId(coordinator), null);
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)((ReferenceAttribute)this.data.getAttribute("piuType")).getValue(coordinator);
        if (piuTypeAccess != null) {
            piuTypeAccess.release(this, coordinator);
        }
        ProductRepository.instance().deregisterHw((HardwareProductData)this, coordinator);
        EquipmentMoImpl.instance().actionTriggerLastHwPiChange(coordinator);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        PfmPnpProxy.instance().deregisterForPnpNotifications(coordinator, this.getFroId(coordinator));
        ((Reservable)this.getConnectedToScx(coordinator)).release((ManagedObject)this, coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Object object;
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            StructParameter structParameter = (StructParameter)map.get("operationalProductData");
            if (structParameter != null) {
                object = ((StringParameter)structParameter.get("productionDate")).getValue();
                String string = ((StringParameter)structParameter.get("productName")).getValue();
                String string2 = ((StringParameter)structParameter.get("productNumber")).getValue();
                String string3 = ((StringParameter)structParameter.get("productRevision")).getValue();
                String string4 = ((StringParameter)structParameter.get("serialNumber")).getValue();
                UpgradeTrace.debug(this.getClass(), (int)70, (String)("parameterChanged (MaoFroGenericParameterChdInd parameterChdInd)\n\t operationalProductData\n\t productionDate: " + (String)object + "\n\t productName: " + string + "\n\t productNumber: " + string2 + "\n\t productRevision: " + string3 + "\n\t serialNumber: " + string4));
                PfmPnpProxy.instance().addSignalToPnpController((InSignal)maoFroGenericParameterChdInd);
            }
            if ((object = (SignedIntParameter)map.get("administrativeState")) != null) {
                this.sendNotification("administrativeState", new Integer(object.getValue()), null);
                UpgradeTrace.debug(this.getClass(), (int)70, (String)("parameterChanged (MaoFroGenericParameterChdInd parameterChdInd)\n\t Administrative State" + object.getValue()));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)("Attribute tag not in property file, e " + (Object)((Object)moAccessException)));
        }
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase("activeSwAllocation")) {
                object = null;
                ManagedObject managedObject = this.getPiuType(coordinator);
                ManagedObject[] managedObjectArray = this.getSwAllocations(coordinator);
                if (managedObjectArray.length > 0 && managedObject != null) {
                    AutoCreateFanMoAccess autoCreateFanMoAccess = (AutoCreateFanMoAccess)ServiceLocatorFacade.getRepository().getService(class$se$ericsson$cello$equipment$AutoCreateFanMoAccess == null ? PfmUnitMoImpl.class$("se.ericsson.cello.equipment.AutoCreateFanMoAccess") : class$se$ericsson$cello$equipment$AutoCreateFanMoAccess);
                    object = autoCreateFanMoAccess.findSwAllocationWithPiuType(managedObject, managedObjectArray, coordinator);
                }
                objectArray[i] = object;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("piuType")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("piuType")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("connectedToScx")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("connectedToScx")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("position")) {
                object = (SignedIntParameter)(map = this.getAttrFromRes(map, coordinator)).get("position");
                if (object.getValue() == 0) {
                    objectArray[i] = LOWER;
                    continue;
                }
                objectArray[i] = UPPER;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maintenanceIndicator")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("maintenanceIndicator");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalProductData")) {
                map = this.getAttrFromRes(map, coordinator);
                object = new OperationalProdData((StructParameter)map.get("operationalProductData"));
                objectArray[i] = ((OperationalProdData)object).toStruct();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "PfmUnit");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? PfmUnitMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "PfmUnit");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"PfmUnit", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? PfmUnitMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "PfmUnit");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"administrativeState", (int)n, (int[])EnumAdmState.VALUES_ARRAY, (String)"PfmUnit");
                arrayList.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("piuType")) {
                if (!(objectArray[i] instanceof ManagedObject)) {
                    throw new WrongAttributeTypeException("piuType", "PfmUnit");
                }
                ManagedObject managedObject = (ManagedObject)objectArray[i];
                this.setPiuType(managedObject, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "PfmUnit");
        }
        if (!arrayList.isEmpty()) {
            this.pfmUnitGenericProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public ManagedObject getActiveSwAllocation(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("activeSwAllocation", coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeState(int value, Coordinator c)", (String)("admState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public ManagedObject getConnectedToScx(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("connectedToScx", coordinator);
    }

    public String getPosition(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("position", coordinator);
    }

    public int getMaintenanceIndicator(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maintenanceIndicator", coordinator);
    }

    public Struct getOperationalProductData(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("operationalProductData", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public ManagedObject getPiuType(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("piuType", coordinator);
    }

    public void setPiuType(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuType(ManagedObject value, Coordinator c)", (String)("New piuType: " + managedObject + "\n\tcurrent piuType: " + this.getPiuType(coordinator) + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (managedObject == null || !(managedObject instanceof PiuTypeAccess)) {
            throw new ValueOutOfRangeException("piuType", "PfmUnit");
        }
        if (managedObject.equals(this.getPiuType(coordinator))) {
            return;
        }
        ManagedObject managedObject2 = this.getPiuType(coordinator);
        if (managedObject2 != null) {
            ((PiuTypeAccess)managedObject2).release(this, coordinator);
        }
        ((ReferenceAttribute)this.data.getAttribute("piuType")).setValue(managedObject);
        ((PiuTypeAccess)managedObject).reserve(this, coordinator);
        this.sendNotification("piuType", managedObject, coordinator);
        String string = ((PiuTypeAccess)managedObject).getProductName(coordinator);
        String string2 = ((PiuTypeAccess)managedObject).getProductRevision(coordinator);
        String string3 = ((PiuTypeAccess)managedObject).getProductNumber(coordinator);
        AdministrativeProdData administrativeProdData = new AdministrativeProdData(string3, string2, string);
        this.setAdminProdData(administrativeProdData, coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute("reservedBy", coordinator);
        return managedObjectArray;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
        if (managedObject instanceof SwAllocationMarker && ((ManagedElementDataMoSU_Access)(managedObject2 = ((SingletonMoFactory)MoFactoryMgr.instance().lookup("ManagedElementData")).getMo())).getAutoConfigurationAllowedForSU(coordinator)) {
            this.registerResource(coordinator);
        }
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void actionRestartFan(int n, Coordinator coordinator) throws MoAccessException {
    }

    public void clearAutoConfigurationAlarm() {
        if (AlarmManager.getReporter().getActiveAlarm(7, (ManagedObject)this) != null) {
            this.anAutoConfigurationAlarm.clearAlarm(this);
        }
    }

    public void raiseAutoConfigurationAlarm(AdditionalInfo[] additionalInfoArray) {
        this.anAutoConfigurationAlarm.raiseAlarm(additionalInfoArray, this);
    }

    public ManagedObject[] getSwAllocations(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocations(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!(managedObjectArray[i] instanceof SwAllocationMarker)) continue;
                arrayList.add(managedObjectArray[i]);
            }
        }
        return arrayList.toArray(new ManagedObject[0]);
    }

    public String getPreviousSerialNo() {
        return this.previousSerialNo;
    }

    public void startAutoConfiguration() {
        try {
            this.sendActionSendOpData();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"startAutoConfiguration() called", (String)("Failed to initiate Auto Configuration for PfmUnit: " + this), (Throwable)throwable);
        }
    }

    public void actionReconfigureProgramPrepare(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionReconfigureProgramPrepare(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.reconfigurePrograms(coordinator);
    }

    public void actionRemoveDisabledPrograms(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRemoveDisabledPrograms(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.removeDisabledPrograms(coordinator);
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getResourceId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroId(coordinator);
    }

    public int getShutDownTimer(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getShutDownTimer(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return 0;
    }

    public ManagedObject getSwAllocation(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("activeSwAllocation", coordinator);
    }

    public void setAdministrativeStateSwitch(int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSwitch( int admState,int switchAtLock, Coordinator context ) ", (String)("admState: " + n + "\n\tswitchAtLock: " + n2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.setAdministrativeState(n, coordinator);
    }

    public void setPiuTypeForSwUpgrade(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuTypeForSwUpgrade( ManagedObject value, Coordinator c )", (String)("value: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.getPiuType(coordinator);
        ((ReferenceAttribute)this.data.getAttribute("piuType")).setValue(managedObject);
        if (piuTypeAccess != null) {
            piuTypeAccess.release(this, coordinator);
        }
        if (managedObject != null) {
            ((PiuTypeAccess)managedObject).reserve(this, coordinator);
        }
    }

    public void setShutDownTimer(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setShutDownTimer(int value, Coordinator c)", (String)("value: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
    }

    public void actionRestart(int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)("actionRestart(int restartRank, int restartCause, Coordinator c)\n\t restartRank: " + n + "\n\t restartCause: " + n2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.sendActionConfigComplete();
    }

    public int getInvalidAdmStateValue() {
        return 11;
    }

    public FanMoAttributesInformation getFanAttributesInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFanAttributesInformation ( Coordinator aCoordinator )", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return new FanMoAttributesInformation(-1, (Integer)this.getAttribute("administrativeState", coordinator), -1, -1);
    }

    public void setFanAttributes(Coordinator coordinator, int n, String string, String string2, String string3, String string4, int n2, int n3, int n4) throws MoAccessException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AdministrativeProdData administrativeProdData = new AdministrativeProdData(string, string2, string3);
        arrayList.add(administrativeProdData.toParameter());
        arrayList.add(new SignedIntParameter("administrativeState", n));
        this.pfmUnitGenericProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    private void setAdminProdData(AdministrativeProdData administrativeProdData, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = administrativeProdData.toParameter();
        this.pfmUnitGenericProxy.setAttribute(coordinator, this.getFroId(coordinator), (Parameter)structParameter);
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductionDate(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue("productionDate");
        if (string.length() == 8) {
            return string;
        }
        return ConvertWeekOfYearToDate.weekOfYearToDate((String)string);
    }

    public String getSerialNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSerialNumber(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue("serialNumber");
        return string;
    }

    public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotPosition(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return 0;
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSubrackId(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SubrackMoImpl subrackMoImpl = (SubrackMoImpl)this.getParent();
        return subrackMoImpl.getSubrackPosition(coordinator);
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue("productName");
        return string;
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue("productNumber");
        return string;
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Struct struct = this.getOperationalProductData(coordinator);
        String string = (String)struct.getValue("productRevision");
        return string;
    }

    public void signalReceived(InSignal inSignal) {
        try {
            if (inSignal instanceof MaoFroGenericParameterChdInd) {
                MaoFroGenericParameterChdInd maoFroGenericParameterChdInd = (MaoFroGenericParameterChdInd)inSignal;
                Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
                StructParameter structParameter = (StructParameter)map.get("operationalProductData");
                String string = ((StringParameter)structParameter.get("productNumber")).getValue();
                String string2 = ((StringParameter)structParameter.get("productRevision")).getValue();
                String string3 = ((StringParameter)structParameter.get("serialNumber")).getValue();
                this.dispatchProductData(string, string2, string3);
                EquipmentMoImpl.instance().actionTriggerLastHwPiChange(null);
            }
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"signalReceived MaoFroGenericParameterChdInd()", (String)("Failed to initiate Auto Configuration for PfmUnit: " + this), (Throwable)throwable);
        }
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private static ManagedObject findSlot(ManagedObject managedObject, int n, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (!(managedObject2 instanceof SlotMo) || ((SlotMo)managedObject2).getSlotPosition(coordinator) != n) continue;
            return managedObject2;
        }
        throw new MoNotFoundException("No Slot MO defined for SCXB board");
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.pfmUnitGenericProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    private void registerInitialData(int n, ManagedObject managedObject, int n2, Coordinator coordinator) {
        if (this.data == null) {
            try {
                this.data = new MoData(this.getLocalDistinguishedName(), "PfmUnit", true, coordinator);
                this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, ""));
                this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("piuType", false, null));
                this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("connectedToScx", false, managedObject));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("position", false, n2));
                this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
                this.data.registerPersistentAttr((Attribute)new IntegerAttribute(RECONFIGURATION_STATE, false, 0));
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.data.setRevision(9000);
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)"Creation of PfmUnit MO failed could not store persistent data", (Throwable)exception);
            }
        }
    }

    private synchronized void registerResource(Coordinator coordinator) {
        if (this.coordinator == null || !this.coordinator.isSameTransaction(coordinator)) {
            this.coordinator = coordinator;
            try {
                this.coordinator.registerResource((Resource)new ResourceAutoConfigFan());
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"registerResource failed due to an exception:", (Throwable)inactiveTransactionException);
            }
        }
    }

    public synchronized void dispatchProductData(String string, String string2, String string3) throws Exception {
        if (this.checkProductData(string, string2)) {
            this.savePreviousSerialNumber(string3);
            AutoCreateFanMoAccess autoCreateFanMoAccess = (AutoCreateFanMoAccess)ServiceLocatorFacade.getRepository().getService(AutoCreateFanMoAccess.class);
            autoCreateFanMoAccess.create(string, string2, string3, this);
        }
    }

    private boolean checkProductData(String string, String string2) throws MoAccessException {
        if (string == null || string.equals("")) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkProductData()", (String)"Auto configuration started with empty productNumber, the data will be discarded.");
            return false;
        }
        if (string2 == null || string2.equals("")) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkProductData()", (String)"Auto configuration started with empty productRevision, the data will be discarded.");
            return false;
        }
        return true;
    }

    private void savePreviousSerialNumber(String string) {
        this.previousSerialNo = this.serialNo.equals("") ? string : this.serialNo;
        this.serialNo = string;
    }

    private void deleteChildren(Coordinator coordinator) throws MoAccessException {
        new PiuMoExtendImpl().deleteSubordinates(coordinator, this);
    }

    public void sendActionSendOpData() throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendActionOpData() ");
        this.pfmUnitGenericProxy.actionWithCfm(null, this.getFroId(null), 1, null);
    }

    public void sendActionConfigComplete() throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendActionConfigComplete() ");
        this.pfmUnitGenericProxy.actionWithCfm(null, this.getFroId(null), 2, null);
    }

    public String[] getSupportedVersions() {
        return null;
    }

    public String[] getCurrentlySupportedVersions() throws SU_ConditionalException {
        return null;
    }

    public String getType() {
        return "PfmUnit";
    }

    private class ResourceAutoConfigFan
    implements Resource,
    Runnable {
        public boolean noMaoFroParameterChdIndReceived = true;
        private static final String THREAD_NAME = "Cma_PfmFan_Restart_Thread";

        public void commit() {
            Thread thread = new Thread((Runnable)this, THREAD_NAME);
            thread.start();
            PfmUnitMoImpl.this.coordinator = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            PfmUnitMoImpl.this.coordinator = null;
        }

        public void run() {
            int n = 0;
            while (this.noMaoFroParameterChdIndReceived && n < 60) {
                try {
                    PfmUnitMoImpl.this.sendActionSendOpData();
                    this.noMaoFroParameterChdIndReceived = false;
                }
                catch (MoAccessException moAccessException) {
                    UpgradeTrace.error(this.getClass(), (String)"run()", (String)("Failed to order sendActionSendOpData of this PfmUnit: " + this), (Throwable)moAccessException);
                    ++n;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

