/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.common.fropxy.FroLocationFailedException;
import se.ericsson.cello.common.fropxy.FroShutdownException;
import se.ericsson.cello.equipment.Aal5ReservingPiu;
import se.ericsson.cello.equipment.EquipException;
import se.ericsson.cello.equipment.HwLogFullException;
import se.ericsson.cello.equipment.InterPiuLinkMo;
import se.ericsson.cello.equipment.IpRouterBuildIF;
import se.ericsson.cello.equipment.NoAccessToHwLogException;
import se.ericsson.cello.equipment.OperFaultEntry;
import se.ericsson.cello.equipment.PiuMoExtendImpl;
import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.equipment.PlugInUnitRepositoryImpl;
import se.ericsson.cello.equipment.PlugNPlayListener;
import se.ericsson.cello.equipment.RepairDeliveryNoteAlreadyExistsException;
import se.ericsson.cello.equipment.RepairDeliveryNoteDoesNotExistException;
import se.ericsson.cello.equipment.SetAdministrativeStateException;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SlotMoImpl;
import se.ericsson.cello.equipment.SlotMoImplInterface;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.equipment.SubrackMoImpl;
import se.ericsson.cello.equipment.SubrackMoImplInterface;
import se.ericsson.cello.equipment.SubrackMoInternal;
import se.ericsson.cello.equipment.SubrackProdTypeBuildIF;
import se.ericsson.cello.equipment.eqaccess.PIU_AdmStateListenerAcessInterface;
import se.ericsson.cello.equipment.eqaccess.PIU_OperStateListenerAccessInterface;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerAccess;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerFactoryAccess;
import se.ericsson.cello.equipment.fropxy.CoreNotifiable;
import se.ericsson.cello.equipment.fropxy.MaoPiuFroParameterChdInd;
import se.ericsson.cello.equipment.fropxy.NssPiuMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaPiu2OperStatePropagation;
import se.ericsson.cello.equipment.fropxy.OsaPiuAutoLockInd;
import se.ericsson.cello.equipment.fropxy.OsaPiuSwitchReadyInd;
import se.ericsson.cello.equipment.fropxy.PiuFroProxy;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroCreateRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroDeleteRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiFroSetAdmStateRsp;
import se.ericsson.cello.equipment.fropxy.SpasSaiMgmntProxyInterface;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.osa_piu_mi;
import se.ericsson.cello.equipment.osa_pluginunit;
import se.ericsson.cello.equipment.spas_equ_PlugInUnit_mi;
import se.ericsson.cello.equipment.spas_plugin_unit;
import se.ericsson.cello.equipment.suaccess.PiuMoAttributesInformation;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.PlugInUnitBuildIF;
import se.ericsson.cello.managedelement.PlugInUnitRepository;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MaoPmStrategyForReqContext;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.RestartRankEnum;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.mao.RestartRejectedException;
import se.ericsson.cello.mao.SeqRestartsEnum;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.FroProxyFactoryImpl;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class PlugInUnitMoImpl
extends CelloMao
implements PlugInUnitMoInternal,
CoreNotifiable,
PlugInUnitMoSU_Access,
PlugInUnitBuildIF {
    private Map myPmProxyFroIdMap = new HashMap();
    private static NotificationSender myNotifSender = NotificationSender.instance();
    private static PlugInUnitRepository myFroIdRepository = PlugInUnitRepositoryImpl.instance();
    private PIU_AdmStateListenerAcessInterface myPIU_AdmStateListenerInterface = null;
    private PIU_OperStateListenerAccessInterface myPIU_OperStateListenerInterface = null;
    private IntegerAttribute resourceId;
    private IntegerAttribute saiResourceId;
    private StringAttribute userLabel;
    private ReferenceAttribute piuType;
    private IntegerAttribute shutDownTimer;
    private SequenceAttribute reservedByList;
    private IntegerAttribute interruptState;
    private MoData myData;
    private PiuFroProxy piuProxy;
    private SpasSaiMgmntProxyInterface saiProxy;
    private static NssPiuMgmntProxy nssProxy = NssPiuMgmntProxy.instance();
    private FroProxy genericProxyInstance = FroProxyFactoryImpl.getProxy((Class)osa_piu_mi.class, (String)"PlugInUnit");
    private MaoFroIndicationHandler indHandler;
    private MaoFroIndicationHandler indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(spas_equ_PlugInUnit_mi.class);
    private static final int SHUTDOWN_TIMER_DEFAULT = 0;
    private static final int ALLOWED_PIU_GROUP_NUMBER_MIN = 0;
    private static final int ALLOWED_PIU_GROUP_NUMBER_MAX = 65536;
    private static final int MAX_ROUTERS = 31;
    private static final String RESERVED_BY_LIST = "reservedByList";
    private static final String SAI_RESOURCE_ID = "saiResourceId";
    private static final String RESOURCE_ID = "resourceId";
    private static final String SHUT_DOWN_TIMER = "shutDownTimer";
    private static final String SWITCH_PIU_AT_LOCK = "switchPiuAtLock";
    private static final String PIU_RESTART_CAUSE_VALUE = "PiuRestartCausevalue";
    private static final String PIU_RESTART_RANK_VALUE = "PiuRestartRankvalue";
    private static final String PIU_RESTART_REASON_VALUE = "PiuRestartReasonvalue";
    private static final String PIU_RESTART_INFO = "PiuRestartInfo";
    private static final String INTERRUPT_STATE = "interruptState";
    private static String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"role", "administrativeState", "operationalState", "productData", "piuGroupNumber", "availabilityStatus", "allowedSeqRestarts", "hwTestStatus", "minimumHdVolumeDFreespace", "greenLed", "yellowLed", "redLed", "operationalIndicator", "faultIndicator", "maintenanceIndicator", "statusIndicator", "signatureValidationService"};
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3"};
    private static final int MO_REVISION_5100 = 5100;
    private static final int MO_REVISION_8003 = 8003;
    private static final int MO_REVISION_9000 = 9000;
    private static final int MO_REVISION_LATEST = 9000;
    private static final TagNameDictionary tnd = TagNameDictionaries.create((ResourceBundle)new osa_piu_mi());
    static /* synthetic */ Class class$se$ericsson$cello$equipment$Aal5ReservingPiu;

    public PlugInUnitMoImpl(MoData moData, InitialMaoContext initialMaoContext, PiuFroProxy piuFroProxy, SpasSaiMgmntProxyInterface spasSaiMgmntProxyInterface, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException, MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.piuProxy = piuFroProxy;
        this.saiProxy = spasSaiMgmntProxyInterface;
        this.indHandler = maoFroIndicationHandler;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PlugInUnitMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.myData = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.myData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("piuType");
        moDataRecoveryHelper.assertAttribute(SHUT_DOWN_TIMER);
        moDataRecoveryHelper.assertAttribute(RESERVED_BY_LIST);
        moDataRecoveryHelper.assertAttribute(SAI_RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute(INTERRUPT_STATE);
        moDataRecoveryHelper.assertAttribute("positionRef");
        this.resourceId = (IntegerAttribute)moData.getAttribute(RESOURCE_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.piuType = (ReferenceAttribute)moData.getAttribute("piuType");
        this.shutDownTimer = (IntegerAttribute)moData.getAttribute(SHUT_DOWN_TIMER);
        this.reservedByList = (SequenceAttribute)moData.getAttribute(RESERVED_BY_LIST);
        this.saiResourceId = (IntegerAttribute)moData.getAttribute(SAI_RESOURCE_ID);
        this.interruptState = (IntegerAttribute)moData.getAttribute(INTERRUPT_STATE);
        this.indHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, this.resourceId.getValue(null));
        nssProxy.registerForNotifications(null, this, this.resourceId.getValue(null));
        if (this.saiResourceId.getValue(null) != 0) {
            spasSaiMgmntProxyInterface.registerForNotifications(null, this, this.saiResourceId.getValue(null));
            this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, this.saiResourceId.getValue(null));
        }
        myFroIdRepository.addInstance(this.resourceId.getValue(null), (ManagedObject)this);
        this.getMaoContext().getServiceRepository().addService((Object)this, PlugInUnitBuildIF.class, null);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length > 0) {
            throw new MoReservedNotDeletableException("PlugInUnit");
        }
        ManagedObject managedObject = this.getPositionRef(coordinator);
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (this.getAdministrativeState(coordinator) != 0) {
            throw new EquipException("Not possible to delete unlocked PlugInUnit");
        }
        this.deleteChildren(coordinator);
        int n = this.resourceId.getValue(coordinator);
        if (this.connected2SpasSaiFro(coordinator)) {
            int n2 = this.saiResourceId.getValue(coordinator);
            SpasSaiFroDeleteRsp spasSaiFroDeleteRsp = this.saiProxy.sendSpasSaiFroDeleteReq(coordinator.getTransactionID(), n2);
            this.checkSignal((Signal)spasSaiFroDeleteRsp);
            String string = this.saiProxy.getResultMsg(spasSaiFroDeleteRsp.getResult());
            if (spasSaiFroDeleteRsp.getResult() != 1) {
                throw new FroRequestFailedException("PlugInUnit", "sai FRO", "Delete " + string, spasSaiFroDeleteRsp.getResult());
            }
            nssProxy.deregisterForNotifications(coordinator, n);
            this.saiProxy.deregisterForNotifications(coordinator, n2);
            this.indicationHandler.deregisterForNotifications(coordinator, n2);
        }
        this.piuProxy.delete(coordinator, n, null);
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.piuType.getValue(coordinator);
        if (piuTypeAccess != null) {
            piuTypeAccess.release(this, coordinator);
        }
        this.indHandler.deregisterForNotifications(coordinator, n);
        myFroIdRepository.removeInstance(n, coordinator);
        this.getMaoContext().getServiceRepository().removeService((Object)this, PlugInUnitBuildIF.class, null);
        this.myData.delete(coordinator);
        super.delete(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        getRequestContextImpl.readAttributesFromProxy((FroProxy)this.piuProxy, this.getFroId(coordinator), ATTRIBUTES_TO_REQUEST_FROM_FRO);
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                int n;
                Attribute[] attributeArray = this.reservedByList.getValue(coordinator);
                object = new ManagedObject[attributeArray.length];
                for (n = 0; n < attributeArray.length; ++n) {
                    object[n] = ((ReferenceAttribute)attributeArray[n]).getValue(coordinator);
                }
                n = ((PiuTypeAccess)this.getPiuType(coordinator)).getRole(coordinator);
                Iterator iterator = this.getMaoContext().getServiceRepository().getServices(class$se$ericsson$cello$equipment$Aal5ReservingPiu == null ? PlugInUnitMoImpl.class$("se.ericsson.cello.equipment.Aal5ReservingPiu") : class$se$ericsson$cello$equipment$Aal5ReservingPiu);
                Aal5ReservingPiu aal5ReservingPiu = null;
                ManagedObject[] managedObjectArray = null;
                if (iterator != null && iterator.hasNext() && (n == 1 || n == 2)) {
                    aal5ReservingPiu = (Aal5ReservingPiu)iterator.next();
                    managedObjectArray = aal5ReservingPiu.getReservingAal5CepFroIds(coordinator, this.getResourceId(coordinator), n);
                }
                if (managedObjectArray != null) {
                    ManagedObject[] managedObjectArray2 = new ManagedObject[((ManagedObject[])object).length + managedObjectArray.length];
                    System.arraycopy(object, 0, managedObjectArray2, 0, ((ManagedObject[])object).length);
                    System.arraycopy(managedObjectArray, 0, managedObjectArray2, ((ManagedObject[])object).length, managedObjectArray.length);
                    objectArray[i] = managedObjectArray2;
                    continue;
                }
                objectArray[i] = object;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.myData.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("PlugInUnitId")) {
                objectArray[i] = this.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("unitType")) {
                objectArray[i] = ((PiuTypeAccess)this.getPiuType(coordinator)).getProductName(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("positionRef")) {
                objectArray[i] = ((ReferenceAttribute)this.myData.getAttribute("positionRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("piuType")) {
                objectArray[i] = this.piuType.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("administrativeState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("piuGroupNumber")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("piuGroupNumber");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("allowedSeqRestarts")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("allowedSeqRestarts");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("hwTestStatus")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("hwTestStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("productType")) {
                objectArray[i] = "HW";
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("greenLed")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("greenLed");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("yellowLed")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("yellowLed");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("redLed")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("redLed");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalIndicator")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("operationalIndicator");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("faultIndicator")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("faultIndicator");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maintenanceIndicator")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("maintenanceIndicator");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("statusIndicator")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("statusIndicator");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("signatureValidationService")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)getRequestContextImpl.getParameter("signatureValidationService");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("hwTestResult")) {
                int n = 0;
                if (coordinator != null) {
                    n = coordinator.getTransactionID();
                }
                object = this.piuProxy.getHwTestResult(n, coordinator, this.resourceId.getValue(coordinator)).get("hwTestResult");
                objectArray[i] = ((StringParameter)object).getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmProcessorLoad")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmProcessorLoad", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmProcessorCoreLoad")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmProcessorCoreLoad", INTEGER_ARRAY_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSwitchIngressDiscards")) {
                if (this.connected2SpasSaiFro(coordinator)) {
                    objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSwitchIngressDiscards", INTEGER_PM_TYPE);
                    continue;
                }
                objectArray[i] = new Integer(-2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSwitchIngressLoad")) {
                if (this.connected2SpasSaiFro(coordinator)) {
                    objectArray[i] = pmRequestContextImpl.getPmAttribute("pmSwitchIngressLoad", INTEGER_PM_TYPE);
                    continue;
                }
                objectArray[i] = new Integer(-2);
                continue;
            }
            objectArray[i] = super.getAttribute(stringArray[i], coordinator);
        }
        return objectArray;
    }

    public int getPmProcessorLoad(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmProcessorLoad", coordinator);
    }

    public int[] getPmProcessorCoreLoad(Coordinator coordinator) throws MoAccessException {
        return this.integerArray2primitiveArray((Integer[])this.getAttribute("pmProcessorCoreLoad", coordinator));
    }

    private int[] integerArray2primitiveArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        int n = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = integerArray[n];
        }
        return nArray;
    }

    public int getPmSwitchIngressDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSwitchIngressDiscards", coordinator);
    }

    public int getPmSwitchIngressLoad(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSwitchIngressLoad", coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdministrativeState(Coordinator c)", (String)("c: " + coordinator));
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeState(int admState, Coordinator c)", (String)("admState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("administrativeState", "PlugInUnit");
        }
        if (this.connected2SpasSaiFro(coordinator)) {
            this.setAdministrativeStateSai(n, coordinator);
        }
        if (n == 1) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeState(int admState, Coordinator c)", (String)"Setting administrativeState to UNLOCKED");
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), 0, coordinator);
        }
        if (n == 2) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeState(int admState, Coordinator c)", (String)"Setting administrativeState to SHUTTINGDOWN");
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), 1, coordinator);
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(2)};
            myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
        }
        if (n == 0) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeState(int admState, Coordinator c)", (String)"Setting administrativeState to LOCKED");
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), 1, coordinator);
        }
    }

    public void setAdministrativeStateSwitch(int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSwitch( int admState, int switchAtLock, Coordinator context )", (String)("admState: " + n + "\n\tswitchAtLock: " + n2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("administrativeState", "PlugInUnit");
        }
        if (n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException(SWITCH_PIU_AT_LOCK, "PlugInUnit");
        }
        if (this.connected2SpasSaiFro(coordinator)) {
            this.setAdministrativeStateSai(n, coordinator);
        }
        this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), n2, coordinator);
    }

    public void setAdministrativeStateSwitchUpgrade(int n, int n2, PIU_AdmStateListenerAcessInterface pIU_AdmStateListenerAcessInterface, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSwitchUpgrade( int admState, int aSwitchProperty, PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator context )", (String)("admState: " + n + "\n\taSwitchProperty: " + n2 + "\n\taPIU_AdmStateListenerInterface: " + pIU_AdmStateListenerAcessInterface + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string = null;
        if (n == 0) {
            string = "LOCKED";
        } else if (n == 1) {
            string = "UNLOCKED";
        } else if (n == 2) {
            string = "SHUTTINGDOWN";
        } else {
            UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("Unexpected value for administrative state received, anAdmState: " + n));
            throw new ValueOutOfRangeException("administrativeState", "PlugInUnit");
        }
        String string2 = null;
        if (n2 == 0) {
            string2 = "NORMALIZATION";
        } else if (n2 == 1) {
            string2 = "SWITCH_AT_LOCK";
        } else if (n2 == 2) {
            string2 = "NOSWITCH_AT_LOCK";
        } else {
            UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("Unexpected value for switch property received, aSwitchProperty: " + n2));
            throw new ValueOutOfRangeException(SWITCH_PIU_AT_LOCK, "PlugInUnit");
        }
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("anAdmState: " + n + " (= " + string + ")" + "\n\taSwitchProperty: " + n2 + " (= " + string2 + ")" + "\n\taPIU_AdmStateListenerInterface: " + pIU_AdmStateListenerAcessInterface + "\n\taCoordinator: " + coordinator));
        this.myPIU_AdmStateListenerInterface = pIU_AdmStateListenerAcessInterface;
        try {
            if (this.connected2SpasSaiFro(coordinator)) {
                this.setAdministrativeStateSai(n, coordinator);
            }
            this.sendSetAdministrativeState(n, this.shutDownTimer.getValue(coordinator), n2, coordinator);
        }
        catch (MoAccessException moAccessException) {
            this.myPIU_AdmStateListenerInterface = null;
            throw moAccessException;
        }
        catch (Exception exception) {
            this.myPIU_AdmStateListenerInterface = null;
            UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("Exception caught when trying to set administrative state,\n\tanAdmState: " + n + "\n\taSwitchProperty: " + n2), (Throwable)exception);
            throw new SetAdministrativeStateException("setAdministrativeStateSwitchUpgrade(int anAdmState, int aSwitchProperty PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)\n\tException caught when trying to set administrative state,\n\tanAdmState: " + n + "\n\taSwitchProperty: " + n2 + "\n\tCaught Exception: " + exception.toString());
        }
    }

    public void setAdministrativeStateUpgrade(int n, PIU_AdmStateListenerAcessInterface pIU_AdmStateListenerAcessInterface, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateUpgrade(int anAdmState, PIU_AdmStateListenerInterface aPIU_AdmStateListenerInterface, Coordinator aCoordinator)", (String)("anAdmState: " + n + "\n\taPIU_AdmStateListenerInterface: " + pIU_AdmStateListenerAcessInterface + "\n\taCoordinator: " + coordinator));
        int n2 = -1;
        n2 = n == 1 ? 0 : 1;
        this.setAdministrativeStateSwitchUpgrade(n, n2, pIU_AdmStateListenerAcessInterface, coordinator);
    }

    public void setShutDownTimer(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setShutDownTimer(int timerValue, Coordinator c)", (String)("timerValue: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (n < 0) {
            throw new ValueOutOfRangeException(SHUT_DOWN_TIMER, "PlugInUnit");
        }
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.shutDownTimer.setValue(n);
    }

    public int getShutDownTimer(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getShutDownTimer(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.shutDownTimer.getValue(coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAvailabilityStatus(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOperationalState(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getPiuGroupNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuGroupNumber(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (Integer)this.getAttribute("piuGroupNumber", coordinator);
    }

    public void setPiuGroupNumber(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuGroupNumber(int piuGN, Coordinator c) ", (String)("piuGN: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (n < 0 || n > 65536) {
            throw new ValueOutOfRangeException("piuGroupNumber", "PlugInUnit");
        }
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        SignedIntParameter signedIntParameter = new SignedIntParameter("piuGroupNumber", n);
        this.piuProxy.setAttribute(coordinator, this.resourceId.getValue(coordinator), (Parameter)signedIntParameter);
        String[] stringArray = new String[]{"piuGroupNumber"};
        Object[] objectArray = new Object[]{new Integer(n)};
        PlugInUnitMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public ManagedObject getPiuType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (ManagedObject)this.getAttribute("piuType", coordinator);
    }

    public void changePiuType(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        String string;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"changePiuType(ManagedObject piuTypeValue, Coordinator c)", (String)("piuTypeValue: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null || !(managedObject instanceof PiuTypeAccess)) {
            throw new ValueOutOfRangeException("piuType", "PlugInUnit");
        }
        ManagedObject managedObject2 = this.getPiuType(coordinator);
        String string2 = managedObject2.getNamingAttributeValue();
        if (!string2.equals(string = managedObject.getNamingAttributeValue())) {
            ManagedObject managedObject3;
            PiuTypeAccess piuTypeAccess = (PiuTypeAccess)managedObject2;
            this.piuType.setValue(managedObject);
            piuTypeAccess.release(this, coordinator);
            ((PiuTypeAccess)managedObject).reserve(this, coordinator);
            MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType("ManagedElementData");
            if (moIterator != null && moIterator.hasMoreElements() && ((ManagedElementDataMo)(managedObject3 = moIterator.nextMo())).getAutoConfigurationAllowed(coordinator)) {
                PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
                piuMoExtendImpl.updatePiuType(coordinator, managedObject, managedObject2, this);
            }
        }
    }

    public void updateMoConfiguration(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.updateMoConfiguration(coordinator, (PiuTypeAccess)this.getPiuType(coordinator), this);
    }

    public void checkPiuTypeCompliance(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.checkPiuTypeCompliance(coordinator, this);
    }

    public void deleteOldPrograms(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteOldPrograms( Coordinator c, ManagedObject value)", (String)("value: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.deleteOldProgram(coordinator, managedObject, this);
    }

    public void setPiuTypeForSwUpgrade(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuTypeForSwUpgrade(ManagedObject piuTypeSWU, Coordinator c)", (String)("piuTypeSWU: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.piuType.getValue(coordinator);
        this.piuType.setValue(managedObject);
        if (piuTypeAccess != null) {
            piuTypeAccess.release(this, coordinator);
        }
        if (managedObject != null) {
            ((PiuTypeAccess)managedObject).reserve(this, coordinator);
        }
    }

    public void subscribeForOperStateAVCs(PIU_OperStateListenerAccessInterface pIU_OperStateListenerAccessInterface) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"subscribeForOperStateEnabled( PIU_OperStateListenerInterface aPIU_OperStateListenerInterface )", (String)("\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        if (this.myPIU_OperStateListenerInterface != null) {
            UpgradeTrace.info(this.getClass(), (String)"subscribeForOperStateAVCs(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("Two instances are trying to subscribe for operState notification (ignored).\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface + "\n\tmyPIU_OperStateListenerInterface: " + this.myPIU_OperStateListenerInterface));
        } else {
            this.myPIU_OperStateListenerInterface = pIU_OperStateListenerAccessInterface;
        }
    }

    public void unSubscribeForOperStateAVCs(PIU_OperStateListenerAccessInterface pIU_OperStateListenerAccessInterface) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"unSubscribeForOperStateEnabled(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        if (this.myPIU_OperStateListenerInterface == null) {
            UpgradeTrace.info(this.getClass(), (String)"unSubscribeForOperStateEnabled(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("No instance subscribes for operState notification but one is trying to remove a subscription (ignored).\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        } else if (!pIU_OperStateListenerAccessInterface.equals(this.myPIU_OperStateListenerInterface)) {
            UpgradeTrace.info(this.getClass(), (String)"unSubscribeForOperStateEnabled(PIU_OperStateListenerInterface aPIU_OperStateListenerInterface)", (String)("An instance that does not subscribe for operState notification is trying to remove the subscription (ignored).\n\taPIU_OperStateListenerInterface: " + pIU_OperStateListenerAccessInterface));
        } else {
            this.myPIU_OperStateListenerInterface = null;
        }
    }

    public String getPlugInUnitId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPlugInUnitId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (String)this.getAttribute("PlugInUnitId", coordinator);
    }

    public String getProductType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductType(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (String)this.getAttribute("productType", coordinator);
    }

    public String getUnitType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUnitType(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (String)this.getAttribute("unitType", coordinator);
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getResourceId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.helpGetFroId(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFroId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.helpGetFroId(coordinator);
    }

    private int helpGetFroId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.resourceId.getValue(coordinator);
    }

    private int getSaiResourceId(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.saiResourceId.getValue(coordinator);
    }

    public int getResourceIdForME(Coordinator coordinator) throws MoAccessException {
        return this.getResourceId(coordinator);
    }

    public int getAsciPortNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAsciPortNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return ((SlotMoImplInterface)this.getParent()).getAsciPortNumber(coordinator);
    }

    public int getSwitchModuleNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwitchModuleNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return ((SubrackMoImpl)((SlotMoImplInterface)this.getParent()).getParent()).getSwitchModuleNumber(coordinator);
    }

    public int getRole(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRole(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        Object v = this.getFroAttributes("getRole", coordinator).get("role");
        return ((SignedIntParameter)v).getValue();
    }

    public String getType() {
        return "PlugInUnit";
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.myData.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("label: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"PlugInUnit", (int)128, (int)0);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public void setInterruptState(int n, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.interruptState.setValue(n);
    }

    public int getInterruptState(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.interruptState.getValue(coordinator);
    }

    public int getAllowedSeqRestarts(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAllowedSeqRestarts(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (Integer)this.getAttribute("allowedSeqRestarts", coordinator);
    }

    public void setAllowedSeqRestarts(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAllowedSeqRestarts(int restartsValue, Coordinator c)", (String)("restartsValue: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!SeqRestartsEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException("allowedSeqRestarts", "PlugInUnit");
        }
        SignedIntParameter signedIntParameter = new SignedIntParameter("allowedSeqRestarts", n);
        this.piuProxy.setAttribute(coordinator, this.resourceId.getValue(coordinator), (Parameter)signedIntParameter);
        String[] stringArray = new String[]{"allowedSeqRestarts"};
        Object[] objectArray = new Object[]{new Integer(n)};
        PlugInUnitMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getHwTestStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("hwTestStatus", coordinator);
    }

    public String getHwTestResult(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("hwTestResult", coordinator);
    }

    public int getOperationalIndicator(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalIndicator", coordinator);
    }

    public int getFaultIndicator(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("faultIndicator", coordinator);
    }

    public int getMaintenanceIndicator(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maintenanceIndicator", coordinator);
    }

    public int getStatusIndicator(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("statusIndicator", coordinator);
    }

    public int getGreenLed(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("greenLed", coordinator);
    }

    public int getYellowLed(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("yellowLed", coordinator);
    }

    public int getRedLed(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("redLed", coordinator);
    }

    public int getSignatureValidationService(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("signatureValidationService", coordinator);
    }

    public void actionManualRestart(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionManualRestart(int restartRank, int restartReason,String restartInfo, String restartInfoCoordinator c)", (String)("restartRank: " + n + "\n\trestartReason: " + n2 + "\n\trestartInfo: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!RestartReasonEnum.inManualRange((int)n2) && n2 != 30) {
            throw new ValueOutOfRangeException(PIU_RESTART_REASON_VALUE, "PlugInUnit");
        }
        if (!RestartRankEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException(PIU_RESTART_RANK_VALUE, "PlugInUnit");
        }
        if (string.length() > 80) {
            throw new ValueOutOfRangeException(PIU_RESTART_INFO, "PlugInUnit");
        }
        Thread thread = new Thread((Runnable)new RestartDelay(n, n2, string, this.resourceId.getValue(coordinator)), "PlugInUnitRestart");
        thread.start();
    }

    public void actionWriteRepairDelivNote(String string, String string2, String string3, String string4, String string5, String string6, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)" actionWriteRepairDelivNote(String preparedBy, String  countryCode, String  stateCode, String descriptionOfFault,String trNumber, String reference, Coordinator c)", (String)("preparedBy: " + string + "\n\tcountryCode: " + string2 + "\n\tstateCode: " + string3 + "\n\tdescriptionOfFault: " + string4 + "\n\ttrNumber: " + string5 + "\n\treference: " + string6 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.checkIfBoardIsSupported(coordinator);
        OperFaultEntry operFaultEntry = new OperFaultEntry(string, string2, string3, string4, string5, string6);
        String string7 = operFaultEntry.getRepairDeliveryNote();
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        arrayList.add(new StringParameter("deliveryNote", string7));
        try {
            this.piuProxy.actionWithCfm(coordinator, this.resourceId.getValue(null), 61, arrayList);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            int n = this.getResultCode(froRequestFailedException.getVariablesAsString());
            switch (n) {
                case 22: {
                    throw new RepairDeliveryNoteAlreadyExistsException("Repair Delivery Note Already Exists");
                }
                case 23: {
                    throw new NoAccessToHwLogException("No Access To HwLog");
                }
                case 27: {
                    throw new HwLogFullException(" ");
                }
            }
            throw froRequestFailedException;
        }
    }

    public Struct actionReadRepairDelivNote(Coordinator coordinator) throws MoAccessException {
        Map map;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)" actionReadRepairDelivNote(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.checkIfBoardIsSupported(coordinator);
        try {
            map = this.piuProxy.actionWithCfm(coordinator, this.resourceId.getValue(null), 62, null);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            int n = this.getResultCode(froRequestFailedException.getVariablesAsString());
            if (n == 25) {
                throw new RepairDeliveryNoteDoesNotExistException("Repair Delivery Note Not Exists");
            }
            if (n == 26) {
                throw new NoAccessToHwLogException("No Access To HwLog");
            }
            throw froRequestFailedException;
        }
        OperFaultEntry operFaultEntry = new OperFaultEntry(((StringParameter)map.get("deliveryNote")).getValue());
        return operFaultEntry.getStruct();
    }

    private void checkIfBoardIsSupported(Coordinator coordinator) throws MoAccessException {
        int n = ((PiuTypeAccess)this.getPiuType(coordinator)).getRole(coordinator);
        if (n != 1 && n != 2) {
            throw new ActionNotAllowedException("PlugInUnit", "This Action is supported for MP/BP role based boards only");
        }
    }

    public void systemInitiatedRestart(int n, int n2, String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionSystemInitiatedRestart(int restartRank, int restartReason,String restartInfo, String restartInfoCoordinator c)", (String)("restartRank: " + n + "\n\trestartReason: " + n2 + "\n\trestartInfo: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (!RestartRankEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException(PIU_RESTART_RANK_VALUE, "PlugInUnit");
        }
        if (!RestartReasonEnum.inSystemRange((int)n2)) {
            throw new ValueOutOfRangeException(PIU_RESTART_REASON_VALUE, "PlugInUnit");
        }
        if (string.length() > 80) {
            throw new ValueOutOfRangeException(PIU_RESTART_INFO, "PlugInUnit");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("restartRank", n));
        arrayList.add(new SignedIntParameter("restartReason", n2));
        arrayList.add(new StringParameter("restartInfo", string));
        try {
            this.piuProxy.actionWithCfm(coordinator, this.resourceId.getValue(coordinator), 60, arrayList);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            int n3 = this.getResultCode(froRequestFailedException.getVariablesAsString());
            if (n3 == 18) {
                throw new RestartRejectedException("Restart Not allowed");
            }
            throw froRequestFailedException;
        }
    }

    public void actionReconfigureProgramPrepare(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionReconfigureProgramPrepare(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)this.getMaoContext().getServiceRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.reconfigurePrograms(coordinator);
    }

    public void actionRemoveDisabledPrograms(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRemoveDisabledPrograms(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)this.getMaoContext().getServiceRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.removeDisabledPrograms(coordinator);
    }

    public void actionDisablePersistent(Coordinator coordinator) throws MoAccessException {
        this.checkifNodeisIntegrated(coordinator);
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 100, null);
    }

    private void checkifNodeisIntegrated(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("Slot");
        if (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            int n = ((SlotMoImpl)managedObject).getIntegratedHardware(coordinator);
            if (n != 1) {
                throw new OperationNotAllowedException("RS232 cannot be disabled as the node is not integrated", "PlugInUnit");
            }
            return;
        }
    }

    public ManagedObject getSwAllocation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocation(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return ((SlotMoInternal)this.getParent()).getCalculatedSwAllocationForSU(coordinator);
    }

    public ManagedObject[] getSwAllocations(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocations(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return ((SlotMoInternal)this.getParent()).getSwAllocations(coordinator);
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSubrackId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        SlotMoImplInterface slotMoImplInterface = (SlotMoImplInterface)this.getParent();
        SubrackMoImpl subrackMoImpl = (SubrackMoImpl)slotMoImplInterface.getParent();
        return subrackMoImpl.getSubrackId(coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String[] getCurrentlySupportedVersions() throws SU_ConditionalException {
        return this.getSupportedVersions();
    }

    public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotPosition(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        SlotMoImplInterface slotMoImplInterface = (SlotMoImplInterface)this.getParent();
        return slotMoImplInterface.getSlotNumber(coordinator);
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductName(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((PiuTypeAccess)this.piuType.getValue(coordinator)).getProductName(coordinator);
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((PiuTypeAccess)this.piuType.getValue(coordinator)).getProductNumber(coordinator);
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRState(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((PiuTypeAccess)this.piuType.getValue(coordinator)).getProductRevision(coordinator);
    }

    public ManagedObject getPositionRef(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPositionRef(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (ManagedObject)this.getAttribute("positionRef", coordinator);
    }

    public void setPositionRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPositionRef(ManagedObject positionRef, Coordinator c) ", (String)("positionRef: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        PlugInUnitMoImpl.validatePositionRef(managedObject);
        ManagedObject managedObject2 = this.getPositionRef(coordinator);
        this.updateReservedMos(managedObject2, managedObject, coordinator);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((ReferenceAttribute)this.myData.getAttribute("positionRef")).setValue(managedObject);
    }

    private void updateReservedMos(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
    }

    public static PlugInUnitMoImpl create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, PiuFroProxy piuFroProxy, SpasSaiMgmntProxyInterface spasSaiMgmntProxyInterface, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"create( ManagedObject parent, AttrList attributes, String namingAttributeValue, ManagedObject source, Coordinator c )", (String)("parent: " + managedObject.getType() + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tnamingAttributeValue: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"PlugInUnit", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Slot");
        MoIterator moIterator = managedObject.getChildren();
        if (moIterator != null && moIterator.hasMoreElements()) {
            throw new MoCanNotBeCreatedException("PlugInUnit");
        }
        PlugInUnitMoImpl.checkRestrictionsForMicroCPP((SlotMo)managedObject, coordinator);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"PlugInUnit");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"PlugInUnit", (int)128, (int)0);
        int n2 = PlugInUnitMoImpl.checkAndGetPiuGroupNumber(attrList);
        PiuTypeAccess piuTypeAccess = PlugInUnitMoImpl.checkAndGetPiuType(attrList);
        int n3 = PlugInUnitMoImpl.checkAndGetShutDownTimer(attrList);
        int n4 = PlugInUnitMoImpl.checkAndGetAllowedSeqRestarts(attrList, piuTypeAccess);
        ManagedObject managedObject3 = PlugInUnitMoImpl.checkAndGetPositionRef(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"PlugInUnit");
        return new PlugInUnitMoImpl(managedObject, n, string, string2, n2, piuTypeAccess, n3, n4, managedObject3, coordinator, initialMaoContext, piuFroProxy, spasSaiMgmntProxyInterface, maoFroIndicationHandler);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        if (managedObject instanceof IpRouterBuildIF && (n = ReservableImpl.noOfReservers((SequenceAttribute)this.reservedByList, (String)managedObject.getClass().getName(), (Coordinator)coordinator)) >= 31) {
            throw new OperationNotAllowedException("Only 31 IpRouter Mos are allowed to refer a PlugInUnit ", "PlugInUnit");
        }
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedByList = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PlugInUnit", (MoData)this.myData, (SequenceAttribute)this.reservedByList);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedByList = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PlugInUnit", (MoData)this.myData, (SequenceAttribute)this.reservedByList);
    }

    public PiuMoAttributesInformation getPiuAttributesInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuAttributesInformation ( Coordinator aCoordinator )", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        Map map = this.getFroAttributes("getPiuAttributesInformation", coordinator);
        SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("piuGroupNumber");
        SignedIntParameter signedIntParameter2 = (SignedIntParameter)map.get("allowedSeqRestarts");
        SignedIntParameter signedIntParameter3 = (SignedIntParameter)map.get("administrativeState");
        StructParameter structParameter = (StructParameter)map.get("productData");
        StringParameter stringParameter = (StringParameter)structParameter.get("productNumber");
        StringParameter stringParameter2 = (StringParameter)structParameter.get("productRevision");
        SignedIntParameter signedIntParameter4 = (SignedIntParameter)map.get("role");
        return new PiuMoAttributesInformation(signedIntParameter.getValue(), signedIntParameter2.getValue(), signedIntParameter3.getValue(), stringParameter.getValue(), stringParameter2.getValue(), signedIntParameter4.getValue());
    }

    public int getInvalidAdmStateValue() {
        return 12;
    }

    public void setPiuAttributes(int n, String string, String string2, String string3, String string4, String string5, int n2, int n3, int n4, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuAttributes ( int anAdministrativeState, String aProductNumber, String aProductRevision, String aProductName, String aProductionDate, String aSerialNumber, int aPIU_GroupNumber, int anAllowedSeqRestarts, int aPIU_Role )", (String)("anAdministrativeState: " + n + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taProductName: " + string3 + "\n\taproductionDate: " + string4 + "\n\taSerialNumber: " + string5 + "\n\taPIU_GroupNumber: " + n2 + "\n\tanAllowedSeqRestarts: " + n3 + "\n\taPIU_Role: " + n4 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.piuProxy.setPiuAttributes(coordinator, this.resourceId.getValue(coordinator), n, string, string2, string3, string4, string5, n2, n3, n4);
    }

    private PlugInUnitMoImpl(ManagedObject managedObject, int n, String string, String string2, int n2, PiuTypeAccess piuTypeAccess, int n3, int n4, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, PiuFroProxy piuFroProxy, SpasSaiMgmntProxyInterface spasSaiMgmntProxyInterface, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "PlugInUnit", string, coordinator, initialMaoContext);
        ManagedObject managedObject3;
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.piuProxy = piuFroProxy;
        this.saiProxy = spasSaiMgmntProxyInterface;
        this.indHandler = maoFroIndicationHandler;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PlugInUnitMoImpl(ManagedObject parent, int admState,String namingAttributeValue, String userLabel, int piuGroupNumber, PiuTypeMo piuType, int aShutDownTimer, int allowedSeqRestarts, Coordinator context)", (String)("parent: " + managedObject.getType() + "\n\tadmState" + n + "\n\tnamingAttributeValue: " + string + "\n\tuserL: " + string2 + "\n\tpiuGroupNumber: " + n2 + "\n\tpiuType: " + piuTypeAccess + "\n\taShutDownTimer: " + n3 + "\n\tallowedSeqRestarts: " + n4 + "\n\tpositionRef: " + (managedObject2 == null ? "" : managedObject2.getLocalDistinguishedName()) + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        int n5 = piuTypeAccess.getRole(coordinator);
        SlotMoImplInterface slotMoImplInterface = (SlotMoImplInterface)managedObject;
        long l = slotMoImplInterface.getResourceId(coordinator);
        AttrListImpl attrListImpl = new AttrListImpl();
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl((AttrList)attrListImpl, coordinator);
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new SignedIntParameter("clientRefType", this.hashCode()));
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new UnsignedIntParameter("slotFroId", l));
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new SignedIntParameter("administrativeState", n));
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new SignedIntParameter("role", n5));
        StructParameter structParameter = new StructParameter("productData");
        structParameter.add((Parameter)new StringParameter("productNumber", piuTypeAccess.getProductNumber(coordinator)));
        structParameter.add((Parameter)new StringParameter("productRevision", piuTypeAccess.getProductRevision(coordinator)));
        structParameter.add((Parameter)new StringParameter("productName", piuTypeAccess.getProductName(coordinator)));
        structParameter.add((Parameter)new StringParameter("productionDate", piuTypeAccess.getProductionDate(coordinator)));
        structParameter.add((Parameter)new StringParameter("serialNumber", ""));
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)structParameter);
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new SignedIntParameter("piuGroupNumber", n2));
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new SignedIntParameter("allowedSeqRestarts", n4));
        FroData froData = setRequestContextImpl.sendCreateRequest((FroProxy)this.piuProxy);
        int n6 = froData.getFroId();
        myFroIdRepository.addInstance(n6, (ManagedObject)this, coordinator);
        int n7 = 0;
        if (this.connected2SpasSaiFro(coordinator)) {
            int n8 = slotMoImplInterface.getAsciPortNumber(coordinator);
            int n9 = ((SubrackMoInternal)slotMoImplInterface.getParent()).getSwitchModuleNumber(coordinator);
            SpasSaiFroCreateRsp spasSaiFroCreateRsp = spasSaiMgmntProxyInterface.sendSpasSaiFroCreateReq(coordinator.getTransactionID(), n9, n8, n);
            this.checkSignal((Signal)spasSaiFroCreateRsp);
            if (spasSaiFroCreateRsp.getResult() != 1) {
                String string3 = spasSaiMgmntProxyInterface.getResultMsg(spasSaiFroCreateRsp.getResult());
                throw new FroRequestFailedException("PlugInUnit", "saiFRO", "Create fro-sai " + string3, spasSaiFroCreateRsp.getResult());
            }
            n7 = spasSaiFroCreateRsp.getFroId();
            spasSaiMgmntProxyInterface.registerForNotifications(coordinator, this, n7);
            this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n7);
        }
        this.initMoData(n6, n7, string2, piuTypeAccess, n3, managedObject2, coordinator);
        this.getMaoContext().getServiceRepository().addService((Object)this, PlugInUnitBuildIF.class, null);
        piuTypeAccess.reserve(this, coordinator);
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        this.indHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n6);
        nssProxy.registerForNotifications(coordinator, this, n6);
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType("ManagedElementData");
        if (moIterator != null && moIterator.hasMoreElements() && ((ManagedElementDataMo)(managedObject3 = moIterator.nextMo())).getAutoConfigurationAllowed(coordinator)) {
            this.createChildren(coordinator);
        }
    }

    private void initMoData(int n, int n2, String string, PiuTypeAccess piuTypeAccess, int n3, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"initMoData(int resourceId, int saiFroId, String userLabel, PiuTypeMo piuType, int aShutDownTimer, Coordinator c)", (String)("resourceId: " + n + "\n\tsaiFroId: " + n2 + "\n\tuserLabel: " + string + "\n\tpiuType: " + piuTypeAccess + "\n\taShutDownTimer: " + n3 + "context: " + Lib.toString((Coordinator)coordinator)));
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.resourceId = new IntegerAttribute(RESOURCE_ID, false, n);
        this.myData.registerPersistentAttr((Attribute)this.resourceId);
        this.saiResourceId = new IntegerAttribute(SAI_RESOURCE_ID, false, n2);
        this.myData.registerPersistentAttr((Attribute)this.saiResourceId);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.myData.registerPersistentAttr((Attribute)this.userLabel);
        this.piuType = new ReferenceAttribute("piuType", true, (ManagedObject)piuTypeAccess);
        this.myData.registerPersistentAttr((Attribute)this.piuType);
        this.reservedByList = new SequenceAttribute(RESERVED_BY_LIST, false);
        this.myData.registerPersistentAttr((Attribute)this.reservedByList);
        this.interruptState = new IntegerAttribute(INTERRUPT_STATE, false, 0);
        this.myData.registerPersistentAttr((Attribute)this.interruptState);
        this.myData.setRevision(9000);
        this.shutDownTimer = new IntegerAttribute(SHUT_DOWN_TIMER, true);
        this.shutDownTimer.setValue(n3);
        this.myData.registerPersistentAttr((Attribute)this.shutDownTimer);
        this.myData.registerPersistentAttr((Attribute)new ReferenceAttribute("positionRef", true, managedObject));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal != null) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal.getSigNo()));
        }
        if (signal == null) {
            throw new FroNotAccessibleException("PlugInUnit", "Resource fRo is not accessible.");
        }
    }

    private static int checkAndGetShutDownTimer(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetShutDownTimer( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf(SHUT_DOWN_TIMER);
        if (n2 == -1) {
            return 0;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException(SHUT_DOWN_TIMER, "PlugInUnit");
        }
        if ((Integer)attrList.getValue(n2) < 0) {
            throw new ValueOutOfRangeException(SHUT_DOWN_TIMER, "PlugInUnit");
        }
        n = (Integer)attrList.getValue(n2);
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetPiuGroupNumber(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetPiuGroupNumber( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("piuGroupNumber");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("piuGroupNumber", "PlugInUnit");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0 || n > 65536) {
            throw new ValueOutOfRangeException("piuGroupNumber", "PlugInUnit");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static PiuTypeAccess checkAndGetPiuType(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetPiuType( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        PiuTypeAccess piuTypeAccess = null;
        int n = attrList.indexOf("piuType");
        if (n == -1) {
            throw new AttrMissingAtCreateException("piuType", "PlugInUnit");
        }
        if (!(attrList.getValue(n) instanceof PiuTypeAccess)) {
            throw new WrongAttributeTypeException("piuType", "PlugInUnit");
        }
        piuTypeAccess = (PiuTypeAccess)attrList.getValue(n);
        attrList.removeElementAt(n);
        return piuTypeAccess;
    }

    private static int checkAndGetAllowedSeqRestarts(AttrList attrList, PiuTypeAccess piuTypeAccess) throws MoAccessException {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"checkAndGetAllowedSeqRestarts( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 0;
        int n2 = attrList.indexOf("allowedSeqRestarts");
        if (n2 == -1) {
            return piuTypeAccess.getDefAllowedSeqRestarts(null);
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("allowedSeqRestarts", "PlugInUnit");
        }
        n = (Integer)attrList.getValue(n2);
        if (!SeqRestartsEnum.inRange((int)n)) {
            throw new ValueOutOfRangeException("allowedSeqRestarts", "PlugInUnit");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static ManagedObject checkAndGetPositionRef(AttrList attrList) throws MoAccessException {
        ManagedObject managedObject = null;
        int n = attrList.indexOf("positionRef");
        if (n >= 0) {
            managedObject = (ManagedObject)attrList.getValue(n);
            PlugInUnitMoImpl.validatePositionRef(managedObject);
            attrList.removeElementAt(n);
        }
        return managedObject;
    }

    private static void validatePositionRef(ManagedObject managedObject) throws MoAccessException {
        if (managedObject != null && !(managedObject instanceof Reservable)) {
            throw new ValueOutOfRangeException("positionRef", "PlugInUnit", "The MO referred to by positionRef must be reservable.");
        }
    }

    private void sendSetAdministrativeState(int n, long l, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendSetAdministrativeState(int admState,long timer, int switchAtLock, Coordinator c)", (String)("admState: " + n + "\n\ttimer: " + l + "\n\tswitchAtLock: " + n2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        long l2 = 0L;
        AttrListImpl attrListImpl = new AttrListImpl();
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl((AttrList)attrListImpl, coordinator);
        if (n == 2) {
            l2 = l;
        } else if (n == 0) {
            l2 = l;
        }
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new SignedIntParameter("administrativeState", n));
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new UnsignedIntParameter(SHUT_DOWN_TIMER, l2));
        setRequestContextImpl.addParameter((FroProxy)this.piuProxy, (Parameter)new UnsignedIntParameter("switchAtLockValue", (long)n2));
        setRequestContextImpl.sendSetRequest((FroProxy)this.piuProxy, this.resourceId.getValue(coordinator));
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        UpgradeTrace.debug((Class)PlugInUnitMoImpl.class, (int)70, (String)"sendChangeNotification(ManagedObject mo, String[] attrNames, Object[] newValues, Coordinator context)", (String)("mo: " + managedObject + "\n\tattrNames: " + Lib.toString((String[])stringArray) + "\n\tnewValues: " + Lib.toString((Object[])objectArray) + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    private void createChildren(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createChildren(Coordinator c) ", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.createSubordinates(coordinator, this, (PlugNPlayListener)this.getParent());
    }

    private void deleteChildren(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"deleteChildren(Coordinator c) ", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        PiuMoExtendImpl piuMoExtendImpl = new PiuMoExtendImpl();
        piuMoExtendImpl.deleteSubordinates(coordinator, this);
    }

    private void setAdministrativeStateSai(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSai(int admState, Coordinator c) ", (String)("admState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        int n2 = this.saiResourceId.getValue(coordinator);
        try {
            this.sendSpasSaiFroSetAdmStateReq(coordinator, n2, n);
        }
        catch (FroLocationFailedException froLocationFailedException) {
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                UpgradeTrace.error(this.getClass(), (String)"setAdministrativeStateSai(int admState, Coordinator c)", (String)("Exception caught while trying to sleep for 30 seconds.\n\tadmState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)), (Throwable)exception);
            }
            this.sendSpasSaiFroSetAdmStateReq(coordinator, n2, n);
        }
        catch (FroShutdownException froShutdownException) {
            this.sendSpasSaiFroSetAdmStateReq(coordinator, n2, n);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            throw froNotAccessibleException;
        }
        catch (FroRequestFailedException froRequestFailedException) {
            throw froRequestFailedException;
        }
    }

    private void sendSpasSaiFroSetAdmStateReq(Coordinator coordinator, long l, int n) throws FroNotAccessibleException, FroRequestFailedException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendSpasSaiFroSetAdmStateReq ( Coordinator c, long froId, int admStateSai ) ", (String)("froId: " + l + "\n\tadmStateSai: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        SpasSaiFroSetAdmStateRsp spasSaiFroSetAdmStateRsp = this.saiProxy.sendSpasSaiFroSetAdmStateReq(coordinator.getTransactionID(), l, n);
        if (spasSaiFroSetAdmStateRsp.getResult() != 1) {
            String string = this.saiProxy.getResultMsg(spasSaiFroSetAdmStateRsp.getResult());
            throw new FroRequestFailedException("PlugInUnit", "PlugInUnit fRo", "Set AdministrativeStateSai" + string, spasSaiFroSetAdmStateRsp.getResult());
        }
    }

    public synchronized void parameterChanged(UnlinkedSignal unlinkedSignal, String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)("parameterChdInd: " + unlinkedSignal + "\n\tproxy: " + string));
        MaoPiuFroParameterChdInd maoPiuFroParameterChdInd = null;
        if (unlinkedSignal instanceof OsaPiuAutoLockInd) {
            maoPiuFroParameterChdInd = new MaoPiuFroParameterChdInd();
            maoPiuFroParameterChdInd.putParameters("administrativeState", (Parameter)new SignedIntParameter("administrativeState", 0));
            this.parameterChanged(maoPiuFroParameterChdInd);
        } else if (unlinkedSignal instanceof OsaPiuSwitchReadyInd) {
            OsaPiuSwitchReadyInd osaPiuSwitchReadyInd = (OsaPiuSwitchReadyInd)unlinkedSignal;
            maoPiuFroParameterChdInd = new MaoPiuFroParameterChdInd();
            StructParameter structParameter = new StructParameter("switchAtLock");
            try {
                maoPiuFroParameterChdInd.putParameters("switchAtLockValue", (Parameter)new UnsignedIntParameter("switchAtLockValue", (long)osaPiuSwitchReadyInd.getPiuSwitchAtLock()));
                maoPiuFroParameterChdInd.putParameters("switchAtLockResult", (Parameter)new UnsignedIntParameter("switchAtLockResult", (long)osaPiuSwitchReadyInd.getResult()));
            }
            catch (IllegalParameterValueException illegalParameterValueException) {
                illegalParameterValueException.printStackTrace();
            }
            maoPiuFroParameterChdInd.putParameters("switchAtLock", (Parameter)structParameter);
            this.parameterChanged(maoPiuFroParameterChdInd);
        } else if (unlinkedSignal instanceof OsaPiu2OperStatePropagation) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)"PlugInUnit FRO have changed state (OsaPiu2OperStatePropagation)");
            maoPiuFroParameterChdInd = new MaoPiuFroParameterChdInd();
            maoPiuFroParameterChdInd.putParameters("operationalState", (Parameter)new SignedIntParameter("operationalState", ((OsaPiu2OperStatePropagation)unlinkedSignal).getOperState()));
            maoPiuFroParameterChdInd.putParameters("availabilityStatus", (Parameter)new SignedIntParameter("availabilityStatus", ((OsaPiu2OperStatePropagation)unlinkedSignal).getAvailStatus()));
            this.parameterChanged(maoPiuFroParameterChdInd);
        } else {
            UpgradeTrace.error(this.getClass(), (String)"parameterChanged(UnlinkedSignal parameterChdInd, String proxy)", (String)("Unexpected type of signal, parameterChdInd: " + unlinkedSignal.toString()));
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)("parameterChdInd: " + maoFroGenericParameterChdInd));
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(tnd);
            if (map.containsKey("administrativeState")) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)"PlugInUnit FRO have changed state from shuttingDown to locked (OsaPiuAutoLockInd)");
                int n = ((SignedIntParameter)map.get("administrativeState")).getValue();
                if (n == 0 && this.myPIU_AdmStateListenerInterface != null) {
                    this.myPIU_AdmStateListenerInterface.admStateHasBeenSet(this);
                    this.myPIU_AdmStateListenerInterface = null;
                }
            } else if (map.containsKey("switchAtLockValue")) {
                long l = ((UnsignedIntParameter)map.get("switchAtLockValue")).getValue();
                if (l == 0L) {
                    UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)"PlugInUnit FRO have changed state from locked to unlocked (OsaPiuSwitchReadyInd)");
                    if (((UnsignedIntParameter)map.get("switchAtLockResult")).getValue() != 1L) {
                        UpgradeTrace.warning(this.getClass(), (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)"Normalization rejected when PlugInUnit FRO changed state from locked to unlocked.");
                    }
                    if (this.myPIU_AdmStateListenerInterface != null) {
                        this.myPIU_AdmStateListenerInterface.admStateHasBeenSet(this);
                        this.myPIU_AdmStateListenerInterface = null;
                    }
                    String[] stringArray = new String[]{"administrativeState"};
                    Object[] objectArray = new Object[]{new Integer(1)};
                    myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
                } else if (l == 1L || l == 2L) {
                    UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)"PlugInUnit FRO have changed state from unlocked to locked (OsaPiuSwitchReadyInd)");
                    if (((UnsignedIntParameter)map.get("switchAtLockResult")).getValue() != 1L) {
                        UpgradeTrace.warning(this.getClass(), (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)"Switch rejected when PlugInUnit FRO changed state from unlocked to locked");
                    }
                    if (this.myPIU_AdmStateListenerInterface != null) {
                        this.myPIU_AdmStateListenerInterface.admStateHasBeenSet(this);
                        this.myPIU_AdmStateListenerInterface = null;
                    }
                    String[] stringArray = new String[]{"administrativeState"};
                    Object[] objectArray = new Object[]{new Integer(0)};
                    myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
                }
            } else if (map.containsKey("operationalState")) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)"PlugInUnit FRO have changed state (OsaPiu2OperStatePropagation)");
                try {
                    String[] stringArray = new String[]{"operationalState", "availabilityStatus"};
                    int n = ((SignedIntParameter)map.get("operationalState")).getValue();
                    int n2 = ((SignedIntParameter)map.get("availabilityStatus")).getValue();
                    if (this.myPIU_OperStateListenerInterface != null) {
                        this.myPIU_OperStateListenerInterface.operStateHasBeenSet(this, n);
                    }
                    Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
                    myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
                }
                catch (Exception exception) {
                    UpgradeTrace.error(this.getClass(), (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)"Exception caught, private attribute operState may contain inconsistent data.", (Throwable)exception);
                }
            } else {
                UpgradeTrace.error(this.getClass(), (String)"parameterChanged(MaoFroGenericParameterChdInd parameterChdInd)", (String)("Unexpected type of signal, parameterChdInd: " + maoFroGenericParameterChdInd.toString()));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    private boolean connected2SpasSaiFro(Coordinator coordinator) throws MoAccessException {
        boolean bl;
        int n = this.getSubrackTransmissionType(coordinator);
        if (n == 1 || n == 2) {
            bl = true;
        } else if (n == 3 || n == 4 || n == 5) {
            bl = false;
        } else {
            throw new ValueOutOfRangeException("PlugInUnit", "Unknown TransmissionType, transmissionType: " + n);
        }
        return bl;
    }

    private int getSubrackTransmissionType(Coordinator coordinator) throws MoAccessException {
        SubrackMoImplInterface subrackMoImplInterface = (SubrackMoImplInterface)((SlotMoImplInterface)this.getParent()).getParent();
        SubrackProdTypeBuildIF subrackProdTypeBuildIF = (SubrackProdTypeBuildIF)subrackMoImplInterface.getSubrackProdTypeRef(coordinator);
        if (subrackProdTypeBuildIF != null) {
            return subrackProdTypeBuildIF.getTransmissionType(coordinator);
        }
        return subrackMoImplInterface.getTransmissionTypeFromFro(coordinator);
    }

    private static void checkRestrictionsForMicroCPP(SlotMo slotMo, Coordinator coordinator) throws OperationNotAllowedException, MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("ManagedElement");
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!((ManagedElementMo)managedObject).isIDL1_IDL2(coordinator)) {
                if (((SubrackProdTypeBuildIF)((SubrackMo)slotMo.getParent()).getSubrackProdTypeRef(coordinator)).getTransmissionType(coordinator) == 3) {
                    MoRepository moRepository = MoRepository.instance();
                    MoIterator moIterator2 = moRepository.lookupType("InterPiuLink");
                    if (moIterator2 != null) {
                        boolean bl = false;
                        while (moIterator2.hasMoreElements()) {
                            InterPiuLinkMo interPiuLinkMo = (InterPiuLinkMo)moIterator2.nextMo();
                            if (!slotMo.equals(interPiuLinkMo.getPrimaryPiuSlot(coordinator)) && !slotMo.equals(interPiuLinkMo.getSecondaryPiuSlot(coordinator))) continue;
                            bl = true;
                        }
                        if (!bl) {
                            throw new OperationNotAllowedException("The PlugInUnit can not be created. When transmissionType is ETHERNET_CABLE and there is an InterPiuLink MO on the node, PlugInUnit MOs can only be created for Slot MOs referred to from the InterPiuLink.", "PlugInUnit");
                        }
                    } else {
                        MoIterator moIterator3 = moRepository.lookupType("PlugInUnit");
                        if (moIterator3 != null && moIterator3.hasMoreElements()) {
                            throw new OperationNotAllowedException("The PlugInUnit can not be created.  When transmissionType is ETHERNET_CABLE and there is no InterPiuLink MO on the node, only one PlugInUnit MO is allowed.", "PlugInUnit");
                        }
                    }
                }
            } else {
                MessageLog.info((Class)PlugInUnitMoImpl.class, (String)"Node-type is IDL1_IDL2.");
            }
        }
    }

    private Map getFroAttributes(String string, Coordinator coordinator) throws MoAccessException {
        Map map = null;
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        map = this.piuProxy.getAttributes(coordinator, this.resourceId.getValue(coordinator));
        return map;
    }

    public int getPmFroId(String string, Coordinator coordinator) throws MoAccessException {
        if (osa_pluginunit.getExtendedMoType(this.getType()).equals(string)) {
            return this.getResourceId(coordinator);
        }
        if (spas_plugin_unit.getExtendedMoType(this.getType()).equals(string)) {
            if (this.connected2SpasSaiFro(coordinator)) {
                return this.getSaiResourceId(coordinator);
            }
            int n = this.getResourceId(coordinator);
            if (n == 1) {
                return Integer.MIN_VALUE;
            }
            return -n;
        }
        return -1;
    }

    private int getResultCode(String string) {
        int n = string.lastIndexOf("\"");
        int n2 = string.lastIndexOf("\"", n - 1);
        String string2 = string.substring(n2 + 1, n);
        return Integer.parseInt(string2);
    }

    private class RestartDelay
    implements Runnable {
        private int restartRank;
        private int restartReason;
        private String restartInfo;
        private int resourceId;

        RestartDelay(int n, int n2, String string, int n3) {
            this.restartRank = n;
            this.restartReason = n2;
            this.restartInfo = string;
            this.resourceId = n3;
        }

        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                try {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(new SignedIntParameter("restartRank", this.restartRank));
                    arrayList.add(new SignedIntParameter("restartReason", this.restartReason));
                    arrayList.add(new StringParameter("restartInfo", this.restartInfo));
                    PlugInUnitMoImpl.this.piuProxy.actionWithCfm(null, this.resourceId, 60, arrayList);
                }
                catch (FroRequestFailedException froRequestFailedException) {
                    int n = PlugInUnitMoImpl.this.getResultCode(froRequestFailedException.getVariablesAsString());
                    if (n == 18) {
                        throw new RestartRejectedException("Restart Not allowed");
                    }
                    throw froRequestFailedException;
                }
            }
            catch (Exception exception) {
                MessageLog.traceError(this.getClass(), (String)"RestartDelay run(), restart failed with exception", (Throwable)exception);
            }
            catch (Error error) {
                MessageLog.traceError(this.getClass(), (String)"RestartDelay run(), restart failed with error", (Throwable)error);
            }
        }
    }
}

