/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.cert;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.omg.CORBA.INITIALIZE;
import se.ericsson.cello.pkimgmt.PkiClient;
import se.ericsson.cello.pkimgmt.PkiClientException;
import se.ericsson.cello.pkimgmt.PkiClientMgr;
import se.ericsson.security.corba.cert.CertificateUtil;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class X509ServerTrustManager
implements X509TrustManager {
    protected final X509TrustManager standardTrustManager;
    protected final KeyStore keystore;
    List trustedCertList = new ArrayList();
    protected X509Certificate[] localCertificate;
    public static final String trustedCertsPath;
    protected final long poolingWait = 1500L;
    private static final int OK = 0;
    private static final int NOK = 1;
    private static final int TC_NOK = 2;
    private static final int Dont_Know = 3;
    private static final int NO_TC = 4;
    private static final int PKI_ISSUE = 5;
    protected final long GRACE_PERIOD_MILLIS = 3599000L;
    protected static final TraceErrorLogger logger;
    private static final Class thisClass;
    static /* synthetic */ Class class$se$ericsson$security$corba$cert$X509ServerTrustManager;

    public X509ServerTrustManager(String string, String string2) throws NoSuchAlgorithmException, KeyStoreException {
        this.keystore = this.prepareKeystore();
        this.localCertificate = this.prepareLocalCertificate(string, string2);
        if (System.getProperty("os.name").startsWith("Linux")) {
            for (int i = 0; i < this.localCertificate.length; ++i) {
                this.keystore.setCertificateEntry(string + i, this.localCertificate[i]);
            }
        }
        logger.trace(1, thisClass, "Default TrustManager algorithm: " + TrustManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.keystore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length == 0) {
            throw new NoSuchAlgorithmException("X509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustManagerArray[0];
    }

    public X509Certificate[] getAcceptedIssuers() {
        logger.trace(1, this.getClass(), "getAcceptedIssuers");
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.standardTrustManager.getAcceptedIssuers().clone();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            logger.trace(1, this.getClass(), x509CertificateArray[i].getIssuerDN().getName());
        }
        return x509CertificateArray;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException, IllegalArgumentException {
        int n;
        for (n = 0; n < x509CertificateArray.length; ++n) {
            logger.trace(2, this.getClass(), "subject name " + n + ": " + x509CertificateArray[n].getSubjectDN().getName());
        }
        logger.trace(1, this.getClass(), "checkClientTrusted, authType = " + string);
        if (string == null || x509CertificateArray == null || string.length() == 0 || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("Null or zero-length parameters!!");
        }
        n = this.compareCertificates(x509CertificateArray) ? 1 : 0;
        if (n != 0) {
            logger.trace(1, this.getClass(), "SSL/TLS peer is using local certificate.");
            if (!this.validateCertificate(x509CertificateArray, this.localCertificate)) {
                throw new CertificateException("Invalid certificate when checking locally");
            }
        } else {
            try {
                logger.trace(1, this.getClass(), "SSL/TLS peer is using corba peer certificate.");
                int n2 = this.getRevocationStatus(x509CertificateArray, this.trustedCertList);
                if (n2 != 0) {
                    if (n2 == 2) {
                        throw new CertificateException("Trusted Certificate has been revoked");
                    }
                    if (n2 == 1) {
                        throw new CertificateException("Certificate has been revoked");
                    }
                    if (n2 == 4) {
                        throw new CertificateException("No trusted certificate found");
                    }
                    if (n2 == 5) {
                        throw new CertificateException("PKIClient Issue");
                    }
                }
                this.standardTrustManager.checkClientTrusted(x509CertificateArray, string);
                logger.trace(1, this.getClass(), "Client is trusted");
            }
            catch (CertificateException certificateException) {
                logger.trace(1, this.getClass(), "Invalid certificate when checking by standard trust manager " + certificateException.getMessage());
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    logger.trace(1, this.getClass(), ((Object)x509CertificateArray[i].getSubjectDN()).toString());
                    if (!x509CertificateArray[i].hasUnsupportedCriticalExtension()) continue;
                    logger.trace(1, this.getClass(), "hasUnsupportedCriticalExtension");
                }
                throw new CertificateException("Invalid certificate when checking by standard trust manager. " + certificateException.getMessage());
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws IllegalArgumentException, CertificateException {
        this.standardTrustManager.checkServerTrusted(x509CertificateArray, string);
    }

    protected boolean compareCertificates(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray.length != this.localCertificate.length) {
            return false;
        }
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            if (x509CertificateArray[i].equals(this.localCertificate[i])) continue;
            return false;
        }
        return true;
    }

    protected int getRevocationStatus(X509Certificate[] x509CertificateArray, List list) {
        X509Certificate x509Certificate = this.getTrustedCert(x509CertificateArray, list);
        if (x509Certificate != null) {
            logger.trace(1, this.getClass(), "trusted certificate response: " + x509Certificate.getSigAlgName());
            PkiClient pkiClient = PkiClientMgr.getPkiClient();
            try {
                int n = 0;
                long l = 1500L;
                int n2 = pkiClient.getRevocStatus(x509CertificateArray, x509Certificate, n);
                if (n2 == 3) {
                    while (l <= 6000L) {
                        n = (l += 1500L) < 6000L ? 0 : 1;
                        try {
                            Thread.sleep(1500L);
                            n2 = pkiClient.getRevocStatus(x509CertificateArray, x509Certificate, n);
                            if (n2 != 3) continue;
                            logger.info(this.getClass(), "Certificate revocation response is Don't Know after " + l / 1000L + " second");
                            return 0;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    return 0;
                }
                if (n2 == 0) {
                    logger.trace(1, this.getClass(), "Certificate revocation response is OK");
                    return n2;
                }
                if (n2 == 1) {
                    logger.trace(1, this.getClass(), "Certificate has been revoked");
                    return n2;
                }
                if (n2 == 2) {
                    logger.trace(1, this.getClass(), "Trusted Certificate has been revoked");
                    return n2;
                }
            }
            catch (PkiClientException pkiClientException) {
                logger.info(this.getClass(), "Some problem in PKI client: " + pkiClientException.toString());
                return 5;
            }
        }
        return 4;
    }

    protected X509Certificate getTrustedCert(X509Certificate[] x509CertificateArray, List list) {
        for (int i = 0; i <= x509CertificateArray.length - 1; ++i) {
            for (int j = 0; j <= list.size() - 1; ++j) {
                try {
                    if (x509CertificateArray[i].equals(list.get(j))) {
                        return (X509Certificate)list.get(j);
                    }
                    x509CertificateArray[i].verify(((X509Certificate)list.get(j)).getPublicKey());
                    return (X509Certificate)list.get(j);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        logger.info(this.getClass(), "No trusted certificate found");
        return null;
    }

    protected boolean validateCertificate(X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        if (x509CertificateArray2.length != x509CertificateArray.length) {
            return false;
        }
        try {
            long l = System.currentTimeMillis();
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (l > 3599000L) {
                    x509CertificateArray[i].checkValidity();
                }
                x509CertificateArray[i].verify(x509CertificateArray2[i + 1 < x509CertificateArray.length ? i + 1 : x509CertificateArray.length - 1].getPublicKey());
            }
            return true;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            logger.traceStack(1, this.getClass(), "", certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            logger.traceStack(1, this.getClass(), "", certificateNotYetValidException);
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.traceStack(1, this.getClass(), "", invalidKeyException);
        }
        catch (CertificateException certificateException) {
            logger.traceStack(1, this.getClass(), "", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.traceStack(1, this.getClass(), "", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            logger.traceStack(1, this.getClass(), "", noSuchProviderException);
        }
        catch (SignatureException signatureException) {
            logger.traceStack(1, this.getClass(), "", signatureException);
        }
        return false;
    }

    private KeyStore prepareKeystore() {
        KeyStore keyStore = null;
        TraceErrorLogger traceErrorLogger = new TraceErrorLogger();
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            File file = new File(trustedCertsPath);
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".trustedCert");
                }
            });
            if (fileArray == null) {
                traceErrorLogger.trace(1, thisClass, "No trusted certificates found in " + trustedCertsPath);
                return keyStore;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                this.importCertificate(fileArray[i].getAbsolutePath(), keyStore);
            }
            traceErrorLogger.trace(1, thisClass, "Imported " + keyStore.size() + " trusted certificates from " + trustedCertsPath);
            return keyStore;
        }
        catch (KeyStoreException keyStoreException) {
            traceErrorLogger.traceStack(1, thisClass, "", keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            traceErrorLogger.traceStack(1, thisClass, "", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            traceErrorLogger.traceStack(1, thisClass, "", certificateException);
        }
        catch (IOException iOException) {
            traceErrorLogger.traceStack(1, thisClass, "", iOException);
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importCertificate(String string, KeyStore keyStore) {
        block68: {
            IOException iOException2;
            ByteArrayInputStream byteArrayInputStream;
            DataInputStream dataInputStream;
            FileInputStream fileInputStream;
            block64: {
                fileInputStream = null;
                dataInputStream = null;
                byteArrayInputStream = null;
                fileInputStream = new FileInputStream(string);
                dataInputStream = new DataInputStream(fileInputStream);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                byte[] byArray = new byte[dataInputStream.available()];
                dataInputStream.readFully(byArray);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                int n = 0;
                while (byteArrayInputStream.available() > 0) {
                    Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
                    this.trustedCertList.add((X509Certificate)certificate);
                    keyStore.setCertificateEntry(string + n, certificate);
                    ++n;
                    logger.trace(1, thisClass, "Imported certificate from " + string);
                }
                Object var11_14 = null;
                if (fileInputStream == null) break block64;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    logger.info(thisClass, "Failed to close FileInputStream" + iOException2.getMessage());
                }
                finally {
                    fileInputStream = null;
                }
            }
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException2) {
                    logger.info(thisClass, "Failed to close DataInputStream" + iOException2.getMessage());
                }
                finally {
                    dataInputStream = null;
                }
            }
            if (byteArrayInputStream == null) return;
            try {
                byteArrayInputStream.close();
                return;
            }
            catch (IOException iOException2) {
                logger.info(thisClass, "Failed to close ByteArrayInputStream" + iOException2.getMessage());
                return;
            }
            finally {
                byteArrayInputStream = null;
            }
            {
                catch (FileNotFoundException fileNotFoundException) {
                    IOException iOException32;
                    logger.info(thisClass, "Could not find certificate file:" + fileNotFoundException.getMessage());
                    Object var11_15 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        catch (IOException iOException32) {
                            try {}
                            catch (Throwable throwable) {
                                fileInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close FileInputStream" + iOException32.getMessage());
                            fileInputStream = null;
                        }
                    }
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                            dataInputStream = null;
                        }
                        catch (IOException iOException32) {
                            try {}
                            catch (Throwable throwable) {
                                dataInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close DataInputStream" + iOException32.getMessage());
                            dataInputStream = null;
                        }
                    }
                    if (byteArrayInputStream == null) break block68;
                    try {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException32) {
                        try {}
                        catch (Throwable throwable) {
                            byteArrayInputStream = null;
                            throw throwable;
                        }
                        logger.info(thisClass, "Failed to close ByteArrayInputStream" + iOException32.getMessage());
                        byteArrayInputStream = null;
                        break block68;
                    }
                }
                catch (CertificateException certificateException) {
                    IOException iOException42;
                    logger.info(thisClass, "Got CertificateException:" + certificateException.getMessage());
                    Object var11_16 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        catch (IOException iOException42) {
                            try {}
                            catch (Throwable throwable) {
                                fileInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close FileInputStream" + iOException42.getMessage());
                            fileInputStream = null;
                        }
                    }
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                            dataInputStream = null;
                        }
                        catch (IOException iOException42) {
                            try {}
                            catch (Throwable throwable) {
                                dataInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close DataInputStream" + iOException42.getMessage());
                            dataInputStream = null;
                        }
                    }
                    if (byteArrayInputStream == null) break block68;
                    try {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException42) {
                        try {}
                        catch (Throwable throwable) {
                            byteArrayInputStream = null;
                            throw throwable;
                        }
                        logger.info(thisClass, "Failed to close ByteArrayInputStream" + iOException42.getMessage());
                        byteArrayInputStream = null;
                        break block68;
                    }
                }
                catch (IOException iOException5) {
                    IOException iOException62;
                    logger.info(thisClass, "Got IOException: " + iOException5.getMessage());
                    Object var11_17 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        catch (IOException iOException62) {
                            try {}
                            catch (Throwable throwable) {
                                fileInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close FileInputStream" + iOException62.getMessage());
                            fileInputStream = null;
                        }
                    }
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                            dataInputStream = null;
                        }
                        catch (IOException iOException62) {
                            try {}
                            catch (Throwable throwable) {
                                dataInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close DataInputStream" + iOException62.getMessage());
                            dataInputStream = null;
                        }
                    }
                    if (byteArrayInputStream == null) break block68;
                    try {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException62) {
                        try {}
                        catch (Throwable throwable) {
                            byteArrayInputStream = null;
                            throw throwable;
                        }
                        logger.info(thisClass, "Failed to close ByteArrayInputStream" + iOException62.getMessage());
                        byteArrayInputStream = null;
                        break block68;
                    }
                }
                catch (KeyStoreException keyStoreException) {
                    IOException iOException72;
                    Object var11_18 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        catch (IOException iOException72) {
                            try {}
                            catch (Throwable throwable) {
                                fileInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close FileInputStream" + iOException72.getMessage());
                            fileInputStream = null;
                        }
                    }
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                            dataInputStream = null;
                        }
                        catch (IOException iOException72) {
                            try {}
                            catch (Throwable throwable) {
                                dataInputStream = null;
                                throw throwable;
                            }
                            logger.info(thisClass, "Failed to close DataInputStream" + iOException72.getMessage());
                            dataInputStream = null;
                        }
                    }
                    if (byteArrayInputStream == null) break block68;
                    try {
                        byteArrayInputStream.close();
                        byteArrayInputStream = null;
                    }
                    catch (IOException iOException72) {
                        try {}
                        catch (Throwable throwable) {
                            byteArrayInputStream = null;
                            throw throwable;
                        }
                        logger.info(thisClass, "Failed to close ByteArrayInputStream" + iOException72.getMessage());
                        byteArrayInputStream = null;
                        break block68;
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException82;
                Object var11_19 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    catch (IOException iOException82) {
                        try {}
                        catch (Throwable throwable2) {
                            fileInputStream = null;
                            throw throwable2;
                        }
                        logger.info(thisClass, "Failed to close FileInputStream" + iOException82.getMessage());
                        fileInputStream = null;
                    }
                }
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                        dataInputStream = null;
                    }
                    catch (IOException iOException82) {
                        try {}
                        catch (Throwable throwable3) {
                            dataInputStream = null;
                            throw throwable3;
                        }
                        logger.info(thisClass, "Failed to close DataInputStream" + iOException82.getMessage());
                        dataInputStream = null;
                    }
                }
                if (byteArrayInputStream == null) throw throwable;
                try {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                    throw throwable;
                }
                catch (IOException iOException82) {
                    try {}
                    catch (Throwable throwable4) {
                        byteArrayInputStream = null;
                        throw throwable4;
                    }
                    logger.info(thisClass, "Failed to close ByteArrayInputStream" + iOException82.getMessage());
                    byteArrayInputStream = null;
                    throw throwable;
                }
            }
        }
        logger.info(thisClass, "Could not import certificate: " + string);
    }

    private X509Certificate[] prepareLocalCertificate(String string, String string2) {
        logger.trace(1, thisClass, "prepareLocalCertificate for " + string);
        File file = new File(string);
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        X509Certificate[] x509CertificateArray = null;
        try {
            KeyStore keyStore = CertificateUtil.getPKCS12KeyStore();
            FileInputStream fileInputStream = new FileInputStream(file);
            logger.trace(1, thisClass, "Loading KeyStore");
            keyStore.load(fileInputStream, string2.toCharArray());
            logger.trace(1, thisClass, "KeyStore Successfully loaded");
            Enumeration<String> enumeration = keyStore.aliases();
            logger.trace(1, thisClass, "Check aliases");
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                logger.trace(1, thisClass, "Found alias " + string3);
                Certificate[] certificateArray = keyStore.getCertificateChain(string3);
                if (certificateArray != null) {
                    logger.trace(1, thisClass, "Cert chain for alias " + string3 + " is length " + certificateArray.length);
                    for (int i = 0; i < certificateArray.length; ++i) {
                        logger.trace(1, thisClass, "Adding certificate " + certificateArray[i].getType());
                        arrayList.add(certificateArray[i]);
                    }
                    continue;
                }
                logger.trace(1, thisClass, "No certificate found for alias " + string3);
            }
            logger.trace(1, this.getClass(), string + " - Closing file");
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            logger.trace(1, this.getClass(), string + " - File closed");
            logger.trace(1, this.getClass(), "Creating X509Certificate");
            x509CertificateArray = new X509Certificate[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                x509CertificateArray[i] = (X509Certificate)arrayList.get(i);
            }
            logger.trace(1, this.getClass(), "Returning X509Certificate");
            return x509CertificateArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.traceStack(1, this.getClass(), "", fileNotFoundException);
            throw new INITIALIZE("The local p12 certificate file could not be found at: " + file);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.traceStack(1, this.getClass(), "", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            logger.traceStack(1, this.getClass(), "", certificateException);
        }
        catch (IOException iOException) {
            logger.traceStack(1, this.getClass(), "", iOException);
        }
        catch (KeyStoreException keyStoreException) {
            logger.traceStack(1, thisClass, "", keyStoreException);
            throw new INITIALIZE("Could not get certificate chain. " + keyStoreException.getMessage());
        }
        throw new INITIALIZE("The local p12 certificate file: " + file + " is broken. ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (System.getProperties().containsKey("JAVASIM")) {
            String string = System.getProperty("CPP_SYS_ROOT");
            trustedCertsPath = System.getProperty("javasim.trustedCertsPath", string + "/control/OAM_CRX10115_1/OAM-SIMCELLO_CNX9010224/test/simcello_example/security/trustedCerts/corba_peers");
        } else if (System.getProperties().containsKey("SIM")) {
            trustedCertsPath = "/host/security/trustedCerts/corba_peers/";
        } else {
            String string = System.getProperty("se.ericsson.security.Testing");
            if (System.getProperty("os.name").toUpperCase().indexOf("WIN") == -1 && string != null && string.equals("ON")) {
                String string2 = System.getProperty("CPP_SYS_ROOT");
                trustedCertsPath = string2 + "/control/CPPSEC_CRX901138/CSU_CNX9010153/test/files/c/security/trustedCerts/corba_peers";
            } else {
                trustedCertsPath = "/c/security/trustedCerts/corba_peers/";
            }
        }
        logger = new TraceErrorLogger();
        thisClass = class$se$ericsson$security$corba$cert$X509ServerTrustManager == null ? (class$se$ericsson$security$corba$cert$X509ServerTrustManager = X509ServerTrustManager.class$("se.ericsson.security.corba.cert.X509ServerTrustManager")) : class$se$ericsson$security$corba$cert$X509ServerTrustManager;
    }
}

