/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JTextField;
import se.ericsson.cello.emas.sm.applications.ConfigurationVersionPropertiesView;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.gengui.InputVerifier;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.Struct;
import se.ericsson.cello.support.proxy.Transaction;

public class ConfigurationVersionPropertiesController
extends AbstractApplicationController
implements ActionListener {
    private static final String ROLLBACKLIST_CHANGED = "ROLLBACKLIST_CHANGED";
    private static final int TRANSACTION_TIMEOUT_1800_SECONDS = 1800;
    private static final int TRANSACTION_TIMEOUT_120_SECONDS = 120;
    protected static final String CMD_PUT_TO_FTP_BUTTON = "put to ftp button pressed";
    protected static final String CMD_RESTORE_BUTTON = "Restore button pressed";
    static final String CV_DELETED_NOTIFICATION = "se.ericsson.cello.emas.sm.CV_DELETED";
    static final String CV_ADDED_NOTIFICATION = "se.ericsson.cello.emas.sm.CV_ADDED";
    private boolean isCreateNewCV = false;
    private boolean somethingChanged = false;
    private ConfigurationVersionPropertiesView view;
    private String[] rollbackList;
    private Struct[] storedConfigVersion = null;
    private String startableCV;
    private String currentLoadedCV;
    private String lastCreatedCV;
    private String executingCV;
    private static final int TYPE_FIELD_LENGTH = 5;
    private static final int CV_NOT_IN_LIST = 0;
    private MOProxy cvMO = null;
    private int currentPos = 0;
    private int newPos;
    private CVNameVerifier characterVerifierName = new CVNameVerifier();
    private CVCommentVerifier characterVerifierComment = new CVCommentVerifier();
    CSException error = null;
    String transNotInList;
    String transEndOfList;
    String transAddToList;
    private int rblOriginalChoice = -1;

    protected void init() {
        this.view = (ConfigurationVersionPropertiesView)this.getView();
        this.view.cvNameField.setInputVerifier((InputVerifier)this.characterVerifierName);
        this.view.comment.setInputVerifier((InputVerifier)this.characterVerifierComment);
        try {
            this.cvMO = MOProxy.getRoot().getChildren(2, "ConfigurationVersion", "")[0];
            this.storedConfigVersion = (Struct[])this.cvMO.getAttribute("storedConfigurationVersions");
            this.rollbackList = (String[])this.cvMO.getAttribute("rollbackList");
            if (this.rollbackList == null) {
                this.rollbackList = new String[0];
            }
            this.startableCV = (String)this.cvMO.getAttribute("startableConfigurationVersion");
            this.currentLoadedCV = (String)this.cvMO.getAttribute("currentLoadedConfigurationVersion");
            this.lastCreatedCV = (String)this.cvMO.getAttribute("lastCreatedCv");
            this.executingCV = (String)this.cvMO.getAttribute("executingCv");
        }
        catch (CSException e) {
            this.error = e;
            return;
        }
        if (this.getParameter("LDNLIST") != null) {
            this.view.setHelpTag("SOFTWAREMANAGER_CONFIGURATIONVERSIONPROPERTIES_BUTTON_HELP");
            this.viewCv();
        } else {
            this.view.setHelpTag("SOFTWAREMANAGER_CREATECONFIGURATIONVERSION_BUTTON_HELP");
            this.showNewCv();
            this.isCreateNewCV = true;
        }
        if (this.getParameter("ADD_CV_TITLE") != null) {
            String createCVTitle = (String)this.getParameter("ADD_CV_TITLE");
            this.getApplication().setTitle(createCVTitle, null);
            this.isCreateNewCV = true;
        } else if (this.getParameter("LDNLIST") == null) {
            this.getApplication().setTitle("ADD_CV_TITLE", null);
        } else {
            this.getApplication().setTitle("CONFIGURATION_VERSION_TITLE", null);
        }
        this.view.ldn.setValue(this.cvMO.getDN());
        this.setButtonListeners();
        this.setActionListeners();
        this.transNotInList = this.getString("CV_NOT_IN_LIST", null);
        this.transEndOfList = this.getString("CV_END_OF_LIST", null);
        this.transAddToList = this.getString("CV_ADD_TO_LIST", null);
        this.updateRestoreButtonState();
    }

    protected void beforeVisible() {
        this.view.setToolTipsOnLabels();
    }

    protected void afterVisible() {
        if (this.error != null) {
            this.reportException((Exception)((Object)this.error), "ERROR_GET", null);
            this.viewClosing();
        }
    }

    private void showNewCv() {
        this.view.startButton.setEnabled(false);
        this.view.loadButton.setEnabled(false);
        this.view.deleteButton.setEnabled(false);
        this.view.restoreButton.setEnabled(false);
        this.view.putToFtpButton.setEnabled(false);
        this.view.cvNameField.setEditable(true);
        this.view.comment.setEditable(true);
        this.view.upControlFilePath.setValue("");
        this.view.cvNameField.setValue("");
        this.view.comment.setValue("");
        this.view.createButton.setEnabled(this.checkMandatoryFields() && !this.view.comment.faultyValueEntered());
        this.view.applyButton.setEnabled(this.checkMandatoryFields() && !this.view.comment.faultyValueEntered());
        this.view.okButton.setEnabled(this.checkMandatoryFields() && !this.view.comment.faultyValueEntered());
        this.currentPos = 0;
        this.fillRBList();
        String filledIn = this.getString("FILLEDIN", null);
        this.view.createDate.setValue(filledIn);
        this.view.creator.setValue(filledIn);
        this.view.cvType.setValue(filledIn);
        this.view.cvNameField.requestFocus();
    }

    private int findIndexInStored(String name) {
        int nbCvs = this.storedConfigVersion.length;
        if (name == null) {
            Log.logError((String)("Error: findIndexInStored (name=null)" + this.getClass().toString()));
        } else {
            try {
                for (int i = 0; i < nbCvs; ++i) {
                    if (!name.equals(this.storedConfigVersion[i].getElementValue("name"))) continue;
                    return i;
                }
            }
            catch (NoSuchFieldException nsfe) {
                Log.logError((String)"Error getting the value ", (Throwable)nsfe);
            }
        }
        return -1;
    }

    private void viewCv() {
        int index = this.findIndexInStored((String)this.getParameter("CV_NAME"));
        this.view.createButton.setEnabled(false);
        this.view.putToFtpButton.setEnabled(true);
        this.view.cvNameField.setEditable(false);
        this.view.comment.setEditable(false);
        try {
            if (this.currentLoadedCV.equals(this.storedConfigVersion[index].getElementValue("name"))) {
                this.view.deleteButton.setEnabled(false);
            }
            if (!this.isSelectedCvStartable()) {
                this.view.startButton.setEnabled(false);
                this.view.deleteButton.setEnabled(false);
            }
            for (int i = 0; i < this.rollbackList.length; ++i) {
                if (!this.rollbackList[i].equals(this.storedConfigVersion[index].getElementValue("name"))) continue;
                this.view.deleteButton.setEnabled(false);
                break;
            }
            if (this.currentLoadedCV == null || this.currentLoadedCV.length() == 0) {
                this.currentLoadedCV = "-";
            }
            if (this.startableCV == null || this.startableCV.length() == 0) {
                this.startableCV = "-";
            }
            if (this.lastCreatedCV == null || this.lastCreatedCV.length() == 0) {
                this.lastCreatedCV = "-";
            }
            if (this.executingCV == null || this.executingCV.length() == 0) {
                this.executingCV = "-";
            }
            this.view.startableCV.setValue(this.startableCV);
            this.view.currentLoadedCV.setValue(this.currentLoadedCV);
            this.view.lastCreatedCV.setValue(this.lastCreatedCV);
            this.view.executingCV.setValue(this.executingCV);
            this.view.cvNameField.setValue((String)this.storedConfigVersion[index].getElementValue("name"));
            this.view.cvType.setValue(this.storedConfigVersion[index].getElementValue("type").toString());
            this.view.upControlFilePath.setValue((String)this.storedConfigVersion[index].getElementValue("upgradePackageId"));
            String date = (String)this.storedConfigVersion[index].getElementValue("date");
            this.view.createDate.setValue(new TimeConverter().formatTime(date));
            this.view.creator.setValue((String)this.storedConfigVersion[index].getElementValue("operatorName"));
            this.view.comment.setValue((String)this.storedConfigVersion[index].getElementValue("operatorComment"));
            String[] items = new String[this.rollbackList.length + 2];
            items[0] = this.getString("CV_NOT_IN_LIST", null);
            if (this.rollbackList.length == 0) {
                items[1] = this.getString("CV_ADD_TO_LIST", null);
            } else {
                for (int i = 1; i <= this.rollbackList.length; ++i) {
                    items[i] = Integer.toString(i);
                    if (!this.rollbackList[i - 1].equals((String)this.storedConfigVersion[index].getElementValue("name"))) continue;
                    this.currentPos = i;
                }
                items[this.rollbackList.length + 1] = this.getString("CV_END_OF_LIST", null);
            }
            this.view.rblPositionSelector.removeAllItems();
            this.view.rblPositionSelector.addItems(items);
            this.view.rblPositionSelector.setValue(items[this.currentPos]);
            this.rblOriginalChoice = this.view.rblPositionSelector.getSelectedIndex();
        }
        catch (SyntaxException e) {
            Log.logError((String)"Error updating screen", (Throwable)e);
        }
        catch (NoSuchFieldException nsfe) {
            Log.logError((String)"Error getting the value ", (Throwable)nsfe);
        }
    }

    private boolean isSelectedCvStartable() {
        boolean returnValue = false;
        try {
            int index = this.findIndexInStored((String)this.getParameter("CV_NAME"));
            returnValue = !this.startableCV.equals(this.storedConfigVersion[index].getElementValue("name"));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return returnValue;
    }

    private void setButtonListeners() {
        this.view.okButton.setActionListener((ActionListener)this, "OK");
        this.view.applyButton.setActionListener((ActionListener)this, "APPLY");
        this.view.cancelButton.setActionListener((ActionListener)this, "CANCEL");
        this.view.createButton.setActionListener((ActionListener)this, "CREATE_CV");
        this.view.deleteButton.setActionListener((ActionListener)this, "DELETE_CV");
        this.view.startButton.setActionListener((ActionListener)this, "SET_STARTABLE");
        this.view.loadButton.setActionListener((ActionListener)this, "RESTART");
        this.view.putToFtpButton.setActionListener((ActionListener)this, CMD_PUT_TO_FTP_BUTTON);
        this.view.restoreButton.setActionListener((ActionListener)this, CMD_RESTORE_BUTTON);
    }

    private void setActionListeners() {
        this.view.rblPositionSelector.setActionListener((ActionListener)this, ROLLBACKLIST_CHANGED);
        this.view.cvNameField.setActionListener((ActionListener)this, "CVNAME");
        this.view.comment.setActionListener((ActionListener)this, "COMMENT");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        String cvName = this.view.cvNameField.getValue();
        boolean mandatoryOk = this.checkMandatoryFields();
        boolean faultyValueEntered = this.view.comment.faultyValueEntered();
        this.view.createButton.setEnabled(this.isCreateNewCV && mandatoryOk && !faultyValueEntered);
        this.view.okButton.setEnabled(mandatoryOk && !faultyValueEntered);
        this.view.applyButton.setEnabled(this.isCreateNewCV && mandatoryOk && !faultyValueEntered);
        if (actionCommand.equals("OK")) {
            this.executeCreateCVAndCloseApplication();
        } else if (actionCommand.equals("APPLY")) {
            if (this.checkMandatoryFields()) {
                this.resetRBListValues();
                this.rblOriginalChoice = this.view.rblPositionSelector.getSelectedIndex();
            }
            if (this.error == null) {
                this.somethingChanged = false;
                this.view.applyButton.setEnabled(false);
                this.view.startButton.setEnabled(true);
                this.view.deleteButton.setEnabled(this.deleteButtonCanBeEnabled());
                this.view.loadButton.setEnabled(true);
                this.view.putToFtpButton.setEnabled(true);
                this.updateRestoreButtonState();
                this.view.setHelpTag("SOFTWAREMANAGER_CONFIGURATIONVERSIONPROPERTIES_BUTTON_HELP");
                if (this.isCreateNewCV) {
                    this.view.createButton.setEnabled(false);
                    this.view.cvNameField.setEditable(false);
                    this.view.comment.setEditable(false);
                }
                this.isCreateNewCV = false;
            } else {
                this.error = null;
            }
        } else if (actionCommand.equals("CANCEL")) {
            this.viewClosing();
        } else if (actionCommand.equals("CVNAME")) {
            this.somethingChanged = true;
        } else if (actionCommand.equals(ROLLBACKLIST_CHANGED)) {
            this.somethingChanged = this.view.rblPositionSelector.getSelectedIndex() != this.rblOriginalChoice;
            this.view.applyButton.setEnabled(this.somethingChanged);
            this.view.loadButton.setEnabled(!this.somethingChanged);
            this.view.startButton.setEnabled(!this.somethingChanged && this.isSelectedCvStartable());
            this.view.putToFtpButton.setEnabled(!this.somethingChanged);
            this.view.deleteButton.setEnabled(!this.somethingChanged && this.deleteButtonCanBeEnabled());
            if (this.somethingChanged) {
                this.view.restoreButton.setEnabled(false);
            } else {
                this.updateRestoreButtonState();
            }
            this.updateScreen();
        } else if (actionCommand.equals("CREATE_CV")) {
            this.executeCreateCVAndCloseApplication();
        } else if (actionCommand.equals("DELETE_CV")) {
            this.deleteCV();
        } else if (actionCommand.equals("SET_STARTABLE")) {
            try {
                this.setStartable(cvName);
            }
            catch (CSException e) {
                this.reportException((Exception)((Object)e), "ERROR_SET_STARTABLE", new Object[]{cvName});
            }
        } else if (actionCommand.equals("RESTART")) {
            int index_cvName = this.findIndexInStored(cvName);
            int index_startable = this.findIndexInStored(this.startableCV);
            try {
                if (index_cvName < 0 || index_startable < 0) {
                    Log.logError((String)"CV_NOT_IN_LIST");
                    CSException e = new CSException("CV_NOT_IN_LIST");
                    throw e;
                }
                if (index_cvName != index_startable) {
                    this.setStartable(cvName);
                }
                this.restart();
            }
            catch (CSException e) {
                this.reportException((Exception)((Object)e), "ERROR_RESTART_CV", new Object[]{cvName});
                Log.logError((String)"CSException", (Throwable)e);
            }
        } else if (actionCommand.equals(CMD_PUT_TO_FTP_BUTTON)) {
            this.putCv();
        } else if (actionCommand.equals(CMD_RESTORE_BUTTON)) {
            this.restoreCv();
        }
    }

    private void putCv() {
        Properties props = new Properties();
        String ldn = this.cvMO.getDN();
        props.put("LDNLIST", ldn);
        String cv = this.view.cvNameField.getValue();
        props.put("CV_NAME", cv);
        this.getApplicationManager().launchEmtTool(EmasSystemProperties.getProperty((String)"CVPUTTOFTP_CONFIG"), props);
    }

    protected boolean putToFtpServerAlreadyOpen(MainWindowController mainWindowController) {
        return false;
    }

    private void restoreCv() {
        Configer myConfiger = new Configer();
        Properties props = myConfiger.getSupersedingProperties();
        String cvName = this.view.cvNameField.getValue();
        props.put("CV_NAME", cvName);
        String ldnList = this.cvMO.getDN();
        props.put("LDNLIST", ldnList);
        this.getApplicationManager().launchEmtTool(EmasSystemProperties.getProperty((String)"CVRESTORE_CONFIG"), props);
    }

    private void resetRBListValues() {
        Transaction myTransaction = null;
        try {
            myTransaction = new Transaction(1800);
            Log.trace((String)"Searching for cvMO in transaction");
            if (!this.isCreateNewCV) {
                if (this.currentPos == 0) {
                    this.setRBListPosition(myTransaction);
                } else {
                    this.resetRBListPosition(myTransaction);
                }
            } else {
                this.buildNewCv(myTransaction);
                this.setRBListPosition(myTransaction);
            }
            myTransaction.commit();
            myTransaction.end();
            String notificationType = CV_ADDED_NOTIFICATION;
            String configurationVersionName = this.view.cvNameField.getValue();
            Log.logNotify((String)("Performing sendEmNotification('Add') " + configurationVersionName));
            this.sendNotification(notificationType, configurationVersionName);
        }
        catch (CSException e) {
            this.error = e;
            try {
                myTransaction.rollback();
                myTransaction.end();
            }
            catch (CSException be) {
                Log.logError((String)"Transaction failed", (Throwable)be);
            }
            this.reportException((Exception)((Object)e), "ERROR_SET", null);
            return;
        }
        try {
            myTransaction = new Transaction();
            if (this.isCreateNewCV) {
                this.storedConfigVersion = (Struct[])this.cvMO.getAttribute("storedConfigurationVersions", myTransaction.session);
            }
            this.rollbackList = (String[])this.cvMO.getAttribute("rollbackList", myTransaction.session);
            if (this.rollbackList == null) {
                this.rollbackList = new String[0];
            }
            myTransaction.commit();
            myTransaction.end();
            this.updateScreen();
            this.fillRBList();
        }
        catch (CSException e1) {
            this.error = e1;
            try {
                myTransaction.rollback();
                myTransaction.end();
            }
            catch (CSException e2) {
                Log.logError((String)"Error rolling back transaction", (Throwable)e2);
            }
            this.reportException((Exception)((Object)e1), "ERROR_GET", null);
        }
    }

    private void resetRBListPosition(Transaction myTransaction) throws CSException {
        String configurationVersionName = "";
        NameValue[] startArgs = new NameValue[1];
        String rbPositionSelected = this.view.rblPositionSelector.getValue();
        if (rbPositionSelected.equals(this.transNotInList)) {
            configurationVersionName = this.rollbackList[this.currentPos - 1];
            startArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
            this.cvMO.action("removeFromRollbackList", startArgs, myTransaction.session);
            this.currentPos = 0;
        } else {
            int i;
            this.newPos = rbPositionSelected.equals(this.transEndOfList) ? this.rollbackList.length - 1 : Integer.parseInt(rbPositionSelected) - 1;
            ArrayList<String> tempResetList = new ArrayList<String>();
            for (i = 0; i < this.rollbackList.length; ++i) {
                tempResetList.add(i, this.rollbackList[i]);
            }
            tempResetList.remove(this.currentPos - 1);
            tempResetList.add(this.newPos, this.rollbackList[this.currentPos - 1]);
            int configurationVersionNumber = this.newPos < this.currentPos - 1 ? this.currentPos : this.newPos + 1;
            for (i = 0; i < configurationVersionNumber; ++i) {
                startArgs[0] = new NameValue("configurationVersionName", (Object)this.rollbackList[i]);
                this.cvMO.action("removeFromRollbackList", startArgs, myTransaction.session);
            }
            for (i = configurationVersionNumber - 1; i > -1; --i) {
                configurationVersionName = (String)tempResetList.get(i);
                startArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
                this.cvMO.action("setFirstRollbackList", startArgs, myTransaction.session);
                this.currentPos = this.newPos + 1;
            }
        }
        this.fillRBList();
    }

    private void setRBListPosition(Transaction myTransaction) throws CSException {
        String configurationVersionName = "";
        NameValue[] startArgs = new NameValue[1];
        String rbPositionSelected = this.view.rblPositionSelector.getValue();
        if (!rbPositionSelected.equals(this.transNotInList)) {
            int i;
            this.newPos = rbPositionSelected.equals(this.transEndOfList) ? this.rollbackList.length : (rbPositionSelected.equals(this.transAddToList) ? 0 : Integer.parseInt(rbPositionSelected) - 1);
            for (i = 0; i < this.newPos; ++i) {
                configurationVersionName = this.rollbackList[i];
                startArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
                this.cvMO.action("removeFromRollbackList", startArgs, myTransaction.session);
            }
            configurationVersionName = this.view.cvNameField.getValue();
            startArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
            this.cvMO.action("setFirstRollbackList", startArgs, myTransaction.session);
            for (i = this.newPos - 1; i >= 0; --i) {
                configurationVersionName = this.rollbackList[i];
                startArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
                this.cvMO.action("setFirstRollbackList", startArgs, myTransaction.session);
            }
            this.currentPos = this.newPos + 1;
            this.fillRBList();
        }
    }

    private boolean checkMandatoryFields() {
        return this.view.cvNameField.isFilledIn();
    }

    protected boolean canStop() {
        return true;
    }

    private void fillRBList() {
        try {
            String[] items = new String[this.rollbackList.length + 2];
            items[0] = this.getString("CV_NOT_IN_LIST", null);
            if (this.rollbackList.length == 0) {
                items[1] = this.getString("CV_ADD_TO_LIST", null);
            } else {
                for (int i = 1; i <= this.rollbackList.length; ++i) {
                    items[i] = Integer.toString(i);
                }
                items[this.rollbackList.length + 1] = this.getString("CV_END_OF_LIST", null);
            }
            this.view.rblPositionSelector.removeAllItems();
            this.view.rblPositionSelector.addItems(items);
            this.view.rblPositionSelector.setValue(items[this.currentPos]);
        }
        catch (SyntaxException e) {
            Log.logError((String)"Error updating screen", (Throwable)e);
        }
    }

    private void buildNewCv(Transaction myTransaction) throws CSException {
        boolean mandatoryOk = this.checkMandatoryFields();
        boolean faultyValueEntered = this.view.comment.faultyValueEntered();
        this.view.applyButton.setEnabled(mandatoryOk && !faultyValueEntered);
        NameValue[] createArgs = new NameValue[5];
        String configurationVersionName = this.view.cvNameField.getValue();
        Integer type = new Integer(5);
        String operatorName = System.getProperty("user.name");
        String comment = this.view.getComment();
        createArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
        createArgs[1] = new NameValue("identity", (Object)configurationVersionName);
        createArgs[2] = new NameValue("type", (Object)type);
        createArgs[3] = new NameValue("operatorName", (Object)operatorName);
        if (comment.length() == 0) {
            comment = " ";
        }
        createArgs[4] = new NameValue("operatorComment", (Object)comment);
        this.cvMO.action("create", createArgs, myTransaction.session);
        this.getApplication().setTitle("CONFIGURATION_VERSION_TITLE", null);
    }

    private void updateScreen() {
        Transaction transaction = null;
        try {
            transaction = new Transaction();
            this.view.cvType.setValue(this.storedConfigVersion[this.storedConfigVersion.length - 1].getElementValue("type").toString());
            this.view.upControlFilePath.setValue(this.storedConfigVersion[this.storedConfigVersion.length - 1].getElementValue("upgradePackageId").toString());
            String date = (String)this.storedConfigVersion[this.storedConfigVersion.length - 1].getElementValue("date");
            this.view.createDate.setValue(new TimeConverter().formatTime(date));
            this.view.creator.setValue((String)this.storedConfigVersion[this.storedConfigVersion.length - 1].getElementValue("operatorName"));
            this.view.startableCV.setValue((String)this.cvMO.getAttribute("startableConfigurationVersion", transaction.session));
            this.view.currentLoadedCV.setValue((String)this.cvMO.getAttribute("currentLoadedConfigurationVersion", transaction.session));
            this.view.lastCreatedCV.setValue((String)this.cvMO.getAttribute("lastCreatedCv", transaction.session));
            this.view.executingCV.setValue((String)this.cvMO.getAttribute("executingCv", transaction.session));
            transaction.commit();
            transaction.end();
        }
        catch (NoSuchFieldException nsfe) {
            Log.logError((String)"Error getting the value ", (Throwable)nsfe);
        }
        catch (CSException nsfe) {
            Log.logError((String)"Error getting the value ", (Throwable)nsfe);
        }
    }

    private void setStartable(String cvName) throws CSException {
        Transaction tid = null;
        try {
            tid = new Transaction();
            NameValue[] startArgs = new NameValue[]{new NameValue("param", (Object)cvName)};
            this.cvMO.action("setStartable", startArgs, tid.session);
            tid.commit();
            tid.end();
            this.view.startButton.setEnabled(false);
            this.view.deleteButton.setEnabled(false);
            this.startableCV = cvName;
            this.updateScreen();
        }
        catch (CSException e) {
            try {
                tid.rollback();
                tid.end();
            }
            catch (CSException be) {
                Log.logError((String)"Unable to rollback transaction", (Throwable)be);
            }
            throw e;
        }
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private void deleteCV() {
        Transaction myTransaction = null;
        String configurationVersionName = this.view.cvNameField.getValue();
        try {
            boolean inRBList = false;
            boolean isStartable = false;
            String message = null;
            for (int i = 0; i < this.rollbackList.length && !inRBList; ++i) {
                if (!this.rollbackList[i].equals(configurationVersionName)) continue;
                inRBList = true;
            }
            if (this.startableCV.equals(configurationVersionName)) {
                isStartable = true;
            }
            message = inRBList && isStartable ? "CONFIRM_DELETE_IN_RBLIST_AND_STARTABLE_MSG" : (!inRBList && isStartable ? "CONFIRM_DELETE_STARTABLE_CV_MSG" : (inRBList && !isStartable ? "CONFIRM_DELETE_CV_IN_RBLIST_MSG" : "CONFIRM_DELETE_STANDARD_MSG"));
            boolean delete = false;
            int chosenOption = this.showConfirmDialog(message, new Object[]{this.view.cvNameField.getValue()}, "CONFIRM_DELETE_TITLE", null, 0, 2, null);
            boolean bl = delete = chosenOption == 0;
            if (delete) {
                myTransaction = new Transaction(120);
                NameValue[] startArgs = new NameValue[1];
                if (inRBList) {
                    startArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
                    this.cvMO.action("removeFromRollbackList", startArgs, myTransaction.session);
                }
                if (isStartable) {
                    startArgs[0] = new NameValue("configurationVersionName", (Object)this.currentLoadedCV);
                    this.cvMO.action("setStartable", startArgs, myTransaction.session);
                }
                startArgs[0] = new NameValue("configurationVersionName", (Object)configurationVersionName);
                this.cvMO.action("delete", startArgs, myTransaction.session);
                myTransaction.commit();
                myTransaction.end();
                Log.logNotify((String)("Performing sendEmNotification('Delete') " + configurationVersionName));
                String notificationType = CV_DELETED_NOTIFICATION;
                this.sendNotification(notificationType, configurationVersionName);
                this.viewClosing();
            }
        }
        catch (CSException e) {
            Log.logError((String)"Error Setting value on MO", (Throwable)e);
            try {
                myTransaction.rollback();
                myTransaction.end();
            }
            catch (CSException be) {
                Log.logError((String)"Error rolling back");
            }
            this.reportException((Exception)((Object)e), "ERROR_REMOVE_CV", new Object[]{configurationVersionName});
        }
    }

    private void restart() {
        MainWindowController mainWindow = EmasGuilibMediator.getReference().getMainWindowReference();
        String actionName = "manualRestart";
        String rooLdn = "ManagedElement=1";
        Configer myConfiger = new Configer();
        Properties props = myConfiger.getSupersedingProperties();
        props.setProperty("LDNs", rooLdn);
        props.setProperty("MOACTION", actionName);
        Log.trace((String)("Restart of the node:" + rooLdn));
        String cvMoPropCfgFileName = EmasSystemProperties.getProperty((String)"CVMOPROP_CONFIG", (String)"CVMOPROP_CONFIG: is not defined");
        mainWindow.getApplicationManager().launchTool(cvMoPropCfgFileName, props);
    }

    private void executeCreateCVAndCloseApplication() {
        if (this.checkMandatoryFields() && this.somethingChanged) {
            this.resetRBListValues();
        }
        if (this.error == null) {
            this.viewClosing();
        } else {
            this.error = null;
        }
    }

    private boolean deleteButtonCanBeEnabled() {
        boolean result = false;
        String cvName = this.view.cvNameField.getValue();
        boolean currentlyLoaded = this.currentLoadedCV.equals(cvName);
        boolean startable = this.startableCV.equals(cvName);
        boolean cvInRollBackList = this.cvIsInRBL(cvName);
        result = !currentlyLoaded && !startable && !cvInRollBackList;
        return result;
    }

    private boolean cvIsInRBL(String cvName) {
        boolean result = false;
        for (int i = 0; i < this.rollbackList.length; ++i) {
            if (!this.rollbackList[i].equals(cvName)) continue;
            result = true;
        }
        return result;
    }

    private void sendNotification(String notificationType, Object cvName) {
        AbstractApplication abstractApplication = this.view.getApplication();
        ApplicationManager applicationManager = abstractApplication.getApplicationManager();
        ConfigurationVersionPropertiesController source = this;
        applicationManager.sendNotification(notificationType, (Object)source, cvName);
    }

    private void updateRestoreButtonState() {
        boolean enable = false;
        String cvName = null;
        int cvIndex = -1;
        String cvType = null;
        try {
            cvName = (String)this.getParameter("CV_NAME");
            if (cvName != null && cvName.length() > 0) {
                cvIndex = this.findIndexInStored(cvName);
                cvType = ((String)this.storedConfigVersion[cvIndex].getElementValue("type")).trim();
            }
        }
        catch (NoSuchFieldException e1) {
            Log.logError((String)("No type field in the storedConfigurationVersion " + cvName), (Throwable)e1);
            cvType = null;
        }
        catch (Exception e2) {
            Log.logError((String)("Error getting type of the storedConfigurationVersion " + cvName), (Throwable)e2);
            cvType = null;
        }
        Log.logNotify((String)("The CV " + cvName + " has a type " + cvType));
        enable = cvType != null && cvType.equalsIgnoreCase("downloaded");
        this.view.restoreButton.setEnabled(enable);
    }

    private class Configer {
        private final String KEY_DELIMITER = ";";
        private static final String SUPERSEDING_PARAMETER_LIST = "SUPERSEDING_PARAMETER_LIST";

        private Configer() {
        }

        public Properties getSupersedingProperties() {
            Properties tempProp = new Properties();
            Properties prevProps = null;
            if (EmasSystemProperties.isInitialized()) {
                prevProps = EmasSystemProperties.getProperties();
            }
            if (prevProps == null) {
                return tempProp;
            }
            String strSupersedingList = prevProps.getProperty(SUPERSEDING_PARAMETER_LIST);
            if (strSupersedingList != null) {
                tempProp.put(SUPERSEDING_PARAMETER_LIST, strSupersedingList);
                String[] supersedingListArray = strSupersedingList.split(";");
                for (int i = 0; i < supersedingListArray.length; ++i) {
                    String supersedingName = supersedingListArray[i];
                    String supersedingValue = prevProps.getProperty(supersedingName);
                    if (null == supersedingValue) continue;
                    tempProp.put(supersedingName, supersedingValue);
                }
            }
            return tempProp;
        }
    }

    private static class CVCommentVerifier
    extends InputVerifier {
        private CVCommentVerifier() {
        }

        public boolean verify(JComponent input) {
            JTextField field = (JTextField)input;
            String value = field.getText();
            return value.indexOf(33) < 0 && value.indexOf(34) < 0 && value.indexOf(130) < 0 && value.indexOf(39) < 0 && value.indexOf(145) < 0 && value.indexOf(146) < 0 && value.indexOf(147) < 0 && value.indexOf(148) < 0 && value.indexOf(44) < 0 && value.indexOf(47) < 0 && value.indexOf(94) < 0 && value.indexOf(64) < 0 && value.indexOf(126) < 0 && value.indexOf(96) < 0 && value.indexOf(124) < 0 && value.indexOf(35) < 0 && value.indexOf(42) < 0 && value.length() <= 40;
        }
    }

    private static class CVNameVerifier
    extends InputVerifier {
        private CVNameVerifier() {
        }

        public boolean verify(JComponent input) {
            int count = 0;
            JTextField field = (JTextField)input;
            String value = field.getText();
            for (count = 32; count <= 44; ++count) {
                if (count == 37 || count == 38 || value.indexOf(count) < 0) continue;
                return false;
            }
            for (count = 46; count <= 47; ++count) {
                if (count == 46 || value.indexOf(count) < 0) continue;
                return false;
            }
            for (count = 58; count <= 64; ++count) {
                if (count == 58 || value.indexOf(count) < 0) continue;
                return false;
            }
            for (count = 91; count <= 96; ++count) {
                if (count == 95 || value.indexOf(count) < 0) continue;
                return false;
            }
            for (count = 123; count <= 255; ++count) {
                if (value.indexOf(count) < 0) continue;
                return false;
            }
            return value.length() <= 40;
        }
    }
}

