/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.applications;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.JList;
import se.ericsson.cello.emas.sm.applications.EmasDialogController;
import se.ericsson.cello.emas.sm.applications.RepertoireSelectView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.Transaction;

public class RepertoireSelectController
extends EmasDialogController
implements ActionListener {
    private RepertoireSelectView view;
    private TreeMap availableRepertoiresTable = new TreeMap();
    private TreeMap selectedRepertoiresTable = new TreeMap();
    protected boolean somethingChanged = false;
    private int AVAILABLE_REPERTOIRES = 0;
    private int SELECTED_REPERTOIRES = 1;
    private int NO_SELECTION = 2;
    protected Exception error = null;

    protected void init() {
        this.view = (RepertoireSelectView)this.getView();
        this.setDialogTitle("REPERTOIRE_SELECT_TITLE", null);
        this.setButtonListeners();
        this.setTableListeners();
        this.getRepertoireDataFromServer();
        this.updateTables();
        this.setSelections(this.NO_SELECTION);
    }

    protected void afterVisible() {
        if (this.error != null) {
            this.reportException(this.error, "ERROR_GET", null);
            this.notifyAll(new ActionEvent(this, 0, "ERROR"));
        }
    }

    private void getRepertoireDataFromServer() {
        Transaction transaction = null;
        try {
            transaction = new Transaction();
            MOProxy swManagement = new MOProxy((String)this.getParameter("LDNLIST"));
            MOProxy[] availRepertoiresMOs = swManagement.getChildren(1, "Repertoire", "");
            String[] availableRepArray = new String[availRepertoiresMOs.length];
            for (int i = 0; i < availRepertoiresMOs.length; ++i) {
                availableRepArray[i] = (String)availRepertoiresMOs[i].getAttribute("name", transaction.session);
                this.availableRepertoiresTable.put(availableRepArray[i], availRepertoiresMOs[i]);
            }
            transaction.commit();
            transaction.end();
        }
        catch (CSException e) {
            this.error = e;
            try {
                transaction.rollback();
                transaction.end();
            }
            catch (CSException be) {
                Log.logError((String)"Error with transaction", (Throwable)be);
            }
            return;
        }
        this.selectedRepertoiresTable = (TreeMap)((TreeMap)this.getParameter("REPERTOIRE_LIST")).clone();
        for (String key : this.selectedRepertoiresTable.keySet()) {
            this.availableRepertoiresTable.remove(key);
        }
    }

    private void setButtonListeners() {
        this.view.shiftLeftButton.setActionListener((ActionListener)this, "SHIFT_LEFT");
        this.view.shiftRightButton.setActionListener((ActionListener)this, "SHIFT_RIGHT");
        this.view.okButton.setActionListener((ActionListener)this, "OK");
        this.view.applyButton.setActionListener((ActionListener)this, "APPLY");
        this.view.cancelButton.setActionListener((ActionListener)this, "CANCEL");
    }

    private void setTableListeners() {
        this.view.availableRepertoires.setActionListener((ActionListener)this, "AVAILABLE_REPERTOIRES_CHANGED");
        this.view.selectedRepertoires.setActionListener((ActionListener)this, "SELECTED_REPERTOIRES_CHANGED");
    }

    public void actionPerformed(ActionEvent event) {
        JList availableRepList = (JList)this.view.availableRepertoires.getFieldComponent();
        JList selectedRepList = (JList)this.view.selectedRepertoires.getFieldComponent();
        if (event.getActionCommand().equals("ENTRYFIELD_FILLEDIN")) {
            if (availableRepList.hasFocus()) {
                selectedRepList.clearSelection();
                this.view.shiftRightButton.setEnabled(true);
                this.view.shiftLeftButton.setEnabled(false);
            } else if (selectedRepList.hasFocus()) {
                availableRepList.clearSelection();
                this.view.shiftRightButton.setEnabled(false);
                this.view.shiftLeftButton.setEnabled(true);
            }
        } else if (event.getActionCommand().equals("SHIFT_RIGHT") || event.getActionCommand().equals("SHIFT_ALL_RIGHT")) {
            Object[] selectedItems = event.getActionCommand().equals("SHIFT_RIGHT") ? availableRepList.getSelectedValues() : this.availableRepertoiresTable.keySet().toArray(new String[0]);
            int numberOfItemsSelected = selectedItems.length;
            for (int i = 0; i < numberOfItemsSelected; ++i) {
                MOProxy repertoire = (MOProxy)this.availableRepertoiresTable.get((String)selectedItems[i]);
                this.selectedRepertoiresTable.put((String)selectedItems[i], repertoire);
                this.availableRepertoiresTable.remove((String)selectedItems[i]);
            }
            this.updateTables();
            this.setSelections(this.AVAILABLE_REPERTOIRES);
            this.view.applyButton.setEnabled(true);
        } else if (event.getActionCommand().equals("SHIFT_LEFT") || event.getActionCommand().equals("SHIFT_ALL_LEFT")) {
            Object[] selectedItems = event.getActionCommand().equals("SHIFT_LEFT") ? selectedRepList.getSelectedValues() : this.selectedRepertoiresTable.keySet().toArray();
            int numberOfItemsSelected = selectedItems.length;
            for (int i = 0; i < numberOfItemsSelected; ++i) {
                MOProxy repertoire = (MOProxy)this.selectedRepertoiresTable.get((String)selectedItems[i]);
                this.availableRepertoiresTable.put((String)selectedItems[i], repertoire);
                this.selectedRepertoiresTable.remove((String)selectedItems[i]);
            }
            this.updateTables();
            this.setSelections(this.SELECTED_REPERTOIRES);
            this.view.applyButton.setEnabled(true);
        } else if (event.getActionCommand().equals("APPLY")) {
            if (this.askTheUserToConfirm() == 0) {
                this.updateTables();
                this.view.applyButton.setEnabled(false);
                this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
            }
        } else if (event.getActionCommand().equals("OK")) {
            if (this.view.applyButton.isEnabled()) {
                if (this.askTheUserToConfirm() == 0) {
                    this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
                }
            } else {
                this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
            }
        } else if (event.getActionCommand().equals("CANCEL")) {
            this.notifyAll(new ActionEvent(this, event.getID(), event.getActionCommand()));
        }
    }

    private void updateTables() {
        String[] items = this.availableRepertoiresTable.keySet().toArray(new String[0]);
        this.view.availableRepertoires.removeAllItems();
        this.view.availableRepertoires.addItems(items);
        items = this.selectedRepertoiresTable.keySet().toArray(new String[0]);
        this.view.selectedRepertoires.removeAllItems();
        this.view.selectedRepertoires.addItems(items);
    }

    private void setSelections(int type) {
        JList availRep = (JList)this.view.availableRepertoires.getFieldComponent();
        JList selectRep = (JList)this.view.selectedRepertoires.getFieldComponent();
        if (type == this.NO_SELECTION) {
            availRep.clearSelection();
            selectRep.clearSelection();
            this.view.shiftLeftButton.setEnabled(false);
            this.view.shiftRightButton.setEnabled(false);
        } else if (type == this.AVAILABLE_REPERTOIRES) {
            if (this.availableRepertoiresTable.size() > 0) {
                availRep.setSelectedIndex(1);
                selectRep.clearSelection();
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(true);
            } else {
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(false);
            }
        } else if (type == this.SELECTED_REPERTOIRES) {
            if (this.selectedRepertoiresTable.size() > 0) {
                selectRep.setSelectedIndex(1);
                availRep.clearSelection();
                this.view.shiftLeftButton.setEnabled(true);
                this.view.shiftRightButton.setEnabled(false);
            } else {
                this.view.shiftLeftButton.setEnabled(false);
                this.view.shiftRightButton.setEnabled(false);
            }
        }
    }

    public TreeMap getSelectedRepertoires() {
        return (TreeMap)this.selectedRepertoiresTable.clone();
    }

    public boolean canStop() {
        return true;
    }

    private int askTheUserToConfirm() {
        return this.showConfirmDialog("CONFIRM_EDIT_REPERTOIRES_SOFTWARE_ALLOCATION", null, "SOFTWARE_ALLOCATIONS", null, 0, 3, null);
    }
}

