/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.util.Properties;
import se.ericsson.cello.emas.sm.elements.RepertoireElementCreator;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

public class RepertoireElement
extends EmasViewElement {
    private MOProxy repertoire;
    private String repertoireName;
    private String repertoireNumber;
    private String userLabel;

    public RepertoireElement(MOComposite aMoc, Properties aProperties, RepertoireElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, (EmasViewElementCreator)aCreator);
        this.repertoire = aMoc.getMO("Repertoire");
        this.refreshData();
    }

    public String getName() {
        return this.repertoireName;
    }

    public Object getAttributeValue(String aName) {
        String value = null;
        if (aName.equals("ATTR_FAN")) {
            value = this.repertoireNumber;
        } else if (aName.equals("ATTR_TYPE")) {
            value = this.translateKey("REPERTOIRE");
        } else if (aName.equals("ATTR_USERLABEL")) {
            value = this.userLabel;
        }
        return value;
    }

    private void refreshData() throws CSException {
        try {
            this.repertoireNumber = this.repertoire.getId();
            this.repertoireName = this.repertoire.getLastRDN() + ":" + this.repertoire.getAttribute("name", null);
            this.userLabel = (String)this.repertoire.getAttribute("userLabel", null);
        }
        catch (CSException e) {
            Log.logError((String)"Unable to retrieve value ", (Throwable)e);
            throw e;
        }
    }

    public void refresh() {
        try {
            this.refreshData();
        }
        catch (CSException e) {
            Log.logError((String)"refresh failed", (Throwable)e);
        }
    }
}

