/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.util.Properties;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class SwAllocationElement
extends EmasViewElement {
    private String role = "";
    private int numRepertoires;
    private int numSlots;
    private MOProxy swAllocation;
    private String name;
    private String userLabel;

    public SwAllocationElement(MOComposite aMoc, Properties aProperties, EmasViewElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, aCreator);
        this.swAllocation = aMoc.getMO("SwAllocation");
        this.name = this.swAllocation.getLastRDN();
        this.refreshData();
    }

    public String getName() {
        return this.name;
    }

    public Object getAttributeValue(String aName) {
        Object value = null;
        if (aName.equals("ATTR_SWA_ROLE")) {
            value = this.role;
        } else if (aName.equals("ATTR_SWA_NUM_REPERTOIRES")) {
            value = new Integer(this.numRepertoires);
        } else if (aName.equals("ATTR_SWA_NUM_ALLOCATIONS")) {
            value = new Integer(this.numSlots);
        } else if (aName.equals("ATTR_USERLABEL")) {
            value = this.userLabel;
        }
        return value;
    }

    private void refreshData() throws CSException {
        Object moList = null;
        this.role = (String)this.swAllocation.getAttribute("role", null);
        this.numRepertoires = ((MOProxy[])this.swAllocation.getAttribute("repertoireList", null)).length;
        this.numSlots = ((MOProxy[])this.swAllocation.getAttribute("slotList", null)).length;
        this.userLabel = (String)this.swAllocation.getAttribute("userLabel", null);
    }

    public void refresh() {
        try {
            this.refreshData();
        }
        catch (CSException e) {
            Log.logError((String)"refresh failed", (Throwable)e);
        }
    }

    public void attributesChanged(MOProxy aMO, NameValue[] nameValue) {
        for (int i = 0; i < nameValue.length; ++i) {
            if (nameValue[i].name.equals("slotList")) {
                this.numSlots = ((MOProxy[])nameValue[i].value).length;
                this.fireViewElementUpdated();
                continue;
            }
            if (nameValue[i].name.equals("repertoireList")) {
                this.numRepertoires = ((MOProxy[])nameValue[i].value).length;
                this.fireViewElementUpdated();
                continue;
            }
            if (nameValue[i].name.equals("role")) {
                this.role = (String)nameValue[i].value;
                this.fireViewElementUpdated();
                continue;
            }
            if (!nameValue[i].name.equals("userLabel")) continue;
            this.userLabel = (String)nameValue[i].value;
            this.fireViewElementUpdated();
        }
    }
}

