/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.services;

import BasicConfig.Session;
import java.util.Hashtable;
import se.ericsson.cello.emas.sm.services.SubrackNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.Transaction;

public class SlotNameFactory {
    private static String getBoardType(MOProxy slotMo) {
        String boardType = "<empty>";
        try {
            MOProxy[] boardMo = slotMo.getChildren(2, "", "");
            if (boardMo.length > 2) {
                int index;
                String dn = boardMo[2].getDN();
                String board = dn.substring((index = dn.lastIndexOf(",")) + 1);
                if (board.startsWith("Etm1")) {
                    boardType = "ET-M1";
                } else if (board.startsWith("Etm4")) {
                    boardType = "ET-M4";
                } else if (board.startsWith("TimingUnit")) {
                    boardType = "TUB";
                } else if (board.startsWith("Spu")) {
                    boardType = "SPB";
                } else if (board.startsWith("SwitchCoreUnit")) {
                    boardType = "SCB";
                } else if (board.startsWith("SwitchExtensionUnit")) {
                    boardType = "SXB";
                } else if (board.startsWith("GeneralProcessorUnit")) {
                    boardType = "GPB";
                } else if (board.startsWith("TimingUnit")) {
                    boardType = "TUB";
                }
            }
        }
        catch (CSException e) {
            Log.logError((String)"Error determining board type", (Throwable)e);
        }
        return boardType;
    }

    public static Hashtable getAllSlots(Transaction transaction) throws CSException {
        Object subrack = null;
        MOProxy slot = null;
        Object subrackUserLabel = null;
        Object cabinetPos = null;
        Object subrackPos = null;
        Object slotNumber = null;
        Object boardType = null;
        String slotName = null;
        Hashtable<String, MOProxy> results = new Hashtable<String, MOProxy>(50);
        MOProxy rootMo = MOProxy.getRoot((Session)transaction.session);
        MOProxy[] subracks = rootMo.getChildren(2, "Subrack", "", transaction.session);
        for (int i = 0; i < subracks.length; ++i) {
            MOProxy[] slots = subracks[i].getChildren(1, "Slot", "", transaction.session);
            String subrackName = SubrackNameFactory.getInstance().getSubrackName(subracks[i]);
            for (int slotCount = 0; slotCount < slots.length; ++slotCount) {
                slot = slots[slotCount];
                slotName = subrackName + ":" + slot.getLastRDN();
                results.put(slotName, slot);
            }
        }
        return results;
    }

    public static String getSlotName(MOProxy aSlot) {
        String slotName = "";
        if (aSlot.getType().equals("Slot")) {
            MOProxy subrack = aSlot.getParent();
            slotName = SubrackNameFactory.getInstance().getSubrackName(subrack);
            slotName = slotName + ":" + aSlot.getLastRDN();
        } else {
            slotName = slotName + aSlot.getLastRDN();
        }
        return slotName;
    }
}

