/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.event.ActionListener;
import java.util.Hashtable;
import se.ericsson.cello.support.gui.gengui.GenMenu;
import se.ericsson.cello.support.gui.gengui.GenMenuItem;
import se.ericsson.cello.support.gui.guilib.comp.Log;

class ApplicationTreeModel
extends GenMenu {
    private static final long serialVersionUID = 3593828889363797305L;
    private static final int MAX_MENU_LEVELS = 10;
    private Hashtable nodeLevelRem = new Hashtable(10);
    private boolean[] levelUsed = new boolean[10];

    public ApplicationTreeModel(GenMenu root) {
        Log.trace("ApplicationTreeModel(" + root + ")");
        this.nodeLevelRem.put(new Integer(0), root);
        this.levelUsed[0] = true;
    }

    public void addFolder(String translations, String tag, int indentLevel) {
        Log.trace("addFolder( " + translations + ", " + tag + ", " + indentLevel + " )");
        if (indentLevel < 0 || indentLevel >= 10 || !this.levelUsed[indentLevel]) {
            Log.trace("Error in menu; ignore this entry");
            return;
        }
        GenMenu thisNode = new GenMenu(translations, tag);
        GenMenu parentNode = (GenMenu)this.nodeLevelRem.get(new Integer(indentLevel));
        parentNode.add(thisNode);
        this.nodeLevelRem.put(new Integer(indentLevel + 1), thisNode);
        this.levelUsed[indentLevel + 1] = true;
    }

    public void addLink(String translations, String tag, String cmd, int indentLevel, ActionListener al) {
        Log.trace("addLink( " + translations + ", " + tag + ", " + cmd + ", " + indentLevel + " )");
        if (indentLevel < 1 || indentLevel >= 10 || !this.levelUsed[indentLevel]) {
            Log.trace("Error in menu; ignore this entry");
            return;
        }
        GenMenuItem thisNode = new GenMenuItem(translations, tag, al, cmd);
        GenMenu parentNode = (GenMenu)this.nodeLevelRem.get(new Integer(indentLevel));
        parentNode.add(thisNode);
    }

    public void removeAllItems() {
        this.nodeLevelRem.clear();
        this.nodeLevelRem = null;
    }
}

