/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import se.ericsson.cello.support.gui.EmasLaunchableInterface;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.ErrorReporter;

public class LaunchExternalApplication
extends Thread {
    private String host = null;
    private ApplicationManager applicationManager;
    private MainWindowController mainwindow;
    private String method_id = null;
    private Object[] parameter = null;
    private String configpath = null;
    private EmasLaunchableInterface applicationToStart;
    private MainWindowController mainwindowcontroller;

    public LaunchExternalApplication(String host, ApplicationManager applicationManager, MainWindowController mainwindow, String method_id, Object[] parameter, String configpath, MainWindowController maincontroller) {
        this.applicationManager = applicationManager;
        this.host = host;
        this.mainwindow = mainwindow;
        this.method_id = method_id;
        this.parameter = parameter;
        this.configpath = configpath;
        this.mainwindowcontroller = maincontroller;
        this.applicationToStart = maincontroller.getOeApplication();
    }

    public void run() {
        try {
            Log.logNotify("Trying to initiate with config.xml path = " + this.configpath + " ********");
            if (!this.applicationManager.isApplicationsRunning(this.applicationToStart)) {
                this.applicationToStart = (EmasLaunchableInterface)this.applicationManager.runApplication(this.configpath);
                this.mainwindowcontroller.setOeApplication(this.applicationToStart);
            }
            if (this.applicationToStart != null) {
                Log.logNotify("Application  succed to started *******");
                this.mainwindow.getApplication().setCursor(Application.WAIT_CURSOR);
                this.mainwindow.updateExternalApplicationsLogging(this.applicationToStart);
                this.applicationToStart.genMethod(this.method_id, this.parameter);
                Log.logNotify("Returned from method ");
                this.mainwindow.getApplication().setCursor(Application.DEFAULT_CURSOR);
            } else {
                Log.logNotify("Application  could not start external application *******");
            }
        }
        catch (RuntimeException re) {
            ErrorReporter.getReporter().reportException(this.mainwindow, re, "The application can not be started");
        }
        catch (Exception x) {
            Log.logError("Error launching External appliaction!", x);
        }
    }
}

