/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import se.ericsson.cello.support.gui.gengui.ComponentLayout;
import se.ericsson.cello.support.gui.gengui.GenGroupBox;

public class ComponentBoxLayout
extends BoxLayout {
    private static final long serialVersionUID = 6410426176670411617L;
    private boolean master = true;
    private int max = 0;

    public ComponentBoxLayout(Container container) {
        super(container, 1);
    }

    public void layoutContainer(Container parent) {
        if (this.master) {
            this.max = this.getSecondPosition(parent, this.max);
        }
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component myComponent = parent.getComponent(i);
            try {
                LayoutManager layoutManager = ((JComponent)myComponent).getLayout();
                if (layoutManager instanceof ComponentLayout) {
                    ComponentLayout c = (ComponentLayout)layoutManager;
                    c.setSecondPos(this.max);
                    continue;
                }
                if (!(layoutManager instanceof ComponentBoxLayout)) continue;
                int leftOffset = 0;
                if (myComponent instanceof GenGroupBox) {
                    GenGroupBox g = (GenGroupBox)myComponent;
                    leftOffset = g.getBorder().getBorderInsets((Component)g).left;
                }
                ComponentBoxLayout c = (ComponentBoxLayout)layoutManager;
                c.setMax(this.max - leftOffset);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        super.layoutContainer(parent);
    }

    private int getSecondPosition(Container parent, int maxi) {
        int maximum = maxi;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component myComponent = parent.getComponent(i);
            try {
                LayoutManager c;
                LayoutManager layoutManager = ((JComponent)myComponent).getLayout();
                if (layoutManager instanceof ComponentLayout) {
                    c = (ComponentLayout)layoutManager;
                    int maxComp = ((ComponentLayout)c).getSecondPos(parent);
                    if (maximum >= maxComp) continue;
                    maximum = maxComp;
                    continue;
                }
                if (!(layoutManager instanceof ComponentBoxLayout)) continue;
                c = (ComponentBoxLayout)layoutManager;
                int maxComponentBoxLayout = super.getSecondPosition((Container)myComponent, maximum);
                if (maximum < maxComponentBoxLayout) {
                    maximum = maxComponentBoxLayout;
                }
                super.setSlave();
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return maximum;
    }

    private void setSlave() {
        this.master = false;
    }

    private void setMax(int maximum) {
        this.max = maximum;
    }
}

