/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.ui.date.DateField;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;

public class GenDateField
extends LabelledField
implements FocusListener,
LocaleChangeListener {
    private static final long serialVersionUID = -4785744662399718524L;
    private DateField datefield = null;
    private Calendar calendar;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private Date value = null;
    private Color myRedColor = new Color(204, 0, 0);
    private boolean faultyValueEntered = false;

    public GenDateField(String translations, String tag) {
        super(translations, tag);
        this.datefield = new DateField(new Locale("en", "US"), 2);
        this.datefield.addFocusListener(this);
        this.datefield.getDocument().addDocumentListener(new MyDocumentListener());
        this.datefield.setColumns(10);
        this.datefield.setMinimumSize(this.datefield.getPreferredSize());
        this.add(this.datefield);
    }

    public GenDateField(String tag) {
        super(tag);
        this.datefield = new DateField(new Locale("en", "US"), 2);
        this.datefield.addFocusListener(this);
        this.datefield.getDocument().addDocumentListener(new MyDocumentListener());
        this.datefield.setColumns(10);
        this.datefield.setMinimumSize(this.datefield.getPreferredSize());
        this.datefield.putClientProperty("LANGUAGE_CONTROLLED", "OT");
        this.add(this.datefield);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    public void setValue(Date date) {
        Log.trace("setValue()");
        this.datefield.setDate(date);
        this.value = date;
        this.datefield.copyDate();
    }

    public Date getValue() {
        Log.trace("getValue()");
        return this.value;
    }

    public void focusLost(FocusEvent e) {
        if (this.faultyValueEntered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        } else if (null != this.value) {
            this.datefield.copyDate();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.datefield;
    }

    public void updateLocale(Locale locale) {
        Log.traceFlow();
        super.updateLocale(locale);
        this.datefield.setLocale(locale);
    }

    public boolean isFilledIn() {
        return this.value != null;
    }

    public boolean faultyValueEntered() {
        return this.faultyValueEntered;
    }

    private void checkAndUpdate() {
        Date d;
        if (this.datefield.getText().equals("")) {
            this.value = null;
            this.faultyValueEntered = false;
            this.datefield.setForeground(Color.black);
            return;
        }
        try {
            d = this.datefield.getParser().parseDate(this.datefield.getText());
        }
        catch (Exception ex) {
            d = null;
        }
        if (null == d) {
            this.datefield.setForeground(this.myRedColor);
            this.value = null;
            this.faultyValueEntered = true;
            return;
        }
        this.faultyValueEntered = false;
        this.datefield.setForeground(Color.black);
        if (!d.equals(this.value)) {
            this.value = d;
            this.datefield.setDate(this.value);
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
            }
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            GenDateField.this.checkAndUpdate();
        }

        public void removeUpdate(DocumentEvent e) {
            GenDateField.this.checkAndUpdate();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

