/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.TranslatableBitLabel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public class LinkStateBitField
extends LabelledField {
    private static final long serialVersionUID = 7850501197746300714L;
    private TranslatableBitLabel bitLabel = null;
    private Class enumeration = null;
    private String translations = null;

    public LinkStateBitField(String labelTag, Class enume) {
        super(labelTag);
        this.bitLabel = new TranslatableBitLabel();
        this.add(this.bitLabel);
        this.enumeration = enume;
    }

    public LinkStateBitField(String translations, String labelTag, Class enume) {
        super(translations, labelTag);
        this.translations = translations;
        this.bitLabel = new TranslatableBitLabel();
        this.add(this.bitLabel);
        this.enumeration = enume;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.bitLabel;
    }

    public void setValue(Integer bits) {
        Vector<String> bitsToDisplay = new Vector<String>();
        int value = bits;
        try {
            bitsToDisplay.addElement(this.getStringFromEnumeration(new Integer(value)));
        }
        catch (IllegalArgumentException e) {
            bitsToDisplay.addElement("UNKNOWN BIT " + value);
        }
        this.bitLabel.setTranslatableTags(bitsToDisplay.toArray());
        this.layoutComponent();
    }

    private String getStringFromEnumeration(Integer i) throws IllegalArgumentException {
        try {
            Method getMethod = this.enumeration.getMethod("get", Object.class);
            Object enumPart = getMethod.invoke((Object)this.enumeration, i);
            return enumPart.toString();
        }
        catch (NoSuchMethodException e) {
            Log.logError("Class is not an enumeration does not have method get( Object )", e);
            throw new IllegalArgumentException();
        }
        catch (SecurityException s) {
            Log.logError("SEcurity problem", s);
            throw new IllegalArgumentException();
        }
        catch (IllegalAccessException l) {
            Log.logError("Illegal access on class", l);
            throw new IllegalArgumentException();
        }
        catch (InvocationTargetException t) {
            Log.logError("Invocation error", t);
            throw new IllegalArgumentException();
        }
        catch (NullPointerException n) {
            Log.logError("Bit " + i + " is not defined");
            throw new IllegalArgumentException();
        }
    }

    public void updateLocale(Locale locale) {
        ResourceBundle rb = null;
        try {
            rb = GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader());
            this.bitLabel.translate(rb, locale);
        }
        catch (MissingResourceException mre) {
            Log.logError("Bundle " + this.translations + " not found");
        }
        super.updateLocale(locale);
        this.translateTooltip(locale);
        this.layoutComponent();
    }
}

