/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JTextArea;
import se.ericsson.cello.support.gui.guilib.infra.Translatable;

class TranslatableTextArea
extends JTextArea
implements Translatable {
    private static final long serialVersionUID = -6399205704944691727L;
    private String translatableTag;
    private ResourceBundle myBundle;

    TranslatableTextArea(int a, int b) {
        super(a, b);
    }

    TranslatableTextArea() {
    }

    void setBundle(ResourceBundle bundle) {
        this.myBundle = bundle;
        this.updateLocale();
    }

    void setTranslatableText(String tag) {
        this.translatableTag = tag;
        if (this.myBundle != null) {
            this.updateLocale();
        }
    }

    void updateLocale() {
        if (this.translatableTag != null) {
            try {
                this.setText(this.myBundle.getString(this.translatableTag));
            }
            catch (MissingResourceException mre) {
                this.setText(this.translatableTag);
            }
        }
    }

    public void translate(ResourceBundle bundle, Locale locale) {
        this.myBundle = bundle;
        this.updateLocale();
    }
}

